/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import org.apache.batchee.container.ExecutionElementController;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.StepExecutionImpl;
import org.apache.batchee.container.impl.controller.chunk.PersistentDataWrapper;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.container.status.StepStatus;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.PersistenceManagerService;
import org.apache.batchee.spi.TransactionManagementService;
import org.apache.batchee.spi.TransactionManagerAdapter;

public abstract class BaseStepController
implements ExecutionElementController {
    private static final Logger LOGGER = Logger.getLogger(BaseStepController.class.getName());
    protected RuntimeJobExecution jobExecutionImpl;
    protected JobInstance jobInstance;
    protected StepContextImpl stepContext;
    protected Step step;
    protected StepStatus stepStatus;
    protected BlockingQueue<PartitionDataWrapper> analyzerStatusQueue = null;
    protected long rootJobExecutionId;
    protected final BatchKernelService kernelService;
    protected final PersistenceManagerService persistenceManagerService;
    private final JobStatusManagerService statusManagerService;
    protected TransactionManagerAdapter transactionManager = null;
    private TransactionManagementService txService;

    protected BaseStepController(RuntimeJobExecution jobExecution, Step step, StepContextImpl stepContext, long rootJobExecutionId, ServicesManager servicesManager) {
        this.jobExecutionImpl = jobExecution;
        this.jobInstance = jobExecution.getJobInstance();
        this.stepContext = stepContext;
        this.rootJobExecutionId = rootJobExecutionId;
        if (step == null) {
            throw new IllegalArgumentException("Step parameter to ctor cannot be null.");
        }
        this.step = step;
        this.txService = servicesManager.service(TransactionManagementService.class);
        this.kernelService = servicesManager.service(BatchKernelService.class);
        this.persistenceManagerService = servicesManager.service(PersistenceManagerService.class);
        this.statusManagerService = servicesManager.service(JobStatusManagerService.class);
    }

    protected BaseStepController(RuntimeJobExecution jobExecution, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue, ServicesManager servicesManager) {
        this(jobExecution, step, stepContext, rootJobExecutionId, servicesManager);
        this.analyzerStatusQueue = analyzerStatusQueue;
    }

    protected abstract void invokeCoreStep() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException;

    protected abstract void setupStepArtifacts();

    protected abstract void invokePreStepArtifacts();

    protected abstract void invokePostStepArtifacts();

    protected abstract void sendStatusFromPartitionToAnalyzerIfPresent();

    @Override
    public ExecutionStatus execute() {
        try {
            boolean executeStep = this.shouldStepBeExecuted();
            if (!executeStep) {
                return new ExecutionStatus(ExtendedBatchStatus.DO_NOT_RUN, this.stepStatus.getExitStatus());
            }
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            this.rethrowWithMsg("Caught throwable while determining if step should be executed.  Failing job.", t);
        }
        try {
            this.startStep();
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            this.rethrowWithMsg("Caught throwable while starting step.  Failing job.", t);
        }
        try {
            this.invokePreStepArtifacts();
            this.invokeCoreStep();
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                this.markStepFailed();
            }
            catch (Throwable t) {
                this.rethrowWithMsg("ERROR. PERSISTING BATCH STATUS FAILED.  STEP EXECUTION STATUS TABLES MIGHT HAVE CONSISTENCY ISSUESAND/OR UNEXPECTED ENTRIES.", t);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            this.markJobAndStepFailed();
        }
        try {
            this.invokePostStepArtifacts();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            this.markStepFailed();
        }
        try {
            this.persistUserData();
            this.transitionToFinalBatchStatus();
            this.defaultExitStatusIfNecessary();
            this.persistExitStatusAndEndTimestamp();
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            this.rethrowWithMsg("Failure ending step execution", t);
        }
        this.sendStatusFromPartitionToAnalyzerIfPresent();
        if (this.stepStatus.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
            return new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, this.stepStatus.getExitStatus());
        }
        return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, this.stepStatus.getExitStatus());
    }

    private void defaultExitStatusIfNecessary() {
        String stepExitStatus = this.stepContext.getExitStatus();
        String processRetVal = this.stepContext.getBatchletProcessRetVal();
        if (stepExitStatus == null) {
            if (processRetVal != null) {
                this.stepContext.setExitStatus(processRetVal);
            } else {
                this.stepContext.setExitStatus(this.stepContext.getBatchStatus().name());
            }
        }
    }

    private void markStepFailed() {
        this.updateBatchStatus(BatchStatus.FAILED);
    }

    protected void markJobAndStepFailed() {
        this.jobExecutionImpl.getJobContext().setBatchStatus(BatchStatus.FAILED);
        this.markStepFailed();
    }

    private void startStep() {
        this.statusStarting();
        this.setContextProperties();
        this.setupStepArtifacts();
        this.updateBatchStatus(BatchStatus.STARTED);
        long time = System.currentTimeMillis();
        Timestamp startTS = new Timestamp(time);
        this.stepContext.setStartTime(startTS);
        this.persistenceManagerService.updateStepExecution(this.rootJobExecutionId, this.stepContext);
    }

    private void transitionToFinalBatchStatus() {
        BatchStatus currentBatchStatus = this.stepContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            this.updateBatchStatus(BatchStatus.COMPLETED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            this.updateBatchStatus(BatchStatus.STOPPED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
            this.updateBatchStatus(BatchStatus.FAILED);
        } else {
            throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
        }
    }

    protected void updateBatchStatus(BatchStatus updatedBatchStatus) {
        this.stepStatus.setBatchStatus(updatedBatchStatus);
        this.statusManagerService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(updatedBatchStatus);
    }

    protected boolean shouldStepBeExecuted() {
        this.stepStatus = this.statusManagerService.getStepStatus(this.jobInstance.getInstanceId(), this.step.getId());
        if (this.stepStatus == null) {
            StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecutionId, this.stepContext);
            this.stepStatus = this.statusManagerService.createStepStatus(stepExecution.getStepExecutionId());
            this.stepContext.setInternalStepExecutionId(stepExecution.getStepExecutionId());
            this.stepContext.setStepExecutionId(stepExecution.getStepExecutionId());
            return true;
        }
        this.stepContext.setPersistentUserData(this.stepStatus.getPersistentUserData());
        if (this.shouldStepBeExecutedOnRestart()) {
            this.stepStatus.incrementStartCount();
            StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecutionId, this.stepContext);
            long stepExecutionId = stepExecution.getStepExecutionId();
            this.stepStatus.setLastRunStepExecutionId(stepExecutionId);
            this.stepContext.setStepExecutionId(stepExecutionId);
            this.stepContext.setInternalStepExecutionId(stepExecutionId);
            return true;
        }
        return false;
    }

    private boolean shouldStepBeExecutedOnRestart() {
        int newStepStartCount;
        BatchStatus stepBatchStatus = this.stepStatus.getBatchStatus();
        if (stepBatchStatus.equals((Object)BatchStatus.COMPLETED) && !Boolean.parseBoolean(this.step.getAllowStartIfComplete())) {
            return false;
        }
        int startLimit = 0;
        String startLimitString = this.step.getStartLimit();
        if (startLimitString != null) {
            try {
                startLimit = Integer.parseInt(startLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse start limit value.  Received NumberFormatException for start-limit value:  " + startLimitString + " for stepId: " + this.step.getId() + ", with start-limit=" + this.step.getStartLimit());
            }
        }
        if (startLimit < 0) {
            throw new IllegalArgumentException("Found negative start-limit of " + startLimit + "for stepId: " + this.step.getId());
        }
        if (startLimit > 0 && (newStepStartCount = this.stepStatus.getStartCount() + 1) > startLimit) {
            throw new IllegalStateException("For stepId: " + this.step.getId() + ", tried to start step for the " + newStepStartCount + " time, but startLimit = " + startLimit);
        }
        return true;
    }

    protected void statusStarting() {
        this.stepStatus.setBatchStatus(BatchStatus.STARTING);
        this.statusManagerService.updateJobCurrentStep(this.jobInstance.getInstanceId(), this.step.getId());
        this.statusManagerService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.STARTING);
    }

    protected void persistUserData() {
        ByteArrayOutputStream persistentBAOS = new ByteArrayOutputStream();
        try {
            ObjectOutputStream persistentDataOOS = new ObjectOutputStream(persistentBAOS);
            persistentDataOOS.writeObject(this.stepContext.getPersistentUserData());
            persistentDataOOS.close();
        }
        catch (Exception e) {
            throw new BatchContainerServiceException("Cannot persist the persistent user data for the step.", e);
        }
        this.stepStatus.setPersistentUserData(new PersistentDataWrapper(persistentBAOS.toByteArray()));
        this.statusManagerService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
    }

    protected void persistExitStatusAndEndTimestamp() {
        this.stepStatus.setExitStatus(this.stepContext.getExitStatus());
        this.statusManagerService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        long time = System.currentTimeMillis();
        Timestamp endTS = new Timestamp(time);
        this.stepContext.setEndTime(endTS);
        this.persistenceManagerService.updateStepExecution(this.rootJobExecutionId, this.stepContext);
    }

    private StepExecutionImpl getNewStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        return this.persistenceManagerService.createStepExecution(rootJobExecutionId, stepContext);
    }

    private void setContextProperties() {
        JSLProperties jslProps = this.step.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.stepContext.getProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
        this.stepContext.addMetric(Metric.MetricType.READ_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.READ_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.PROCESS_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.FILTER_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.COMMIT_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.ROLLBACK_COUNT, 0L);
        this.transactionManager = this.txService.getTransactionManager(this.stepContext);
    }

    public void setStepContext(StepContextImpl stepContext) {
        this.stepContext = stepContext;
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        ArrayList<Long> stepExecIdList = new ArrayList<Long>(1);
        stepExecIdList.add(this.stepStatus.getLastRunStepExecutionId());
        return stepExecIdList;
    }

    private void rethrowWithMsg(String msgBeginning, Throwable t) {
        String errorMsg = msgBeginning + " ; Caught exception/error: " + t.getLocalizedMessage();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        throw new BatchContainerRuntimeException(errorMsg, t);
    }

    public String toString() {
        return "BaseStepController for step = " + this.step.getId();
    }

    public void setParentStepContext(StepContextImpl parentStepContext) {
        if (parentStepContext != null) {
            this.stepContext.setStepExecutionId(parentStepContext.getStepExecutionId());
        }
    }
}

