/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.spi.PersistenceManagerService;

public class JobExecutionImpl
implements InternalJobExecution {
    private final PersistenceManagerService persistenceManagerService;
    private long executionID = 0L;
    private long instanceID = 0L;
    private Timestamp createTime;
    private Timestamp startTime;
    private Timestamp endTime;
    private Timestamp updateTime;
    private String batchStatus;
    private String exitStatus;
    private Properties jobProperties = null;
    private String jobName = null;
    private JobContextImpl jobContext = null;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public void setJobContext(JobContextImpl jobContext) {
        this.jobContext = jobContext;
    }

    public JobExecutionImpl(long executionId, long instanceId, PersistenceManagerService persistenceManagerService) {
        this.persistenceManagerService = persistenceManagerService;
        this.executionID = executionId;
        this.instanceID = instanceId;
    }

    public BatchStatus getBatchStatus() {
        if (this.jobContext != null) {
            return this.jobContext.getBatchStatus();
        }
        String name = this.persistenceManagerService.jobOperatorQueryJobExecutionBatchStatus(this.executionID);
        if (name != null) {
            return BatchStatus.valueOf((String)name);
        }
        return BatchStatus.valueOf((String)this.batchStatus);
    }

    public Date getCreateTime() {
        Timestamp ts = this.persistenceManagerService.jobOperatorQueryJobExecutionTimestamp(this.executionID, PersistenceManagerService.TimestampType.CREATE);
        if (ts != null) {
            this.createTime = ts;
        }
        if (this.createTime != null) {
            return new Date(this.createTime.getTime());
        }
        return null;
    }

    public Date getEndTime() {
        Timestamp ts = this.persistenceManagerService.jobOperatorQueryJobExecutionTimestamp(this.executionID, PersistenceManagerService.TimestampType.END);
        if (ts != null) {
            this.endTime = ts;
        }
        if (this.endTime != null) {
            return new Date(this.endTime.getTime());
        }
        return null;
    }

    public long getExecutionId() {
        return this.executionID;
    }

    public String getExitStatus() {
        if (this.jobContext != null) {
            return this.jobContext.getExitStatus();
        }
        String persistenceExitStatus = this.persistenceManagerService.jobOperatorQueryJobExecutionExitStatus(this.executionID);
        if (persistenceExitStatus != null) {
            this.exitStatus = persistenceExitStatus;
        }
        return this.exitStatus;
    }

    public Date getLastUpdatedTime() {
        Timestamp ts = this.persistenceManagerService.jobOperatorQueryJobExecutionTimestamp(this.executionID, PersistenceManagerService.TimestampType.LAST_UPDATED);
        if (ts != null) {
            this.updateTime = ts;
        }
        if (this.updateTime != null) {
            return new Date(this.updateTime.getTime());
        }
        return null;
    }

    public Date getStartTime() {
        Timestamp ts = this.persistenceManagerService.jobOperatorQueryJobExecutionTimestamp(this.executionID, PersistenceManagerService.TimestampType.STARTED);
        if (ts != null) {
            this.startTime = ts;
        }
        if (this.startTime != null) {
            return new Date(this.startTime.getTime());
        }
        return null;
    }

    public Properties getJobParameters() {
        return this.jobProperties;
    }

    @Override
    public void setBatchStatus(String status) {
        this.batchStatus = status;
    }

    @Override
    public void setCreateTime(Timestamp ts) {
        this.createTime = ts;
    }

    @Override
    public void setEndTime(Timestamp ts) {
        this.endTime = ts;
    }

    public void setExecutionId(long id) {
        this.executionID = id;
    }

    public void setJobInstanceId(long jobInstanceID) {
        this.instanceID = jobInstanceID;
    }

    @Override
    public void setExitStatus(String status) {
        this.exitStatus = status;
    }

    public void setInstanceId(long id) {
        this.instanceID = id;
    }

    @Override
    public void setLastUpdateTime(Timestamp ts) {
        this.updateTime = ts;
    }

    @Override
    public void setStartTime(Timestamp ts) {
        this.startTime = ts;
    }

    @Override
    public void setJobParameters(Properties jProps) {
        this.jobProperties = jProps;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Override
    public long getInstanceId() {
        return this.instanceID;
    }

    public String toString() {
        return "createTime=" + this.createTime + ",batchStatus=" + this.batchStatus + ",exitStatus=" + this.exitStatus + ",jobName=" + this.jobName + ",instanceId=" + this.instanceID + ",executionId=" + this.executionID;
    }
}

