/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.cdi;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.operations.BatchRuntimeException;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.batchee.container.cdi.BatchProducerBean;

public class BatchCDIInjectionExtension
implements Extension {
    private static final boolean CDI_1_1_AVAILABLE;
    private static final Method CDI_CURRENT_METHOD;
    private static final Method CDI_GET_BEAN_MANAGER_METHOD;
    private static BatchCDIInjectionExtension bmpSingleton;
    private volatile Map<ClassLoader, BeanManagerInfo> bmInfos = new ConcurrentHashMap<ClassLoader, BeanManagerInfo>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        bbd.addAnnotatedType(bm.createAnnotatedType(BatchProducerBean.class));
    }

    public void setBeanManager(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (bmpSingleton == null) {
            bmpSingleton = this;
        }
        if (!CDI_1_1_AVAILABLE) {
            BeanManagerInfo bmi = this.getBeanManagerInfo(BatchCDIInjectionExtension.loader());
            bmi.loadTimeBm = beanManager;
        }
    }

    public void cleanupFinalBeanManagers(@Observes AfterDeploymentValidation adv) {
        if (!CDI_1_1_AVAILABLE) {
            for (BeanManagerInfo bmi : BatchCDIInjectionExtension.bmpSingleton.bmInfos.values()) {
                bmi.finalBm = null;
            }
        }
    }

    public void cleanupStoredBeanManagerOnShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (CDI_1_1_AVAILABLE || bmpSingleton == null) {
            return;
        }
        BatchCDIInjectionExtension.bmpSingleton.bmInfos.remove(BatchCDIInjectionExtension.loader());
    }

    private static ClassLoader loader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static BatchCDIInjectionExtension getInstance() {
        return bmpSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanManager getBeanManager() {
        if (CDI_1_1_AVAILABLE) {
            try {
                return (BeanManager)CDI_GET_BEAN_MANAGER_METHOD.invoke(CDI_CURRENT_METHOD.invoke(null, new Object[0]), new Object[0]);
            }
            catch (Exception e) {
                throw new BatchRuntimeException("unable to resolve BeanManager");
            }
        }
        BeanManagerInfo bmi = this.getBeanManagerInfo(BatchCDIInjectionExtension.loader());
        BeanManager result = bmi.finalBm;
        if (result == null && bmi.cdi == null) {
            BatchCDIInjectionExtension batchCDIInjectionExtension = this;
            synchronized (batchCDIInjectionExtension) {
                result = BatchCDIInjectionExtension.resolveBeanManagerViaJndi();
                if (result == null) {
                    result = bmi.loadTimeBm;
                }
                if (result == null) {
                    bmi.cdi = false;
                    return null;
                }
                bmi.cdi = true;
                bmi.finalBm = result;
            }
        }
        return result;
    }

    private static BeanManager resolveBeanManagerViaJndi() {
        try {
            return (BeanManager)BeanManager.class.cast(new InitialContext().lookup("java:comp/BeanManager"));
        }
        catch (NamingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManagerInfo getBeanManagerInfo(ClassLoader cl) {
        BeanManagerInfo bmi = BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(cl);
        if (bmi == null) {
            BatchCDIInjectionExtension batchCDIInjectionExtension = this;
            synchronized (batchCDIInjectionExtension) {
                for (ClassLoader key : BatchCDIInjectionExtension.bmpSingleton.bmInfos.keySet()) {
                    if (key.getParent() != cl) continue;
                    return BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(key);
                }
                bmi = BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(cl);
                if (bmi == null) {
                    bmi = new BeanManagerInfo();
                    BatchCDIInjectionExtension.bmpSingleton.bmInfos.put(cl, bmi);
                }
            }
        }
        return bmi;
    }

    static {
        boolean cdi11Available;
        Method getBmMethod;
        Method currentMethod;
        bmpSingleton = null;
        try {
            Class<?> cdi = Class.forName("javax.enterprise.inject.spi.CDI", false, BatchCDIInjectionExtension.loader());
            currentMethod = cdi.getDeclaredMethod("current", new Class[0]);
            getBmMethod = cdi.getDeclaredMethod("getBeanManager", new Class[0]);
            cdi11Available = true;
        }
        catch (Exception e) {
            currentMethod = null;
            getBmMethod = null;
            cdi11Available = false;
        }
        CDI_CURRENT_METHOD = currentMethod;
        CDI_GET_BEAN_MANAGER_METHOD = getBmMethod;
        CDI_1_1_AVAILABLE = cdi11Available;
    }

    private static class BeanManagerInfo {
        private BeanManager loadTimeBm = null;
        private BeanManager finalBm = null;
        private Boolean cdi = null;

        private BeanManagerInfo() {
        }
    }
}

