/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.util;

import java.util.Arrays;
import java.util.Collection;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.impl.JobOperatorImpl;

public class Batches {
    private static final Collection<BatchStatus> BATCH_END_STATUSES = Arrays.asList(BatchStatus.COMPLETED, BatchStatus.FAILED, BatchStatus.STOPPED, BatchStatus.ABANDONED);

    private Batches() {
    }

    public static void waitForEnd(long id) {
        Batches.waitForEnd(BatchRuntime.getJobOperator(), id);
    }

    public static void waitForEnd(JobOperator jobOperator, long id) {
        if (JobOperatorImpl.class.isInstance(jobOperator)) {
            ((JobOperatorImpl)JobOperatorImpl.class.cast(jobOperator)).waitFor(id);
            return;
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        } while (!Batches.isDone(jobOperator, id));
    }

    public static boolean isDone(BatchStatus status) {
        return BATCH_END_STATUSES.contains(status);
    }

    public static boolean isDone(JobOperator jobOperator, long id) {
        return BATCH_END_STATUSES.contains(jobOperator.getJobExecution(id).getBatchStatus());
    }
}

