/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import javax.batch.api.Batchlet;
import javax.batch.api.Decider;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.ItemProcessor;
import javax.batch.api.chunk.ItemReader;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.api.partition.PartitionAnalyzer;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.api.partition.PartitionMapper;
import javax.batch.api.partition.PartitionReducer;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.BatchletProxy;
import org.apache.batchee.container.proxy.CheckpointAlgorithmProxy;
import org.apache.batchee.container.proxy.DeciderProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ItemProcessorProxy;
import org.apache.batchee.container.proxy.ItemReaderProxy;
import org.apache.batchee.container.proxy.ItemWriterProxy;
import org.apache.batchee.container.proxy.PartitionAnalyzerProxy;
import org.apache.batchee.container.proxy.PartitionCollectorProxy;
import org.apache.batchee.container.proxy.PartitionMapperProxy;
import org.apache.batchee.container.proxy.PartitionReducerProxy;
import org.apache.batchee.spi.BatchArtifactFactory;

public class ProxyFactory {
    private static final ThreadLocal<InjectionReferences> INJECTION_CONTEXT = new ThreadLocal();

    private ProxyFactory() {
    }

    protected static Object loadArtifact(BatchArtifactFactory factory, String id, InjectionReferences injectionReferences, RuntimeJobExecution execution) {
        INJECTION_CONTEXT.set(injectionReferences);
        try {
            BatchArtifactFactory.Instance instance = factory.load(id);
            if (instance == null) {
                Object var5_6 = null;
                return var5_6;
            }
            if (instance.getReleasable() != null && execution != null) {
                execution.addReleasable(instance.getReleasable());
            }
            Object object = instance.getValue();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            INJECTION_CONTEXT.remove();
        }
    }

    public static InjectionReferences getInjectionReferences() {
        return INJECTION_CONTEXT.get();
    }

    public static DeciderProxy createDeciderProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        return new DeciderProxy((Decider)Decider.class.cast(ProxyFactory.loadArtifact(factory, id, injectionRefs, execution)));
    }

    public static BatchletProxy createBatchletProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        Batchlet loadedArtifact = (Batchlet)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        BatchletProxy proxy = new BatchletProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static CheckpointAlgorithmProxy createCheckpointAlgorithmProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        CheckpointAlgorithm loadedArtifact = (CheckpointAlgorithm)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        CheckpointAlgorithmProxy proxy = new CheckpointAlgorithmProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemReaderProxy createItemReaderProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        ItemReader loadedArtifact = (ItemReader)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        ItemReaderProxy proxy = new ItemReaderProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemProcessorProxy createItemProcessorProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        ItemProcessor loadedArtifact = (ItemProcessor)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        ItemProcessorProxy proxy = new ItemProcessorProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemWriterProxy createItemWriterProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        ItemWriter loadedArtifact = (ItemWriter)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        ItemWriterProxy proxy = new ItemWriterProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionReducerProxy createPartitionReducerProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        PartitionReducer loadedArtifact = (PartitionReducer)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        PartitionReducerProxy proxy = new PartitionReducerProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionMapperProxy createPartitionMapperProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        PartitionMapper loadedArtifact = (PartitionMapper)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        PartitionMapperProxy proxy = new PartitionMapperProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionAnalyzerProxy createPartitionAnalyzerProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        PartitionAnalyzer loadedArtifact = (PartitionAnalyzer)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        PartitionAnalyzerProxy proxy = new PartitionAnalyzerProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionCollectorProxy createPartitionCollectorProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        PartitionCollector loadedArtifact = (PartitionCollector)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        PartitionCollectorProxy proxy = new PartitionCollectorProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }
}

