/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.api.listener.JobListener;
import javax.batch.api.listener.StepListener;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.ChunkListenerProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ItemProcessListenerProxy;
import org.apache.batchee.container.proxy.ItemReadListenerProxy;
import org.apache.batchee.container.proxy.ItemWriteListenerProxy;
import org.apache.batchee.container.proxy.JobListenerProxy;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.proxy.RetryProcessListenerProxy;
import org.apache.batchee.container.proxy.RetryReadListenerProxy;
import org.apache.batchee.container.proxy.RetryWriteListenerProxy;
import org.apache.batchee.container.proxy.SkipProcessListenerProxy;
import org.apache.batchee.container.proxy.SkipReadListenerProxy;
import org.apache.batchee.container.proxy.SkipWriteListenerProxy;
import org.apache.batchee.container.proxy.StepListenerProxy;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Listener;
import org.apache.batchee.jaxb.Listeners;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;

public class ListenerFactory {
    private final BatchArtifactFactory factory;
    private final List<ListenerInfo> jobLevelListenerInfo;
    private final Map<String, List<ListenerInfo>> stepLevelListenerInfo = new ConcurrentHashMap<String, List<ListenerInfo>>();

    public ListenerFactory(BatchArtifactFactory factory, JSLJob jobModel, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        this.jobLevelListenerInfo = new ArrayList<ListenerInfo>();
        this.factory = factory;
        Listeners jobLevelListeners = jobModel.getListeners();
        this.jobLevelListenerInfo.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.job.listeners.before", injectionRefs, execution));
        if (jobLevelListeners != null) {
            for (Listener listener : jobLevelListeners.getListenerList()) {
                this.jobLevelListenerInfo.add(ListenerFactory.buildListenerInfo(factory, listener, injectionRefs, execution));
            }
        }
        this.jobLevelListenerInfo.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.job.listeners.after", injectionRefs, execution));
    }

    private static Collection<ListenerInfo> globalListeners(BatchArtifactFactory factory, String key, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        String globalListeners = ServicesManager.value(key, null);
        if (globalListeners != null) {
            String[] refs = globalListeners.split(",");
            ArrayList<ListenerInfo> list = new ArrayList<ListenerInfo>(refs.length);
            for (String ref : refs) {
                Listener listener = new Listener();
                listener.setRef(ref);
                list.add(ListenerFactory.buildListenerInfo(factory, listener, injectionRefs, execution));
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ListenerInfo> getStepListenerInfo(BatchArtifactFactory factory, Step step, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfoList = this.stepLevelListenerInfo.get(step.getId());
        if (stepListenerInfoList == null) {
            ListenerFactory listenerFactory = this;
            synchronized (listenerFactory) {
                stepListenerInfoList = this.stepLevelListenerInfo.get(step.getId());
                if (stepListenerInfoList == null) {
                    stepListenerInfoList = new ArrayList<ListenerInfo>();
                    this.stepLevelListenerInfo.put(step.getId(), stepListenerInfoList);
                    stepListenerInfoList.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.step.listeners.before", injectionRefs, execution));
                    Listeners stepLevelListeners = step.getListeners();
                    if (stepLevelListeners != null) {
                        for (Listener listener : stepLevelListeners.getListenerList()) {
                            stepListenerInfoList.add(ListenerFactory.buildListenerInfo(factory, listener, injectionRefs, execution));
                        }
                    }
                    stepListenerInfoList.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.step.listeners.after", injectionRefs, execution));
                }
            }
        }
        return stepListenerInfoList;
    }

    private static ListenerInfo buildListenerInfo(BatchArtifactFactory factory, Listener listener, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        String id = listener.getRef();
        List<Property> propList = listener.getProperties() == null ? null : listener.getProperties().getPropertyList();
        injectionRefs.setProps(propList);
        Object listenerArtifact = ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        if (listenerArtifact == null) {
            throw new IllegalArgumentException("Load of artifact id: " + id + " returned <null>.");
        }
        return new ListenerInfo(listenerArtifact);
    }

    public List<JobListenerProxy> getJobListeners() {
        ArrayList<JobListenerProxy> retVal = new ArrayList<JobListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isJobListener()) continue;
            retVal.add(new JobListenerProxy((JobListener)li.getArtifact()));
        }
        return retVal;
    }

    public List<ChunkListenerProxy> getChunkListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<ChunkListenerProxy> retVal = new ArrayList<ChunkListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isChunkListener()) continue;
            ChunkListenerProxy proxy = new ChunkListenerProxy((ChunkListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemProcessListenerProxy> getItemProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<ItemProcessListenerProxy> retVal = new ArrayList<ItemProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemProcessListener()) continue;
            ItemProcessListenerProxy proxy = new ItemProcessListenerProxy((ItemProcessListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemReadListenerProxy> getItemReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<ItemReadListenerProxy> retVal = new ArrayList<ItemReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemReadListener()) continue;
            ItemReadListenerProxy proxy = new ItemReadListenerProxy((ItemReadListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemWriteListenerProxy> getItemWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<ItemWriteListenerProxy> retVal = new ArrayList<ItemWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemWriteListener()) continue;
            ItemWriteListenerProxy proxy = new ItemWriteListenerProxy((ItemWriteListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryProcessListenerProxy> getRetryProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<RetryProcessListenerProxy> retVal = new ArrayList<RetryProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryProcessListener()) continue;
            RetryProcessListenerProxy proxy = new RetryProcessListenerProxy((RetryProcessListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryReadListenerProxy> getRetryReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<RetryReadListenerProxy> retVal = new ArrayList<RetryReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryReadListener()) continue;
            RetryReadListenerProxy proxy = new RetryReadListenerProxy((RetryReadListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryWriteListenerProxy> getRetryWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<RetryWriteListenerProxy> retVal = new ArrayList<RetryWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryWriteListener()) continue;
            RetryWriteListenerProxy proxy = new RetryWriteListenerProxy((RetryWriteListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipProcessListenerProxy> getSkipProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<SkipProcessListenerProxy> retVal = new ArrayList<SkipProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipProcessListener()) continue;
            SkipProcessListenerProxy proxy = new SkipProcessListenerProxy((SkipProcessListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipReadListenerProxy> getSkipReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<SkipReadListenerProxy> retVal = new ArrayList<SkipReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipReadListener()) continue;
            SkipReadListenerProxy proxy = new SkipReadListenerProxy((SkipReadListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipWriteListenerProxy> getSkipWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<SkipWriteListenerProxy> retVal = new ArrayList<SkipWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipWriteListener()) continue;
            SkipWriteListenerProxy proxy = new SkipWriteListenerProxy((SkipWriteListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<StepListenerProxy> getStepListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<StepListenerProxy> retVal = new ArrayList<StepListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isStepListener()) continue;
            StepListenerProxy proxy = new StepListenerProxy((StepListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    private static class ListenerInfo {
        private Object listenerArtifact = null;
        private Class listenerArtifactClass = null;

        private ListenerInfo(Object listenerArtifact) {
            this.listenerArtifact = listenerArtifact;
            this.listenerArtifactClass = listenerArtifact.getClass();
        }

        Object getArtifact() {
            return this.listenerArtifact;
        }

        boolean isJobListener() {
            return JobListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isStepListener() {
            return StepListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isChunkListener() {
            return ChunkListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemProcessListener() {
            return ItemProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemReadListener() {
            return ItemReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemWriteListener() {
            return ItemWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryReadListener() {
            return RetryReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryWriteListener() {
            return RetryWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryProcessListener() {
            return RetryProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipProcessListener() {
            return SkipProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipReadListener() {
            return SkipReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipWriteListener() {
            return SkipWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }
    }
}

