/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import javax.batch.api.chunk.CheckpointAlgorithm;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.CheckpointType;
import org.apache.batchee.container.proxy.ItemReaderProxy;
import org.apache.batchee.container.proxy.ItemWriterProxy;
import org.apache.batchee.spi.PersistenceManagerService;

public class CheckpointManager {
    private final PersistenceManagerService persistenceManagerService;
    private final ItemReaderProxy readerProxy;
    private final ItemWriterProxy writerProxy;
    private final CheckpointAlgorithm checkpointAlgorithm;
    private final String stepId;
    private final long jobInstanceID;

    public CheckpointManager(ItemReaderProxy reader, ItemWriterProxy writer, CheckpointAlgorithm chkptAlg, long jobInstanceID, String stepId, PersistenceManagerService persistenceManagerService) {
        this.readerProxy = reader;
        this.writerProxy = writer;
        this.checkpointAlgorithm = chkptAlg;
        this.stepId = stepId;
        this.jobInstanceID = jobInstanceID;
        this.persistenceManagerService = persistenceManagerService;
    }

    public boolean applyCheckPointPolicy() {
        try {
            return this.checkpointAlgorithm.isReadyToCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", e);
        }
    }

    public void checkpoint() {
        ByteArrayOutputStream readerChkptBA = new ByteArrayOutputStream();
        ByteArrayOutputStream writerChkptBA = new ByteArrayOutputStream();
        try {
            ObjectOutputStream readerOOS = new ObjectOutputStream(readerChkptBA);
            readerOOS.writeObject(this.readerProxy.checkpointInfo());
            readerOOS.close();
            CheckpointData readerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, CheckpointType.READER);
            readerChkptData.setRestartToken(readerChkptBA.toByteArray());
            CheckpointDataKey readerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, CheckpointType.READER);
            this.persistenceManagerService.setCheckpointData(readerChkptDK, readerChkptData);
            ObjectOutputStream writerOOS = new ObjectOutputStream(writerChkptBA);
            writerOOS.writeObject(this.writerProxy.checkpointInfo());
            writerOOS.close();
            CheckpointData writerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, CheckpointType.WRITER);
            writerChkptData.setRestartToken(writerChkptBA.toByteArray());
            CheckpointDataKey writerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, CheckpointType.WRITER);
            this.persistenceManagerService.setCheckpointData(writerChkptDK, writerChkptData);
        }
        catch (Exception ex) {
            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.stepId + "]", ex);
        }
    }

    public int checkpointTimeout() {
        try {
            return this.checkpointAlgorithm.checkpointTimeout();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm checkpointTimeout() failed", e);
        }
    }
}

