/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.batchlet;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.SingleThreadedStepController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.BatchletProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.Batchlet;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;

public class BatchletStepController
extends SingleThreadedStepController {
    private final BatchArtifactFactory factory;
    private BatchletProxy batchletProxy;

    public BatchletStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue, ServicesManager manager) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue, manager);
        this.factory = manager.service(BatchArtifactFactory.class);
    }

    private void invokeBatchlet(Batchlet batchlet) throws BatchContainerServiceException {
        String batchletId = batchlet.getRef();
        List<Property> propList = batchlet.getProperties() == null ? null : batchlet.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        this.batchletProxy = ProxyFactory.createBatchletProxy(this.factory, batchletId, injectionRef, this.stepContext, this.jobExecutionImpl);
        if (!this.wasStopIssued()) {
            String processRetVal = this.batchletProxy.process();
            this.stepContext.setBatchletProcessRetVal(processRetVal);
        }
    }

    protected synchronized boolean wasStopIssued() {
        if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            this.stepContext.setBatchStatus(BatchStatus.STOPPING);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        try {
            this.invokeBatchlet(this.step.getBatchlet());
        }
        finally {
            this.invokeCollectorIfPresent();
        }
    }

    @Override
    public synchronized void stop() {
        if (BatchStatus.STARTING.equals((Object)this.stepContext.getBatchStatus()) || BatchStatus.STARTED.equals((Object)this.stepContext.getBatchStatus())) {
            this.stepContext.setBatchStatus(BatchStatus.STOPPING);
            if (this.batchletProxy != null) {
                this.batchletProxy.stop();
            }
        }
    }
}

