/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.jaxrs.common.RestMetric;

public class RestStepExecution {
    private long id;
    private String name;
    private BatchStatus batchStatus;
    private Date startTime;
    private Date endTime;
    private String exitStatus;
    private List<RestMetric> metrics = new LinkedList<RestMetric>();

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public void setMetrics(List<RestMetric> metrics) {
        this.metrics = metrics;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public List<RestMetric> getMetrics() {
        return this.metrics;
    }

    public static List<RestStepExecution> wrap(List<StepExecution> stepExecutions) {
        ArrayList<RestStepExecution> executions = new ArrayList<RestStepExecution>(stepExecutions.size());
        for (StepExecution exec : stepExecutions) {
            executions.add(RestStepExecution.wrap(exec));
        }
        return executions;
    }

    private static RestStepExecution wrap(StepExecution exec) {
        RestStepExecution execution = new RestStepExecution();
        execution.setId(exec.getStepExecutionId());
        execution.setName(exec.getStepName());
        execution.setBatchStatus(exec.getBatchStatus());
        execution.setExitStatus(exec.getExitStatus());
        execution.setStartTime(exec.getStartTime());
        execution.setEndTime(exec.getEndTime());
        if (exec.getMetrics() != null) {
            for (Metric m : exec.getMetrics()) {
                execution.getMetrics().add(RestMetric.wrap(m));
            }
        }
        return execution;
    }
}

