/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;
import javax.batch.runtime.JobInstance;
import javax.net.ssl.KeyManagerFactory;
import org.apache.batchee.jaxrs.client.BatchEEJAXRSClientBase;
import org.apache.batchee.jaxrs.client.ClientConfiguration;
import org.apache.batchee.jaxrs.client.ClientSecurity;
import org.apache.batchee.jaxrs.client.ClientSslConfiguration;
import org.apache.batchee.jaxrs.client.http.Base64s;
import org.apache.batchee.jaxrs.common.JBatchResource;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;

class BatchEEJAXRS1CxfClient
extends BatchEEJAXRSClientBase<Object>
implements Base64s {
    private final JBatchResource client;

    public BatchEEJAXRS1CxfClient(ClientConfiguration configuration) {
        try {
            ClientSecurity security;
            LinkedList providers = new LinkedList();
            if (configuration.getJsonProvider() != null) {
                providers.add(configuration.getJsonProvider().newInstance());
            }
            this.client = (JBatchResource)JAXRSClientFactory.create((String)configuration.getBaseUrl(), JBatchResource.class, providers);
            HTTPConduit conduit = WebClient.getConfig((Object)this.client).getHttpConduit();
            ClientSslConfiguration ssl = configuration.getSsl();
            if (ssl != null) {
                TLSClientParameters params;
                if (conduit.getTlsClientParameters() == null) {
                    params = new TLSClientParameters();
                    conduit.setTlsClientParameters(params);
                } else {
                    params = conduit.getTlsClientParameters();
                }
                if (ssl.getHostnameVerifier() != null) {
                    params.setUseHttpsURLConnectionDefaultHostnameVerifier(false);
                }
                if (ssl.getSslContext() != null) {
                    params.setSSLSocketFactory(ssl.getSslContext().getSocketFactory());
                }
                if (ssl.getKeystore() != null) {
                    try {
                        KeyManagerFactory tmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        tmf.init(ssl.getKeystore(), ssl.getKeystorePassword().toCharArray());
                        params.setKeyManagers(tmf.getKeyManagers());
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
            if ((security = configuration.getSecurity()) != null) {
                AuthorizationPolicy authorization = new AuthorizationPolicy();
                authorization.setUserName(security.getUsername());
                authorization.setPassword(security.getPassword());
                authorization.setAuthorizationType(security.getType());
                conduit.setAuthorization(authorization);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected Object extractEntity(Object o, Type genericReturnType) {
        return o;
    }

    @Override
    protected Object doInvoke(Method jaxrsMethod, Method method, Object[] args) throws Throwable {
        Object[] usedArgs = args;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1 && JobInstance.class.equals(parameterTypes[0])) {
            if (args[0] == null) {
                usedArgs = new Object[2];
            } else {
                JobInstance ji = (JobInstance)JobInstance.class.cast(args[0]);
                usedArgs = new Object[]{ji.getInstanceId(), ji.getJobName()};
            }
        }
        try {
            return jaxrsMethod.invoke((Object)this.client, usedArgs);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void close() {
        try {
            Client.class.getDeclaredMethod("close", new Class[0]).invoke((Object)this.client, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

