/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.io.IOException;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.apache.batchee.hazelcast.HazelcastClientFactory;
import org.apache.batchee.hazelcast.HazelcastMemberFactory;

public class HazelcastSynchroInstanceAware {
    @Inject
    @BatchProperty
    protected String instanceName;
    @Inject
    @BatchProperty
    protected String xmlConfiguration;
    @Inject
    @BatchProperty
    protected String local;
    @Inject
    @BatchProperty
    protected String lockName;

    protected HazelcastInstance instance() throws IOException {
        if (this.local == null || "true".equalsIgnoreCase(this.local)) {
            return HazelcastMemberFactory.findOrCreateMember(this.xmlConfiguration, this.instanceName());
        }
        return HazelcastClientFactory.newClient(this.xmlConfiguration);
    }

    protected String instanceName() {
        if (this.instanceName == null) {
            this.instanceName = "hazelcast";
        }
        return this.instanceName;
    }

    protected String lockName() {
        if (this.lockName == null) {
            this.lockName = this.getClass().getSimpleName();
        }
        return this.lockName;
    }

    protected ILock findLock() throws IOException {
        return this.instance().getLock(this.lockName());
    }
}

