/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.locator;

import java.io.Closeable;
import java.io.IOException;
import org.apache.batchee.extras.locator.BatcheeLocator;

public interface BeanLocator {
    public <T> LocatorInstance<T> newInstance(Class<T> var1, String var2);

    public static class Finder {
        public static BeanLocator get(String name) {
            if (name == null) {
                return BatcheeLocator.INSTANCE;
            }
            try {
                return (BeanLocator)BeanLocator.class.cast(Thread.currentThread().getContextClassLoader().loadClass(name).newInstance());
            }
            catch (Throwable e) {
                return BatcheeLocator.INSTANCE;
            }
        }
    }

    public static class LocatorInstance<T> {
        private final T value;
        private final Closeable releasable;

        public LocatorInstance(T value, Closeable releasable) {
            this.value = value;
            this.releasable = releasable;
        }

        public T getValue() {
            return this.value;
        }

        public void release() {
            if (this.releasable != null) {
                try {
                    this.releasable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

