/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.transaction;

import java.io.Serializable;
import javax.batch.api.chunk.ItemReader;

public abstract class CountedReader
implements ItemReader {
    protected long items = 0L;

    protected void incrementReaderCount() {
        this.incrementCount(1);
    }

    protected void incrementCount(int number) {
        this.items += (long)number;
    }

    public void open(Serializable checkpoint) throws Exception {
        if (checkpoint != null && Number.class.isInstance(checkpoint)) {
            this.items = ((Number)Number.class.cast(checkpoint)).longValue();
            if (this.items > 0L) {
                Object l;
                int i = 0;
                while ((l = this.doRead()) != null && (long)(++i) < this.items) {
                }
            }
        }
    }

    protected abstract Object doRead() throws Exception;

    public Object readItem() throws Exception {
        Object s = this.doRead();
        if (s != null) {
            this.incrementReaderCount();
        }
        return s;
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.items);
    }
}

