/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.stax.util;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXStAXHandler
extends DefaultHandler {
    private final XMLEventWriter writer;
    private final XMLEventFactory factory;

    public SAXStAXHandler(XMLEventWriter writer, XMLEventFactory eventFactory) {
        this.writer = writer;
        this.factory = eventFactory;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.writer.add(this.factory.createStartElement(uri, localName, qName));
            for (int i = 0; i < attributes.getLength(); ++i) {
                QName attrName = new QName(attributes.getURI(i), attributes.getQName(i));
                if ("xmlns".equals(attrName.getLocalPart()) || "xmlns".equals(attrName.getPrefix())) continue;
                this.writer.add(this.factory.createAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i)));
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.add(this.factory.createCharacters(String.valueOf(ch, start, length)));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.add(this.factory.createIgnorableSpace(String.valueOf(ch, start, length)));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.writer.add(this.factory.createEndElement(uri, localName, qName));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }
}

