/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import org.apache.batchee.extras.jdbc.JdbcConnectionConfiguration;
import org.apache.batchee.extras.jdbc.RecordMapper;
import org.apache.batchee.extras.locator.BeanLocator;

public class JdbcReader
extends JdbcConnectionConfiguration
implements ItemReader {
    @Inject
    @BatchProperty(name="mapper")
    private String mapperStr;
    @Inject
    @BatchProperty
    private String locator;
    @Inject
    @BatchProperty
    private String query;
    private LinkedList<Object> items;
    private BeanLocator.LocatorInstance<RecordMapper> mapper;

    public void open(Serializable checkpoint) throws Exception {
        this.mapper = BeanLocator.Finder.get(this.locator).newInstance(RecordMapper.class, this.mapperStr);
        this.items = new LinkedList();
    }

    public void close() throws Exception {
        if (this.mapper != null) {
            this.mapper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readItem() throws Exception {
        if (this.items.isEmpty()) {
            Connection conn = this.connection();
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(this.query, 1003, 1008, 1);
                ResultSet resultSet = null;
                try {
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        this.items.add(this.mapper.getValue().map(resultSet));
                    }
                    if (this.items.isEmpty()) {
                        Object var4_4 = null;
                        return var4_4;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    preparedStatement.close();
                }
            }
            finally {
                conn.close();
            }
        }
        return this.items.pop();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

