/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Inject;
import org.apache.batchee.extras.locator.BeanLocator;

public class AsynchronousItemProcessor<T>
implements ItemProcessor {
    protected ExecutorService es = null;
    protected ItemProcessor delegate = null;
    @Inject
    @BatchProperty
    private String poolSize;
    @Inject
    @BatchProperty
    private String locator;
    @Inject
    @BatchProperty
    private String delegateRef;

    protected ExecutorService getExecutor() {
        if (this.es == null) {
            if (this.poolSize == null || this.poolSize.trim().isEmpty()) {
                this.poolSize = "0";
            }
            int size = Integer.parseInt(this.poolSize);
            DaemonThreadFactory threadFactory = new DaemonThreadFactory();
            this.es = size <= 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(size, threadFactory);
        }
        return this.es;
    }

    protected ItemProcessor getDelegate() {
        if (this.delegate == null) {
            this.delegate = BeanLocator.Finder.get(this.locator).newInstance(ItemProcessor.class, this.delegateRef).getValue();
        }
        return this.delegate;
    }

    public Object processItem(final Object o) throws Exception {
        return this.getExecutor().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AsynchronousItemProcessor.this.getDelegate().processItem(o);
            }
        });
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        private static AtomicInteger ids = new AtomicInteger(0);
        private final ThreadGroup group;

        public DaemonThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.getClass().getSimpleName() + " - " + ids.incrementAndGet());
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

