/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.commons.io.IOUtils;

public class Zips {
    private static final int FILE_BUFFER_SIZE = 32768;
    private static final int COPY_BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destination) throws IOException {
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            Zips.mkdir(destination);
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile), 32768));
            while ((entry = in.getNextEntry()) != null) {
                String path = entry.getName();
                File file = new File(destination, path);
                if (!file.toPath().normalize().startsWith(destination.toPath().normalize())) {
                    throw new IOException("Bad zip entry");
                }
                if (entry.isDirectory()) continue;
                Zips.mkdir(file.getParentFile());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 32768);
                try {
                    Zips.copy(in, out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
        }
        catch (IOException e) {
            try {
                throw new IOException("Unable to unzip " + zipFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private static void copy(ZipInputStream from, OutputStream to) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    private static void mkdir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new BatchContainerRuntimeException("Can't create " + file.getPath());
        }
    }

    private Zips() {
    }
}

