/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.lifecycle.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.batchee.cli.lifecycle.impl.LifecycleBase;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.ServicesManagerLocator;
import org.apache.batchee.container.services.factory.DefaultBatchArtifactFactory;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringLifecycle
extends LifecycleBase<AbstractApplicationContext> {
    @Override
    public AbstractApplicationContext start() {
        ClassPathXmlApplicationContext ctx;
        Map<String, Object> config = this.configuration("spring");
        if (config.containsKey("locations")) {
            LinkedList<String> locations = new LinkedList<String>();
            locations.addAll(Arrays.asList(config.get("locations").toString().split(",")));
            ctx = new ClassPathXmlApplicationContext(locations.toArray(new String[locations.size()]));
        } else if (config.containsKey("classes")) {
            LinkedList classes = new LinkedList();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String clazz : config.get("classes").toString().split(",")) {
                try {
                    classes.add(loader.loadClass(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new BatchContainerRuntimeException((Throwable)e);
                }
            }
            ctx = new AnnotationConfigApplicationContext(classes.toArray(new Class[classes.size()]));
        } else {
            throw new IllegalArgumentException("batchee-lifecycle.properties should contain 'classes' or 'locations' key");
        }
        Properties p = new Properties();
        p.put(BatchArtifactFactory.class.getName(), (Object)new SpringArtifactFactory((ApplicationContext)ctx));
        final ServicesManager mgr = new ServicesManager();
        mgr.init(p);
        ServicesManager.setServicesManagerLocator((ServicesManagerLocator)new ServicesManagerLocator(){

            public ServicesManager find() {
                return mgr;
            }
        });
        return ctx;
    }

    @Override
    public void stop(AbstractApplicationContext state) {
        state.close();
    }

    public static class SpringArtifactFactory
    extends DefaultBatchArtifactFactory {
        private final ApplicationContext context;

        public SpringArtifactFactory(ApplicationContext ctx) {
            this.context = ctx;
        }

        protected DefaultBatchArtifactFactory.ArtifactLocator createArtifactsLocator(ClassLoader tccl) {
            return new SpringArtifactLocator(super.createArtifactsLocator(tccl), this.context);
        }

        private static class SpringArtifactLocator
        implements DefaultBatchArtifactFactory.ArtifactLocator {
            private final DefaultBatchArtifactFactory.ArtifactLocator parent;
            private final ApplicationContext context;

            public SpringArtifactLocator(DefaultBatchArtifactFactory.ArtifactLocator parent, ApplicationContext context) {
                this.parent = parent;
                this.context = context;
            }

            public Object getArtifactById(String id) {
                Object bean = this.context.getBean(id);
                if (bean != null) {
                    return bean;
                }
                return this.parent.getArtifactById(id);
            }
        }
    }
}

