/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.batchee.cli.command.Abandon;
import org.apache.batchee.cli.command.Eviction;
import org.apache.batchee.cli.command.Executions;
import org.apache.batchee.cli.command.Instances;
import org.apache.batchee.cli.command.Names;
import org.apache.batchee.cli.command.Restart;
import org.apache.batchee.cli.command.Running;
import org.apache.batchee.cli.command.Start;
import org.apache.batchee.cli.command.Status;
import org.apache.batchee.cli.command.StepExecutions;
import org.apache.batchee.cli.command.Stop;
import org.apache.batchee.cli.command.api.Arguments;
import org.apache.batchee.cli.command.api.CliConfiguration;
import org.apache.batchee.cli.command.api.Command;
import org.apache.batchee.cli.command.api.Exit;
import org.apache.batchee.cli.command.api.Option;
import org.apache.batchee.cli.command.api.UserCommand;
import org.apache.batchee.cli.command.internal.DefaultCliConfiguration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class BatchEECLI {
    public static void main(String[] args) {
        String conf;
        Iterator<Class<? extends UserCommand>> userCommands;
        Iterator<CliConfiguration> configuration = ServiceLoader.load(CliConfiguration.class).iterator();
        CliConfiguration cliConfiguration = configuration.hasNext() ? configuration.next() : new DefaultCliConfiguration();
        TreeMap<String, Class<? extends Runnable>> commands = new TreeMap<String, Class<? extends Runnable>>();
        if (cliConfiguration.addDefaultCommands()) {
            for (Class type : Arrays.asList(Names.class, Start.class, Restart.class, Status.class, Running.class, Stop.class, Abandon.class, Instances.class, Executions.class, StepExecutions.class, Eviction.class)) {
                BatchEECLI.addCommand(commands, type);
            }
        }
        if ((userCommands = cliConfiguration.userCommands()) != null) {
            while (userCommands.hasNext()) {
                BatchEECLI.addCommand(commands, userCommands.next());
            }
        }
        if (args == null || args.length == 0) {
            System.err.print(BatchEECLI.help(commands));
            return;
        }
        Class cmd = (Class)commands.get(args[0]);
        if (cmd == null) {
            Class helpCmd;
            if (args[0].equals("help") && args.length > 1 && (helpCmd = (Class)commands.get(args[1])) != null) {
                BatchEECLI.printHelp(helpCmd.getAnnotation(Command.class), BatchEECLI.buildOptions(helpCmd, new HashMap<String, Field>()));
                return;
            }
            System.err.print(BatchEECLI.help(commands));
            return;
        }
        Command command = cmd.getAnnotation(Command.class);
        if (command == null) {
            System.err.print(BatchEECLI.help(commands));
            return;
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Options options = BatchEECLI.buildOptions(cmd, fields);
        ArrayList<String> newArgs = new ArrayList<String>(Arrays.asList(args));
        newArgs.remove(newArgs.iterator().next());
        String home = System.getProperty("batchee.home");
        Object cliConf = home == null ? ((conf = System.getProperty("batchee.cli.configuration")) == null ? null : new File(conf)) : new File(home, "conf/batchee-cli.properties");
        if (cliConf != null && ((File)cliConf).exists()) {
            Properties properties = new Properties((File)cliConf){
                final /* synthetic */ File val$cliConf;
                {
                    this.val$cliConf = file;
                    FileReader reader = null;
                    try {
                        reader = new FileReader(this.val$cliConf);
                        this.load(reader);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            for (String key : properties.stringPropertyNames()) {
                if (key.startsWith("_arguments.")) {
                    newArgs.add(properties.getProperty(key));
                    continue;
                }
                String opt = "-" + key;
                if (newArgs.contains(opt)) continue;
                newArgs.add(opt);
                newArgs.add(properties.getProperty(key));
            }
        }
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, newArgs.toArray(new String[newArgs.size()]));
            cliConfiguration.decorate(BatchEECLI.instantiate(cmd, cliConfiguration, fields, !newArgs.isEmpty(), line)).run();
        }
        catch (ParseException e) {
            BatchEECLI.printHelp(command, options);
        }
        catch (RuntimeException e) {
            for (Class<?> current = e.getClass(); current != null; current = current.getSuperclass()) {
                Exit annotation = current.getAnnotation(Exit.class);
                if (annotation == null) continue;
                System.exit(annotation.value());
            }
            throw e;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Runnable instantiate(Class<? extends Runnable> cmd, CliConfiguration configuration, Map<String, Field> fields, boolean hasArgs, CommandLine line) throws InstantiationException, IllegalAccessException {
        Runnable commandInstance = cmd.newInstance();
        if (hasArgs) {
            for (Map.Entry<String, Field> option : fields.entrySet()) {
                Field field;
                String key = option.getKey();
                if (key.isEmpty()) {
                    List list = line.getArgList();
                    if (list == null) continue;
                    field = option.getValue();
                    Type expectedType = field.getGenericType();
                    if (ParameterizedType.class.isInstance(expectedType)) {
                        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(expectedType);
                        if ((pt.getRawType() == List.class || pt.getRawType() == Collection.class) && pt.getActualTypeArguments().length == 1 && pt.getActualTypeArguments()[0] == String.class) {
                            field.set(commandInstance, list);
                            continue;
                        }
                        throw new IllegalArgumentException("@Arguments only supports List<String>");
                    }
                    throw new IllegalArgumentException("@Arguments only supports List<String>");
                }
                String value = line.getOptionValue(key);
                if (value == null) continue;
                field = option.getValue();
                field.set(commandInstance, configuration.coerce(value, field.getGenericType()));
            }
        }
        return commandInstance;
    }

    private static void printHelp(Command command, Options options) {
        new HelpFormatter().printHelp(command.name(), '\n' + command.description() + "\n\n", options, null, true);
    }

    private static Options buildOptions(Class<? extends Runnable> cmd, Map<String, Field> fields) {
        Options options = new Options();
        for (Class<? extends Runnable> it = cmd; it != null; it = it.getSuperclass()) {
            for (Field f : it.getDeclaredFields()) {
                Option option = f.getAnnotation(Option.class);
                Arguments arguments = f.getAnnotation(Arguments.class);
                if (option != null && arguments != null) {
                    throw new IllegalArgumentException("An @Option can't get @Arguments: " + f);
                }
                if (option != null) {
                    String name = option.name();
                    Option.Builder builder = org.apache.commons.cli.Option.builder((String)name).desc(option.description()).hasArg();
                    if (option.required()) {
                        builder.required();
                    }
                    options.addOption(builder.build());
                    fields.put(name, f);
                    f.setAccessible(true);
                    continue;
                }
                if (arguments == null) continue;
                if (fields.put("", f) != null) {
                    throw new IllegalArgumentException("A command can only have a single @Arguments");
                }
                f.setAccessible(true);
            }
        }
        return options;
    }

    private static String help(Map<String, Class<? extends Runnable>> commands) {
        String ln = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder("Available commands:").append(ln).append(ln);
        for (Map.Entry<String, Class<? extends Runnable>> cmd : commands.entrySet()) {
            Command c = cmd.getValue().getAnnotation(Command.class);
            if (c == null) {
                throw new IllegalArgumentException("Missing @Command on " + cmd.getValue());
            }
            builder.append(c.name());
            if (!c.description().isEmpty()) {
                builder.append(": ").append(c.description());
            }
            builder.append(ln);
        }
        return builder.toString();
    }

    private static void addCommand(Map<String, Class<? extends Runnable>> commands, Class<? extends Runnable> type) {
        Command command = type.getAnnotation(Command.class);
        if (command == null) {
            throw new IllegalArgumentException(type + " is not a command, missing @Command");
        }
        String name = command.name();
        commands.put(name, type);
    }

    private BatchEECLI() {
    }
}

