/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.commons.lang3.StringUtils;

@Command(name="executions", description="list executions")
public class Executions
extends JobOperatorCommand {
    @Option(name={"-id"}, description="instance id", required=true)
    private long id;

    @Override
    public void doRun() {
        List executions = this.operator().getJobExecutions((JobInstance)new JobInstanceImpl(this.id));
        if (!executions.isEmpty()) {
            this.info("Executions of " + ((JobExecution)executions.iterator().next()).getJobName() + " for instance " + this.id);
        }
        this.info("execution id\t|\tbatch status\t|\texit status\t|\tstart time\t|\tend time");
        for (JobExecution exec : executions) {
            this.info(String.format("%12d\t|\t%s\t|\t%s\t|\t%tc\t|\t%tc", exec.getExecutionId(), StringUtils.leftPad((String)(exec.getBatchStatus() != null ? exec.getBatchStatus().toString() : "null"), (int)12), StringUtils.leftPad((String)exec.getExitStatus(), (int)11), exec.getStartTime(), exec.getEndTime()));
        }
    }
}

