/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import java.util.LinkedList;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import org.apache.batchee.cdi.impl.BaseContext;

public abstract class LocationHolder {
    private static final StashThreadLocal<JobContext> JOB = new StashThreadLocal();
    private static final StashThreadLocal<StepContext> STEP = new StashThreadLocal();

    protected static void enterJob(JobContext jc) {
        ((LinkedList)JOB.get()).add(jc);
    }

    protected static void enterStep(StepContext sc) {
        ((LinkedList)STEP.get()).add(sc);
    }

    protected static void exitStep(BaseContext<?> context) {
        LocationHolder.cleanUp(context, STEP);
    }

    protected static void exitJob(BaseContext<?> context) {
        LocationHolder.cleanUp(context, JOB);
    }

    public static JobContext currentJob() {
        LinkedList jobContexts = (LinkedList)JOB.get();
        if (jobContexts.isEmpty()) {
            throw new IllegalStateException("No job registered, did you set the job listener?");
        }
        return (JobContext)jobContexts.getLast();
    }

    public static LinkedList<StepContext> currentSteps() {
        return (LinkedList)STEP.get();
    }

    private static <T, K> void cleanUp(BaseContext<K> context, StashThreadLocal<T> stash) {
        context.endContext();
        LinkedList stepContexts = (LinkedList)stash.get();
        stepContexts.removeLast();
        if (stepContexts.isEmpty()) {
            stash.remove();
        }
    }

    private static class StashThreadLocal<T>
    extends ThreadLocal<LinkedList<T>> {
        private StashThreadLocal() {
        }

        @Override
        public LinkedList<T> initialValue() {
            return new LinkedList();
        }
    }
}

