/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.camel;

import org.apache.batchee.camel.CamelTemplateLocator;
import org.apache.batchee.extras.locator.BeanLocator;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;

public class CamelBridge {
    static final DefaultCamelContext CONTEXT = new DefaultCamelContext();
    static final ProducerTemplate PRODUCER_TEMPLATE = CONTEXT.createProducerTemplate();
    static final ConsumerTemplate CONSUMER_TEMPLATE = CONTEXT.createConsumerTemplate();

    private CamelBridge() {
    }

    public static void start() {
        if (!CONTEXT.isStarted()) {
            CONTEXT.start();
        }
    }

    public static void stop() {
        if (CONTEXT.isStarted()) {
            CONTEXT.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object process(String locator, String endpoint, Object body) throws Exception {
        BeanLocator.LocatorInstance<CamelTemplateLocator> locatorInstance = CamelBridge.locator(locator);
        try {
            Object object = ((CamelTemplateLocator)locatorInstance.getValue()).findProducerTemplate().requestBody(endpoint, body);
            return object;
        }
        finally {
            locatorInstance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object receive(String locator, String endpoint, long timeout, Class<?> expected) {
        BeanLocator.LocatorInstance<CamelTemplateLocator> locatorInstance = CamelBridge.locator(locator);
        try {
            ConsumerTemplate consumerTemplate = ((CamelTemplateLocator)locatorInstance.getValue()).findConsumerTemplate();
            if (timeout > 0L) {
                if (expected != null) {
                    Object object = consumerTemplate.receiveBody(endpoint, expected);
                    return object;
                }
                Object object = consumerTemplate.receiveBody(endpoint);
                return object;
            }
            if (expected != null) {
                Object object = consumerTemplate.receiveBody(endpoint, timeout, expected);
                return object;
            }
            Object object = consumerTemplate.receiveBody(endpoint, timeout);
            return object;
        }
        finally {
            locatorInstance.release();
        }
    }

    private static BeanLocator.LocatorInstance<CamelTemplateLocator> locator(String locator) {
        if (locator == null) {
            return new BeanLocator.LocatorInstance((Object)DefaultCamelTemplateLocator.INSTANCE, null);
        }
        return BeanLocator.Finder.get((String)locator).newInstance(CamelTemplateLocator.class, locator);
    }

    public static class DefaultCamelTemplateLocator
    implements CamelTemplateLocator {
        public static final CamelTemplateLocator INSTANCE = new DefaultCamelTemplateLocator();

        @Override
        public ProducerTemplate findProducerTemplate() {
            return PRODUCER_TEMPLATE;
        }

        @Override
        public ConsumerTemplate findConsumerTemplate() {
            return CONSUMER_TEMPLATE;
        }
    }
}

