/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessageRemovedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.UIDFolder;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.kernel.TransportUtils;
import org.apache.axis2.transport.base.AbstractPollingTransportListener;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.event.TransportErrorListener;
import org.apache.axis2.transport.base.event.TransportErrorSource;
import org.apache.axis2.transport.base.event.TransportErrorSourceSupport;
import org.apache.axis2.transport.mail.MailConstants;
import org.apache.axis2.transport.mail.MailOutTransportInfo;
import org.apache.axis2.transport.mail.MailRequestResponseTransport;
import org.apache.axis2.transport.mail.PollTableEntry;

public class MailTransportListener
extends AbstractPollingTransportListener<PollTableEntry>
implements ManagementSupport,
TransportErrorSource {
    public static final String DELETE = "DELETE";
    public static final String MOVE = "MOVE";
    private final TransportErrorSourceSupport tess = new TransportErrorSourceSupport((Object)this);

    protected void doInit() throws AxisFault {
        super.doInit();
        if (this.cfgCtx.getProperty("callbackTable") == null) {
            this.cfgCtx.setProperty("callbackTable", new ConcurrentHashMap());
        }
    }

    protected void poll(PollTableEntry entry) {
        this.checkMail(entry, entry.getEmailAddress());
    }

    private void checkMail(PollTableEntry entry, InternetAddress emailAddress) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking mail for account : " + emailAddress));
        }
        boolean connected = false;
        int retryCount = 0;
        int maxRetryCount = entry.getMaxRetryCount();
        long reconnectionTimeout = entry.getReconnectTimeout();
        Session session = entry.getSession();
        Store store = null;
        Folder folder = null;
        boolean mailProcessingStarted = false;
        while (!connected) {
            block27: {
                try {
                    ++retryCount;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Attempting to connect to POP3/IMAP server for : " + entry.getEmailAddress() + " using " + session.getProperties()));
                    }
                    store = session.getStore(entry.getProtocol());
                    if (entry.getUserName() != null && entry.getPassword() != null) {
                        store.connect(entry.getUserName(), entry.getPassword());
                    } else {
                        this.handleException("Unable to locate username and password for mail login", null);
                    }
                    connected = store.isConnected();
                    if (connected && (folder = entry.getFolder() != null ? store.getFolder(entry.getFolder()) : store.getFolder(MailConstants.DEFAULT_FOLDER)) == null) {
                        folder = store.getDefaultFolder();
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error connecting to mail server for address : " + emailAddress), (Throwable)e);
                    if (maxRetryCount > retryCount) break block27;
                    this.processFailure("Error connecting to mail server for address : " + emailAddress + " :: " + e.getMessage(), e, entry);
                    return;
                }
            }
            if (connected) continue;
            try {
                this.log.warn((Object)("Connection to mail server for account : " + entry.getEmailAddress() + " failed. Retrying in : " + reconnectionTimeout / 1000L + " seconds"));
                Thread.sleep(reconnectionTimeout);
            }
            catch (InterruptedException e) {}
        }
        if (connected && folder != null) {
            CountDownLatch latch = null;
            MailCheckCompletionTask onCompletion = new MailCheckCompletionTask(folder, store, emailAddress, entry);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connecting to folder : " + folder.getName() + " of email account : " + emailAddress));
                }
                folder.open(2);
                int total = folder.getMessageCount();
                Message[] messages = folder.getMessages();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(messages.length + " messgaes in folder : " + folder));
                }
                latch = new CountDownLatch(total);
                for (int i = 0; i < total; ++i) {
                    try {
                        String[] status = messages[i].getHeader("Status");
                        if (status != null && status.length == 1 && status[0].equals("RO")) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - Status: RO"));
                            }
                            latch.countDown();
                            continue;
                        }
                        if (messages[i].isSet(Flags.Flag.SEEN)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - already marked SEEN"));
                            }
                            latch.countDown();
                            continue;
                        }
                        if (messages[i].isSet(Flags.Flag.DELETED)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - already marked DELETED"));
                            }
                            latch.countDown();
                            continue;
                        }
                        this.processMail(entry, folder, store, messages[i], latch, onCompletion);
                        mailProcessingStarted = true;
                        continue;
                    }
                    catch (MessageRemovedException ignore) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " as it has been DELETED by another thread after processing"));
                        }
                        latch.countDown();
                    }
                }
                if (!mailProcessingStarted) {
                    onCompletion.run();
                }
            }
            catch (MessagingException me) {
                this.processFailure("Error checking mail for account : " + emailAddress + " :: " + me.getMessage(), (Exception)((Object)me), entry);
            }
        } else {
            this.processFailure("Unable to access mail folder", null, entry);
        }
    }

    private void processMail(PollTableEntry entry, Folder folder, Store store, Message message, CountDownLatch latch, Runnable onCompletion) {
        MailProcessor mp = new MailProcessor(entry, message, store, folder, latch, onCompletion);
        if (entry.isConcurrentPollingAllowed()) {
            String uid = this.getMessageUID(folder, message);
            if (uid != null) {
                if (entry.isProcessingUID(uid)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping message # : " + message.getMessageNumber() + " : UIDL " + uid + " - already being processed by another thread"));
                    }
                    latch.countDown();
                } else {
                    entry.processingUID(uid);
                    mp.setUID(uid);
                    if (entry.isProcessingMailInParallel()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Processing message # : " + message.getMessageNumber() + " with UID : " + uid + " with a worker thread"));
                        }
                        this.workerPool.execute((Runnable)mp);
                    } else {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Processing message # : " + message.getMessageNumber() + " with UID : " + uid + " in same thread"));
                        }
                        mp.run();
                    }
                }
            } else {
                this.log.warn((Object)("Cannot process mail in parallel as the folder does not support UIDs. Processing message # : " + message.getMessageNumber() + " in the same thread"));
                entry.setConcurrentPollingAllowed(false);
                mp.run();
            }
        } else if (entry.isProcessingMailInParallel()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing message # : " + message.getMessageNumber() + " with a worker thread"));
            }
            this.workerPool.execute((Runnable)mp);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing message # : " + message.getMessageNumber() + " in same thread"));
            }
            mp.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMail(Message message, PollTableEntry entry) throws MessagingException, IOException {
        String charSetEnc;
        Message messagePart;
        this.updateMetrics(message);
        Map trpHeaders = this.getTransportHeaders(message, entry);
        Object contentType = entry.getContentType();
        if (contentType != null) {
            messagePart = message;
        } else {
            messagePart = this.getMessagePart(message, this.cfgCtx.getAxisConfiguration());
            contentType = messagePart.getContentType();
        }
        int idx = ((String)contentType).indexOf(59);
        contentType = idx == -1 ? ((String)contentType).toLowerCase() : ((String)contentType).substring(0, idx).toLowerCase() + ((String)contentType).substring(idx);
        if (contentType == null) {
            this.processFailure("Unable to determine Content-type for message : " + message.getMessageNumber() + " :: " + message.getSubject(), null, entry);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing message as Content-Type : " + (String)contentType));
        }
        MessageContext msgContext = entry.createMessageContext();
        try {
            charSetEnc = new ContentType((String)contentType).getParameter("charset");
        }
        catch (ParseException ex) {
            charSetEnc = null;
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEnc);
        MailOutTransportInfo outInfo = this.buildOutTransportInfo(message, entry);
        msgContext.setProperty("OutTransportInfo", (Object)outInfo);
        msgContext.setProperty("RequestResponseTransportControl", (Object)new MailRequestResponseTransport());
        if (outInfo.getFromAddress() != null) {
            msgContext.setFrom(new EndpointReference("mailto:" + outInfo.getFromAddress().getAddress()));
        }
        msgContext.setMessageID(outInfo.getRequestMessageID());
        if (message.getSentDate() != null) {
            Calendar sentDate = Calendar.getInstance();
            sentDate.setTime(message.getSentDate());
            msgContext.setProperty("sent-date", (Object)sentDate);
        }
        msgContext.setProperty("received-date", (Object)Calendar.getInstance());
        try (InputStream in = messagePart.getInputStream();){
            try {
                msgContext.setEnvelope(TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)in, (String)contentType));
            }
            catch (XMLStreamException ex) {
                this.handleException("Error parsing message", ex);
            }
            String soapAction = (String)trpHeaders.get("SOAPAction");
            if (soapAction == null && message.getSubject() != null && message.getSubject().startsWith("SOAPAction") && (soapAction = message.getSubject().substring("SOAPAction".length())).startsWith(":")) {
                soapAction = soapAction.substring(1).trim();
            }
            this.handleIncomingMessage(msgContext, trpHeaders, soapAction, (String)contentType);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processed message : " + message.getMessageNumber() + " :: " + message.getSubject()));
        }
    }

    private void updateMetrics(Message message) throws IOException, MessagingException {
        if (message instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)message;
            if (mimeMessage.getContent() instanceof Multipart) {
                Multipart mp = (Multipart)mimeMessage.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    MimeBodyPart mbp = (MimeBodyPart)mp.getBodyPart(i);
                    int size = mbp.getSize();
                    if (size == -1) continue;
                    this.metrics.incrementBytesReceived((long)size);
                }
            } else {
                int size = mimeMessage.getSize();
                if (size != -1) {
                    this.metrics.incrementBytesReceived((long)size);
                }
            }
        }
    }

    private Map getTransportHeaders(Message message, PollTableEntry entry) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String string1 = (String)o1;
                String string2 = (String)o2;
                return string1.compareToIgnoreCase(string2);
            }
        };
        TreeMap<String, String> trpHeaders = new TreeMap<String, String>(comparator);
        try {
            Enumeration e = message.getAllHeaders();
            while (e.hasMoreElements()) {
                Header h = (Header)e.nextElement();
                if (!entry.retainHeader(h.getName())) continue;
                trpHeaders.put(h.getName(), h.getValue());
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return trpHeaders;
    }

    private Part getMessagePart(Message message, AxisConfiguration axisCfg) throws MessagingException, IOException {
        ContentType contentType = new ContentType(message.getContentType());
        if (contentType.getBaseType().equalsIgnoreCase("multipart/mixed")) {
            Multipart multipart = (Multipart)message.getContent();
            MimeBodyPart textMainPart = null;
            for (int i = 0; i < multipart.getCount(); ++i) {
                MimeBodyPart bodyPart = (MimeBodyPart)multipart.getBodyPart(i);
                ContentType partContentType = new ContentType(bodyPart.getContentType());
                if (axisCfg.getMessageBuilder(partContentType.getBaseType()) == null) continue;
                if (partContentType.getBaseType().equalsIgnoreCase("text/plain")) {
                    textMainPart = bodyPart;
                    continue;
                }
                return bodyPart;
            }
            if (textMainPart != null) {
                return textMainPart;
            }
            return message;
        }
        return message;
    }

    private MailOutTransportInfo buildOutTransportInfo(Message message, PollTableEntry entry) throws MessagingException {
        MailOutTransportInfo outInfo = new MailOutTransportInfo(entry.getEmailAddress());
        if (message.getReplyTo() != null) {
            outInfo.setTargetAddresses((InternetAddress[])message.getReplyTo());
        } else if (message.getFrom() != null) {
            outInfo.setTargetAddresses((InternetAddress[])message.getFrom());
        } else {
            InternetAddress replyAddress = entry.getReplyAddress();
            if (replyAddress != null) {
                outInfo.setTargetAddresses(new InternetAddress[]{replyAddress});
            }
        }
        if (message.getRecipients(Message.RecipientType.CC) != null) {
            outInfo.setCcAddresses((InternetAddress[])message.getRecipients(Message.RecipientType.CC));
        }
        if (message.getSubject() != null) {
            outInfo.setSubject("Re: " + message.getSubject());
        }
        if (message.getHeader("X-Message-ID") != null) {
            outInfo.setRequestMessageID(message.getHeader("X-Message-ID")[0]);
        } else if (message instanceof MimeMessage && ((MimeMessage)message).getMessageID() != null) {
            outInfo.setRequestMessageID(((MimeMessage)message).getMessageID());
        }
        return outInfo;
    }

    private void moveOrDeleteAfterProcessing(PollTableEntry entry, Store store, Folder folder, Message message) {
        String moveToFolder = null;
        try {
            switch (entry.getLastPollState()) {
                case 0: {
                    if (entry.getActionAfterProcess() != 1) break;
                    moveToFolder = entry.getMoveAfterProcess();
                    break;
                }
                case 2: {
                    if (entry.getActionAfterFailure() != 1) break;
                    moveToFolder = entry.getMoveAfterFailure();
                    break;
                }
                case 3: {
                    return;
                }
            }
            if (moveToFolder != null) {
                Folder dFolder;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Moving processed email to folder :" + moveToFolder));
                }
                if (!(dFolder = store.getFolder(moveToFolder)).exists()) {
                    dFolder.create(1);
                }
                folder.copyMessages(new Message[]{message}, dFolder);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deleting email :" + message.getMessageNumber()));
            }
            message.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            this.log.error((Object)("Error deleting or resolving folder to move after processing : " + moveToFolder), (Throwable)e);
        }
    }

    protected PollTableEntry createEndpoint() {
        return new PollTableEntry(this.log);
    }

    public void addErrorListener(TransportErrorListener listener) {
        this.tess.addErrorListener(listener);
    }

    public void removeErrorListener(TransportErrorListener listener) {
        this.tess.removeErrorListener(listener);
    }

    private String getMessageUID(Folder folder, Message message) {
        String uid = null;
        if (folder instanceof UIDFolder) {
            try {
                uid = Long.toString(((UIDFolder)folder).getUID(message));
            }
            catch (MessagingException messagingException) {}
        } else {
            try {
                Method m = folder.getClass().getMethod("getUID", Message.class);
                Object o = m.invoke((Object)folder, message);
                if (o != null && o instanceof Long) {
                    uid = Long.toString((Long)o);
                } else if (o != null && o instanceof String) {
                    uid = (String)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uid;
    }

    private class MailCheckCompletionTask
    implements Runnable {
        private final Folder folder;
        private final Store store;
        private final InternetAddress emailAddress;
        private final PollTableEntry entry;
        private boolean taskStarted = false;

        public MailCheckCompletionTask(Folder folder, Store store, InternetAddress emailAddress, PollTableEntry entry) {
            this.folder = folder;
            this.store = store;
            this.emailAddress = emailAddress;
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MailCheckCompletionTask mailCheckCompletionTask = this;
            synchronized (mailCheckCompletionTask) {
                if (this.taskStarted) {
                    return;
                }
                this.taskStarted = true;
            }
            if (MailTransportListener.this.log.isDebugEnabled()) {
                MailTransportListener.this.log.debug((Object)("Executing onCompletion task for the mail download of : " + this.emailAddress));
            }
            if (this.folder != null) {
                try {
                    this.folder.close(true);
                    if (MailTransportListener.this.log.isDebugEnabled()) {
                        MailTransportListener.this.log.debug((Object)"Mail folder closed, and deleted mail expunged");
                    }
                }
                catch (MessagingException e) {
                    MailTransportListener.this.log.warn((Object)("Error closing mail folder : " + this.folder + " for account : " + this.emailAddress + " :: " + e.getMessage()));
                }
            }
            if (this.store != null) {
                try {
                    this.store.close();
                    if (MailTransportListener.this.log.isDebugEnabled()) {
                        MailTransportListener.this.log.debug((Object)("Mail store closed for : " + this.emailAddress));
                    }
                }
                catch (MessagingException e) {
                    MailTransportListener.this.log.warn((Object)("Error closing mail store for account : " + this.emailAddress + " :: " + e.getMessage()), (Throwable)e);
                }
            }
            if (MailTransportListener.this.log.isDebugEnabled()) {
                MailTransportListener.this.log.debug((Object)("Scheduling next poll for : " + this.emailAddress));
            }
            MailTransportListener.this.onPollCompletion(this.entry);
        }
    }

    private class MailProcessor
    implements Runnable {
        private PollTableEntry entry = null;
        private Message message = null;
        private Store store = null;
        private Folder folder = null;
        private String uid = null;
        private CountDownLatch doneSignal = null;
        private Runnable onCompletion = null;

        MailProcessor(PollTableEntry entry, Message message, Store store, Folder folder, CountDownLatch doneSignal, Runnable onCompletion) {
            this.entry = entry;
            this.message = message;
            this.store = store;
            this.folder = folder;
            this.doneSignal = doneSignal;
            this.onCompletion = onCompletion;
        }

        public void setUID(String uid) {
            this.uid = uid;
        }

        @Override
        public void run() {
            this.entry.setLastPollState(3);
            try {
                MailTransportListener.this.processMail(this.message, this.entry);
                this.entry.setLastPollState(0);
                MailTransportListener.this.metrics.incrementMessagesReceived();
            }
            catch (Exception e) {
                MailTransportListener.this.log.error((Object)"Failed to process message", (Throwable)e);
                this.entry.setLastPollState(2);
                MailTransportListener.this.metrics.incrementFaultsReceiving();
                MailTransportListener.this.tess.error(this.entry.getService(), (Throwable)e);
            }
            finally {
                if (this.uid != null) {
                    this.entry.removeUID(this.uid);
                }
            }
            try {
                MailTransportListener.this.moveOrDeleteAfterProcessing(this.entry, this.store, this.folder, this.message);
            }
            catch (Exception e) {
                MailTransportListener.this.log.error((Object)"Failed to move or delete email message", (Throwable)e);
                MailTransportListener.this.tess.error(this.entry.getService(), (Throwable)e);
            }
            this.doneSignal.countDown();
            if (this.doneSignal.getCount() == 0L) {
                this.onCompletion.run();
            }
        }
    }
}

