/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axis2.saaj.util.SAAJDataSource;

public class AttachmentPartImpl
extends AttachmentPart {
    private DataHandler dataHandler;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String attachmentFile;
    private OMText omText;
    private boolean isAttachmentReferenced;

    public boolean matches(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.mimeHeaders.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!hdr.getValue().equalsIgnoreCase(values[j])) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isAttachmentReferenced() {
        return this.isAttachmentReferenced;
    }

    public void setAttachmentReferenced(boolean attachmentReferenced) {
        this.isAttachmentReferenced = attachmentReferenced;
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)bout);
        }
        catch (Exception ex) {
            throw new SOAPException(ex);
        }
        return bout.size();
    }

    public void clearContent() {
        this.dataHandler = null;
        this.omText = null;
    }

    public Object getContent() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No content is present in this AttachmentPart");
        }
        try {
            String contentType = this.dataHandler.getContentType();
            if (contentType.equals("text/plain") || contentType.equals("text/xml") || contentType.equals("text/html")) {
                return this.dataHandler.getContent();
            }
            try {
                return this.dataHandler.getContent();
            }
            catch (UnsupportedDataTypeException e) {
                return this.dataHandler.getDataSource().getInputStream();
            }
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
    }

    public void setContent(Object object, String contentType) {
        this.setMimeHeader("Content-Type", contentType);
        if (object instanceof String) {
            try {
                String s = (String)object;
                ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
                SAAJDataSource source = new SAAJDataSource(bais, 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = object;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else if (object instanceof InputStream) {
            try {
                SAAJDataSource source = new SAAJDataSource((InputStream)object, 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = null;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else if (object instanceof StreamSource) {
            try {
                SAAJDataSource source = new SAAJDataSource(((StreamSource)object).getInputStream(), 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = null;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else {
            throw new IllegalArgumentException("Illegal Argument");
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No Content present in the Attachment part");
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler datahandler) {
        if (datahandler == null) {
            throw new IllegalArgumentException("Cannot set null DataHandler");
        }
        this.dataHandler = datahandler;
        this.setMimeHeader("Content-Type", datahandler.getContentType());
        this.omText = DOOMAbstractFactory.getOMFactory().createOMText((Object)this.dataHandler, true);
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.mimeHeaders.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public OMText getOMText() throws SOAPException {
        if (this.omText == null) {
            throw new SOAPException("OMText set to null");
        }
        return this.omText;
    }

    public TextImpl getText(DocumentImpl doc) {
        return new TextImpl(doc, this.omText.getText(), doc.getOMFactory());
    }

    protected void setAttachmentFile(String path) {
        this.attachmentFile = path;
    }

    public void detachAttachmentFile() {
        this.attachmentFile = null;
    }

    public String getAttachmentFile() {
        return this.attachmentFile;
    }

    private void extractFilename(SAAJDataSource source) {
        if (source.getDiskCacheFile() != null) {
            String path = source.getDiskCacheFile().getAbsolutePath();
            this.setAttachmentFile(path);
        }
    }
}

