/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CodeGenerationUtility {
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private final CodeGenConfiguration codeGenConfig;
    private static HashSet s_primitiveSet = new HashSet();
    private static HashMap s_wrapperMap;
    private static final HashSet s_reservedWords;

    public CodeGenerationUtility(CodeGenConfiguration config) {
        this.codeGenConfig = config;
    }

    public void engage(String path) {
        File file = null;
        if (path != null && !(file = new File(path)).exists()) {
            throw new RuntimeException("jibx binding definition file " + path + " not found");
        }
        try {
            Element detail;
            String classname;
            Iterator<Object> iter;
            boolean unwrap = !this.codeGenConfig.isParametersWrapped();
            BindingElement binding = null;
            if (file == null) {
                if (!unwrap) {
                    throw new RuntimeException("JiBX wrapped support requires a binding definition to be provided using the -Ebindingfile {file-path} parameter");
                }
            } else {
                ValidationContext vctx = BindingElement.newValidationContext();
                binding = BindingElement.readBinding((InputStream)new FileInputStream(file), (String)path, (ValidationContext)vctx);
                binding.setBaseUrl(file.toURL());
                vctx.setBindingRoot(binding);
                IncludePrevalidationVisitor ipv = new IncludePrevalidationVisitor(vctx);
                vctx.tourTree(binding, (ModelVisitor)ipv);
                if (vctx.getErrorCount() != 0 || vctx.getFatalCount() != 0) {
                    throw new RuntimeException("invalid jibx binding definition file " + path);
                }
            }
            HashMap simpleTypeMap = new HashMap();
            CodeGenerationUtility.buildFormat("byte", "byte", "org.jibx.runtime.Utility.serializeByte", "org.jibx.runtime.Utility.parseByte", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("unsignedShort", "char", "org.jibx.runtime.Utility.serializeChar", "org.jibx.runtime.Utility.parseChar", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("double", "double", "org.jibx.runtime.Utility.serializeDouble", "org.jibx.runtime.Utility.parseDouble", "0.0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("float", "float", "org.jibx.runtime.Utility.serializeFloat", "org.jibx.runtime.Utility.parseFloat", "0.0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("int", "int", "org.jibx.runtime.Utility.serializeInt", "org.jibx.runtime.Utility.parseInt", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("long", "long", "org.jibx.runtime.Utility.serializeLong", "org.jibx.runtime.Utility.parseLong", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("short", "short", "org.jibx.runtime.Utility.serializeShort", "org.jibx.runtime.Utility.parseShort", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("boolean", "boolean", "org.jibx.runtime.Utility.serializeBoolean", "org.jibx.runtime.Utility.parseBoolean", "false", simpleTypeMap);
            CodeGenerationUtility.buildFormat("dateTime", "java.util.Date", "org.jibx.runtime.Utility.serializeDateTime", "org.jibx.runtime.Utility.deserializeDateTime", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("date", "java.sql.Date", "org.jibx.runtime.Utility.serializeSqlDate", "org.jibx.runtime.Utility.deserializeSqlDate", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("time", "java.sql.Time", "org.jibx.runtime.Utility.serializeSqlTime", "org.jibx.runtime.Utility.deserializeSqlTime", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("base64Binary", "byte[]", "org.jibx.runtime.Utility.serializeBase64", "org.jibx.runtime.Utility.deserializeBase64", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("string", "java.lang.String", null, null, null, simpleTypeMap);
            HashMap elementMap = new HashMap();
            HashMap complexTypeMap = new HashMap();
            if (binding != null) {
                CodeGenerationUtility.collectTopLevelComponents(binding, null, elementMap, complexTypeMap, simpleTypeMap);
            }
            if (unwrap && complexTypeMap.size() > 0 && !binding.isForceClasses()) {
                throw new RuntimeException("unwrapped binding must use force-classes='true' option in " + path);
            }
            this.codeGenConfig.setPackClasses(false);
            this.codeGenConfig.setTypeMapper((TypeMapper)new NamedParameterTypeMapper());
            Iterator operations = this.codeGenConfig.getAxisService().getOperations();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            int opindex = 0;
            HashMap typeMappedClassMap = new HashMap();
            String mappedclass = null;
            HashSet<String> objins = new HashSet<String>();
            HashSet<String> objouts = new HashSet<String>();
            HashSet<String> objfaults = new HashSet<String>();
            while (operations.hasNext()) {
                AxisOperation op = (AxisOperation)operations.next();
                String mep = op.getMessageExchangePattern();
                AxisMessage inmsg = null;
                AxisMessage outmsg = null;
                if (WSDLUtil.isInputPresentForMEP((String)mep) && (inmsg = op.getMessage("In")) == null) {
                    throw new RuntimeException("Expected input message not found for operation " + op.getName());
                }
                if (WSDLUtil.isOutputPresentForMEP((String)mep) && (outmsg = op.getMessage("Out")) == null) {
                    throw new RuntimeException("Expected output message not found for operation " + op.getName());
                }
                if (unwrap) {
                    String receivername = "jibxReceiver" + opindex++;
                    Element dbmethod = doc.createElement("dbmethod");
                    dbmethod.setAttribute("receiver-name", receivername);
                    dbmethod.setAttribute("method-name", op.getName().getLocalPart());
                    HashSet nameset = new HashSet(s_reservedWords);
                    if (inmsg != null) {
                        dbmethod.appendChild(this.unwrapMessage(inmsg, false, simpleTypeMap, complexTypeMap, typeMappedClassMap, nameset, doc));
                    }
                    if (outmsg != null) {
                        dbmethod.appendChild(this.unwrapMessage(outmsg, true, simpleTypeMap, complexTypeMap, typeMappedClassMap, nameset, doc));
                    }
                    op.addParameter(new Parameter("databinding-generated-receiver", (Object)receivername));
                    op.addParameter(new Parameter("databinding-generated-implementation", (Object)Boolean.TRUE));
                    op.addParameter(new Parameter("databinding-operation-details", (Object)dbmethod));
                } else {
                    if (inmsg != null) {
                        mappedclass = this.mapMessage(inmsg, elementMap);
                        objins.add(mappedclass);
                    }
                    if (outmsg != null) {
                        mappedclass = this.mapMessage(outmsg, elementMap);
                        objouts.add(mappedclass);
                    }
                }
                Iterator iter2 = op.getFaultMessages().iterator();
                while (iter2.hasNext()) {
                    mappedclass = this.mapMessage((AxisMessage)iter2.next(), elementMap);
                    objfaults.add(mappedclass);
                }
            }
            ArrayList<Element> details = new ArrayList<Element>();
            Element bindinit = doc.createElement("initialize-binding");
            if (!typeMappedClassMap.isEmpty()) {
                iter = typeMappedClassMap.keySet().iterator();
                while (iter.hasNext()) {
                    javax.xml.namespace.QName tname = (javax.xml.namespace.QName)iter.next();
                    String clsindex = ((Integer)typeMappedClassMap.get(tname)).toString();
                    Element detail2 = doc.createElement("abstract-type");
                    detail2.setAttribute("ns", tname.getNamespaceURI());
                    detail2.setAttribute("name", tname.getLocalPart());
                    detail2.setAttribute("type-index", clsindex);
                    bindinit.appendChild(detail2);
                    if (mappedclass != null) continue;
                    MappingElement mapping = (MappingElement)complexTypeMap.get(tname);
                    mappedclass = mapping.getClassName();
                }
            }
            if (mappedclass == null) {
                mappedclass = "";
            }
            bindinit.setAttribute("bound-class", mappedclass);
            details.add(bindinit);
            iter = objins.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-input");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            iter = objouts.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-output");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            iter = objfaults.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-fault");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            this.codeGenConfig.getAxisService().addParameter(new Parameter("databinding-service-details", details));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (JiBXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void buildFormat(String stype, String jtype, String sname, String dname, String dflt, Map map) {
        FormatElement format = new FormatElement();
        format.setTypeName(jtype);
        format.setSerializerName(sname);
        format.setDeserializerName(dname);
        format.setDefaultText(dflt);
        map.put(new javax.xml.namespace.QName(SCHEMA_NAMESPACE, stype), format);
    }

    private Element unwrapMessage(AxisMessage msg, boolean isout, Map simpleTypeMap, Map complexTypeMap, Map typeMappedClassMap, Set nameset, Document doc) {
        javax.xml.namespace.QName qname = msg.getElementQName();
        if (qname == null) {
            throw new RuntimeException("No element reference in message " + msg.getName());
        }
        XmlSchemaElement wrapdef = this.codeGenConfig.getAxisService().getSchemaElement(qname);
        if (wrapdef == null) {
            throw new RuntimeException("Cannot unwrap - no definition found for element " + qname);
        }
        XmlSchemaType type = wrapdef.getSchemaType();
        Element wrapdetail = doc.createElement(isout ? "out-wrapper" : "in-wrapper");
        wrapdetail.setAttribute("ns", qname.getNamespaceURI());
        wrapdetail.setAttribute("name", qname.getLocalPart());
        ArrayList<javax.xml.namespace.QName> partNameList = new ArrayList<javax.xml.namespace.QName>();
        String wrappertype = "";
        if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType ctype = (XmlSchemaComplexType)type;
            if (ctype.getAttributes().getCount() != 0) {
                throw new RuntimeException("Cannot unwrap element " + qname + ": attributes not allowed on type to be unwrapped");
            }
            XmlSchemaParticle particle = ctype.getParticle();
            if (!(particle instanceof XmlSchemaSequence)) {
                throw new RuntimeException("Cannot unwrap element " + qname + ": type to be unwrapped must be a sequence");
            }
            if (particle.getMinOccurs() != 1L || particle.getMaxOccurs() != 1L) {
                throw new RuntimeException("Cannot unwrap element " + qname + ": contained sequence must have minOccurs='1' and maxOccurs='1'");
            }
            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
            javax.xml.namespace.QName opName = ((AxisOperation)msg.getParent()).getName();
            XmlSchemaObjectCollection items = sequence.getItems();
            Iterator iter = items.getIterator();
            while (iter.hasNext()) {
                String javatype;
                XmlSchemaParticle item = (XmlSchemaParticle)iter.next();
                if (!(item instanceof XmlSchemaElement)) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": only element items allowed in seqence");
                }
                XmlSchemaElement element = (XmlSchemaElement)item;
                javax.xml.namespace.QName typename = element.getSchemaTypeName();
                if (typename == null) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": all elements in contained sequence must reference a named type");
                }
                Element param = doc.createElement(isout ? "return-element" : "parameter-element");
                javax.xml.namespace.QName itemname = element.getQName();
                param.setAttribute("ns", itemname.getNamespaceURI());
                param.setAttribute("name", itemname.getLocalPart());
                param.setAttribute("java-name", CodeGenerationUtility.toJavaName(itemname.getLocalPart(), nameset));
                param.setAttribute("nillable", Boolean.toString(element.isNillable()));
                param.setAttribute("optional", Boolean.toString(element.getMinOccurs() == 0L));
                boolean isarray = element.getMaxOccurs() > 1L;
                param.setAttribute("array", Boolean.toString(isarray));
                if (element.getSchemaType() instanceof XmlSchemaSimpleType) {
                    FormatElement format = (FormatElement)simpleTypeMap.get(typename);
                    if (format == null) {
                        throw new RuntimeException("Cannot unwrap element " + qname + ": no format definition found for type " + typename + " (used by element " + itemname + ')');
                    }
                    javatype = format.getTypeName();
                    param.setAttribute("form", "simple");
                    param.setAttribute("serializer", format.getSerializerName());
                    param.setAttribute("deserializer", format.getDeserializerName());
                    if (element.isNillable() && s_wrapperMap.containsKey(javatype)) {
                        param.setAttribute("wrapped-primitive", "true");
                        param.setAttribute("value-method", javatype + "Value");
                        javatype = (String)s_wrapperMap.get(javatype);
                    } else {
                        param.setAttribute("wrapped-primitive", "false");
                        String dflt = element.getDefaultValue();
                        if (dflt == null) {
                            dflt = format.getDefaultText();
                        }
                        if (dflt != null) {
                            param.setAttribute("default", dflt);
                        }
                    }
                } else {
                    MappingElement mapping = (MappingElement)complexTypeMap.get(typename);
                    if (mapping == null) {
                        throw new RuntimeException("Cannot unwrap element " + qname + ": no abstract mapping definition found for type " + typename + " (used by element " + itemname + ')');
                    }
                    Integer tindex = (Integer)typeMappedClassMap.get(typename);
                    if (tindex == null) {
                        tindex = new Integer(typeMappedClassMap.size());
                        typeMappedClassMap.put(typename, tindex);
                    }
                    javatype = mapping.getClassName();
                    param.setAttribute("form", "complex");
                    param.setAttribute("type-index", tindex.toString());
                }
                param.setAttribute("java-type", javatype);
                boolean isobj = !s_primitiveSet.contains(javatype);
                String fulltype = javatype;
                if (isarray) {
                    fulltype = fulltype + "[]";
                    isobj = false;
                }
                param.setAttribute("object", Boolean.toString(isobj));
                wrappertype = isout ? fulltype : "java.lang.Object";
                wrapdetail.appendChild(param);
                javax.xml.namespace.QName partqname = WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)"_input", (String)itemname.getLocalPart());
                partNameList.add(partqname);
                this.codeGenConfig.getTypeMapper().addTypeMappingName(partqname, fulltype);
            }
        } else if (type != null) {
            throw new RuntimeException("Cannot unwrap element " + qname + ": not a complexType definition");
        }
        if (wrapdetail.getFirstChild() == null) {
            wrapdetail.setAttribute("empty", "true");
            wrappertype = "";
        } else {
            wrapdetail.setAttribute("empty", "false");
        }
        MessagePartInformationHolder infoHolder = new MessagePartInformationHolder();
        infoHolder.setOperationName(((AxisOperation)msg.getParent()).getName());
        infoHolder.setPartsList(partNameList);
        try {
            msg.addParameter(new Parameter("UnWrapped_details", (Object)infoHolder));
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        try {
            msg.addParameter(new Parameter("UnWrapped", (Object)Boolean.TRUE));
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        this.codeGenConfig.getTypeMapper().addTypeMappingName(qname, wrappertype);
        return wrapdetail;
    }

    private static String toJavaName(String name, Set nameset) {
        StringBuffer buff = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(chr) || i > 0 && Character.isJavaIdentifierPart(chr)) {
                buff.append(chr);
                continue;
            }
            if (chr == ':' || chr == '.') {
                buff.append('$');
                continue;
            }
            buff.append('_');
        }
        int count = 0;
        String jname = buff.toString();
        while (!nameset.add(jname)) {
            jname = buff.toString() + count++;
        }
        return jname;
    }

    private String mapMessage(AxisMessage msg, Map complexTypeMap) {
        javax.xml.namespace.QName qname = msg.getElementQName();
        if (qname == null) {
            throw new RuntimeException("No element reference in message " + msg.getName());
        }
        Object obj = complexTypeMap.get(qname);
        if (obj == null) {
            throw new RuntimeException("No mapping defined for element " + qname);
        }
        MappingElement mapping = (MappingElement)obj;
        String cname = mapping.getClassName();
        this.codeGenConfig.getTypeMapper().addTypeMappingName(qname, cname);
        return cname;
    }

    private static void collectTopLevelComponents(BindingElement binding, String dns, Map elementMap, Map complexTypeMap, Map simpleTypeMap) {
        String defaultns = CodeGenerationUtility.findDefaultNS(binding.topChildIterator(), dns);
        Iterator iter = binding.topChildIterator();
        while (iter.hasNext()) {
            ElementBase child = (ElementBase)iter.next();
            if (child.type() == 8) {
                IncludeElement include = (IncludeElement)child;
                CodeGenerationUtility.collectTopLevelComponents(include.getBinding(), defaultns, elementMap, complexTypeMap, simpleTypeMap);
                continue;
            }
            if (child.type() == 2) {
                FormatElement format = (FormatElement)child;
                CodeGenerationUtility.registerElement(format.getQName(), (ElementBase)format, simpleTypeMap);
                continue;
            }
            if (child.type() != 3) continue;
            MappingElement mapping = (MappingElement)child;
            if (mapping.isAbstract()) {
                CodeGenerationUtility.registerElement(mapping.getTypeQName(), (ElementBase)mapping, complexTypeMap);
                continue;
            }
            String uri = mapping.getUri();
            if (uri == null) {
                uri = CodeGenerationUtility.findDefaultNS(mapping.topChildIterator(), defaultns);
            }
            elementMap.put(new javax.xml.namespace.QName(uri, mapping.getName()), mapping);
        }
    }

    private static void registerElement(QName qname, ElementBase element, Map map) {
        if (qname != null) {
            map.put(new javax.xml.namespace.QName(qname.getUri(), qname.getName()), element);
        }
    }

    private static String findDefaultNS(Iterator iter, String dns) {
        ElementBase child;
        while (iter.hasNext() && (child = (ElementBase)iter.next()).type() == 4) {
            NamespaceElement namespace = (NamespaceElement)child;
            String defaultName = namespace.getDefaultName();
            if (!"elements".equals(defaultName) && !"all".equals(defaultName)) continue;
            return namespace.getUri();
        }
        return dns;
    }

    static {
        s_primitiveSet.add("boolean");
        s_primitiveSet.add("byte");
        s_primitiveSet.add("char");
        s_primitiveSet.add("double");
        s_primitiveSet.add("float");
        s_primitiveSet.add("int");
        s_primitiveSet.add("long");
        s_primitiveSet.add("short");
        s_primitiveSet.add("void");
        s_wrapperMap = new HashMap();
        s_wrapperMap.put("boolean", "Boolean");
        s_wrapperMap.put("byte", "Byte");
        s_wrapperMap.put("char", "Character");
        s_wrapperMap.put("double", "Double");
        s_wrapperMap.put("float", "Float");
        s_wrapperMap.put("int", "Integer");
        s_wrapperMap.put("long", "Long");
        s_wrapperMap.put("short", "Short");
        s_reservedWords = new HashSet();
        s_reservedWords.add("abstract");
        s_reservedWords.add("assert");
        s_reservedWords.add("boolean");
        s_reservedWords.add("break");
        s_reservedWords.add("byte");
        s_reservedWords.add("case");
        s_reservedWords.add("catch");
        s_reservedWords.add("char");
        s_reservedWords.add("class");
        s_reservedWords.add("const");
        s_reservedWords.add("continue");
        s_reservedWords.add("default");
        s_reservedWords.add("do");
        s_reservedWords.add("double");
        s_reservedWords.add("else");
        s_reservedWords.add("enum");
        s_reservedWords.add("extends");
        s_reservedWords.add("final");
        s_reservedWords.add("finally");
        s_reservedWords.add("float");
        s_reservedWords.add("for");
        s_reservedWords.add("goto");
        s_reservedWords.add("if");
        s_reservedWords.add("implements");
        s_reservedWords.add("import");
        s_reservedWords.add("instanceof");
        s_reservedWords.add("int");
        s_reservedWords.add("interface");
        s_reservedWords.add("long");
        s_reservedWords.add("native");
        s_reservedWords.add("new");
        s_reservedWords.add("package");
        s_reservedWords.add("private");
        s_reservedWords.add("protected");
        s_reservedWords.add("public");
        s_reservedWords.add("return");
        s_reservedWords.add("short");
        s_reservedWords.add("static");
        s_reservedWords.add("strictfp");
        s_reservedWords.add("super");
        s_reservedWords.add("switch");
        s_reservedWords.add("synchronized");
        s_reservedWords.add("this");
        s_reservedWords.add("throw");
        s_reservedWords.add("throws");
        s_reservedWords.add("transient");
        s_reservedWords.add("try");
        s_reservedWords.add("void");
        s_reservedWords.add("volatile");
        s_reservedWords.add("while");
        s_reservedWords.add("true");
        s_reservedWords.add("false");
        s_reservedWords.add("null");
        s_reservedWords.add("true");
        s_reservedWords.add("uctx");
        s_reservedWords.add("child");
        s_reservedWords.add("wrapper");
    }

    private static class NamedParameterTypeMapper
    extends JavaTypeMapper {
        private NamedParameterTypeMapper() {
        }

        public String getParameterName(javax.xml.namespace.QName qname) {
            return qname.getLocalPart();
        }
    }

    private class IncludePrevalidationVisitor
    extends ModelVisitor {
        private final ValidationContext m_context;

        private IncludePrevalidationVisitor(ValidationContext vctx) {
            this.m_context = vctx;
        }

        public boolean visit(IncludeElement node) {
            try {
                node.prevalidate(this.m_context);
            }
            catch (Throwable t) {
                this.m_context.addFatal("Error during validation: " + t.getMessage());
                t.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

