/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.java2wsdl;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.tools.maven.java2wsdl.AbstractGenerateWsdlMojo;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;

public class DeployMojo
extends AbstractGenerateWsdlMojo {
    private CompilerManager compilerManager;
    private File outputDirectory;
    private File sourceOutputDirectory;

    protected void postProcess(Emitter j2w, File wsdlFile) throws MojoExecutionException, MojoFailureException {
        Compiler compiler;
        Map nsmap;
        org.apache.axis.wsdl.toJava.Emitter w2j = new org.apache.axis.wsdl.toJava.Emitter();
        w2j.setServiceDesc(j2w.getServiceDesc());
        w2j.setQName2ClassMap(j2w.getQName2ClassMap());
        w2j.setOutputDir(this.sourceOutputDirectory.getAbsolutePath());
        w2j.setServerSide(true);
        w2j.setDeploy(true);
        w2j.setHelperWanted(true);
        String ns = j2w.getIntfNamespace();
        String clsName = j2w.getCls().getName();
        int idx = clsName.lastIndexOf(".");
        String pkg = null;
        if (idx > 0) {
            pkg = clsName.substring(0, idx);
            w2j.getNamespaceMap().put(ns, pkg);
        }
        if ((nsmap = j2w.getNamespaceMap()) != null) {
            Iterator i = nsmap.keySet().iterator();
            while (i.hasNext()) {
                pkg = (String)i.next();
                ns = (String)nsmap.get(pkg);
                w2j.getNamespaceMap().put(ns, pkg);
            }
        }
        w2j.setDeploy(true);
        if (j2w.getImplCls() != null) {
            w2j.setImplementationClassName(j2w.getImplCls().getName());
        } else if (!j2w.getCls().isInterface()) {
            w2j.setImplementationClassName(j2w.getCls().getName());
        } else {
            throw new MojoFailureException("implementation class is not specified.");
        }
        try {
            w2j.run(wsdlFile.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new MojoFailureException("Failed to generate deployment code", (Throwable)ex);
        }
        this.getProject().addCompileSourceRoot(this.sourceOutputDirectory.getPath());
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.outputDirectory.getAbsolutePath());
        compilerConfiguration.setSourceLocations(Collections.singletonList(this.sourceOutputDirectory.getAbsolutePath()));
        compilerConfiguration.setSourceVersion("1.4");
        compilerConfiguration.setTargetVersion("1.4");
        try {
            compiler = this.compilerManager.getCompiler("javac");
        }
        catch (NoSuchCompilerException ex) {
            throw new MojoExecutionException("No such compiler '" + ex.getCompilerId() + "'.");
        }
        try {
            compiler.compile(compilerConfiguration);
        }
        catch (CompilerException ex) {
            throw new MojoExecutionException("Compilation failed.", (Exception)((Object)ex));
        }
    }
}

