/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.model.wsdd.Deployment;
import org.apache.axis.model.wsdd.WSDDUtil;
import org.apache.axis.tools.maven.server.AbstractStartWebServerMojo;
import org.apache.axis.tools.maven.server.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.InputSource;

public class StartServerMojo
extends AbstractStartWebServerMojo {
    private File workDirBase;
    private int maxSessions;
    private FileSet[] wsdds;
    private File[] jwsDirs;
    private FileSet[] configs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartDaemon(int port) throws MojoExecutionException, MojoFailureException {
        Deployment deployment;
        File workDir;
        this.addAxisDependency("axis-standalone-server");
        if (this.jwsDirs != null && this.jwsDirs.length > 0) {
            this.addAxisDependency("axis-rt-jws");
        }
        if ((workDir = new File(this.workDirBase, String.valueOf(port))).exists()) {
            try {
                FileUtils.deleteDirectory((File)workDir);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Failed to clean the work directory", (Throwable)ex);
            }
        }
        File webInfDir = new File(workDir, "WEB-INF");
        webInfDir.mkdirs();
        try {
            deployment = WSDDUtil.buildDefaultConfiguration((ClassLoader)this.buildClassLoader(), (String)"server");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to build default server configuration", (Exception)ex);
        }
        if (this.wsdds != null) {
            for (int i = 0; i < this.wsdds.length; ++i) {
                FileSet wsdd = this.wsdds[i];
                DirectoryScanner scanner = wsdd.createScanner();
                scanner.scan();
                String[] includedFiles = scanner.getIncludedFiles();
                for (int j = 0; j < includedFiles.length; ++j) {
                    File wsddFile = new File(wsdd.getDirectory(), includedFiles[j]);
                    try {
                        deployment.merge(WSDDUtil.load((InputSource)new InputSource(wsddFile.toURI().toString())));
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Failed to load " + wsddFile, (Exception)ex);
                    }
                    this.getLog().info((CharSequence)("Processed " + wsddFile));
                }
            }
        }
        File serverConfigWsdd = new File(webInfDir, "server-config.wsdd");
        try {
            FileOutputStream out = new FileOutputStream(serverConfigWsdd);
            try {
                WSDDUtil.save((Deployment)deployment, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write " + serverConfigWsdd, (Exception)ex);
        }
        if (this.configs != null && this.configs.length > 0) {
            for (int i = 0; i < this.configs.length; ++i) {
                FileSet config = this.configs[i];
                DirectoryScanner scanner = config.createScanner();
                scanner.scan();
                String[] includedFiles = scanner.getIncludedFiles();
                for (int j = 0; j < includedFiles.length; ++j) {
                    String includedFile = includedFiles[j];
                    File source = new File(config.getDirectory(), includedFile);
                    try {
                        FileUtils.copyFile((File)source, (File)new File(webInfDir, includedFile));
                        continue;
                    }
                    catch (IOException ex) {
                        throw new MojoFailureException("Unable to copy " + source, (Throwable)ex);
                    }
                }
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-p");
        args.add(String.valueOf(port));
        args.add("-w");
        args.add(workDir.getAbsolutePath());
        if (this.jwsDirs != null && this.jwsDirs.length > 0) {
            args.add("-j");
            args.add(StringUtils.join((Object[])this.jwsDirs, (String)File.pathSeparator));
        }
        args.add("-m");
        args.add(String.valueOf(this.maxSessions));
        try {
            this.startDaemon("Server on port " + port, "org.apache.axis.server.standalone.daemon.AxisServerDaemon", args.toArray(new String[args.size()]), workDir);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Failed to start server", (Throwable)ex);
        }
    }

    private ClassLoader buildClassLoader() throws MojoExecutionException {
        List classpath;
        try {
            classpath = this.getClasspath();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to build classpath", ex);
        }
        URL[] urls = new URL[classpath.size()];
        for (int i = 0; i < classpath.size(); ++i) {
            try {
                urls[i] = ((File)classpath.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Unexpected exception", (Exception)ex);
            }
        }
        return new URLClassLoader(urls);
    }
}

