/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.server;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis.tools.maven.server.AbstractDaemonControlMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractStartDaemonMojo
extends AbstractDaemonControlMojo
implements LogEnabled {
    private MavenProject project;
    private MavenSession session;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepository localRepository;
    private List remoteArtifactRepositories;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactCollector artifactCollector;
    private ArtifactMetadataSource artifactMetadataSource;
    private ToolchainManager toolchainManager;
    private String debugArgs;
    private boolean debug;
    private String jmxArgs;
    private boolean jmx;
    private String argLine;
    private String axisVersion;
    private final Set additionalDependencies = new HashSet();
    private List classpath;
    private Logger logger;

    public final void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected final void addDependency(String groupId, String artifactId, String version) {
        this.additionalDependencies.add(this.artifactFactory.createArtifact(groupId, artifactId, version, "test", "jar"));
        this.classpath = null;
    }

    protected final void addAxisDependency(String artifactId) {
        this.addDependency("org.apache.axis", artifactId, this.axisVersion);
    }

    protected final List getClasspath() throws ProjectBuildingException, InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (this.classpath == null) {
            Artifact a;
            Iterator it;
            Log log = this.getLog();
            Set projectDependencies = this.project.getArtifacts();
            final HashSet<Artifact> artifacts = new HashSet<Artifact>(projectDependencies);
            if (this.additionalDependencies != null) {
                it = this.additionalDependencies.iterator();
                while (it.hasNext()) {
                    MavenProject p;
                    ArtifactFilter filter;
                    a = (Artifact)it.next();
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Resolving artifact to be added to classpath: " + a));
                    }
                    if (!(filter = new ArtifactFilter(){

                        public boolean include(Artifact artifact) {
                            String id = artifact.getDependencyConflictId();
                            Iterator it = artifacts.iterator();
                            while (it.hasNext()) {
                                if (!id.equals(((Artifact)it.next()).getDependencyConflictId())) continue;
                                return false;
                            }
                            return true;
                        }
                    }).include((p = this.projectBuilder.buildFromRepository(a, this.remoteArtifactRepositories, this.localRepository)).getArtifact())) continue;
                    Set s = p.createArtifacts(this.artifactFactory, "runtime", filter);
                    artifacts.addAll(this.artifactCollector.collect(s, p.getArtifact(), p.getManagedVersionMap(), this.localRepository, this.remoteArtifactRepositories, this.artifactMetadataSource, filter, Collections.singletonList(new DebugResolutionListener(this.logger))).getArtifacts());
                    artifacts.add(p.getArtifact());
                }
            }
            this.classpath = new ArrayList();
            this.classpath.add(new File(this.project.getBuild().getTestOutputDirectory()));
            this.classpath.add(new File(this.project.getBuild().getOutputDirectory()));
            it = artifacts.iterator();
            while (it.hasNext()) {
                a = (Artifact)it.next();
                if (!a.getArtifactHandler().isAddedToClasspath()) continue;
                if (a.getFile() == null) {
                    this.artifactResolver.resolve(a, this.remoteArtifactRepositories, this.localRepository);
                }
                this.classpath.add(a.getFile());
            }
        }
        return this.classpath;
    }

    private int allocatePort() throws MojoFailureException {
        try {
            ServerSocket ss = new ServerSocket(0);
            int port = ss.getLocalPort();
            ss.close();
            return port;
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to allocate port number", (Throwable)ex);
        }
    }

    protected final void startDaemon(String description, String daemonClass, String[] args, File workDir) throws MojoExecutionException, MojoFailureException {
        List classpath;
        Log log = this.getLog();
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        String jvm = tc != null ? tc.findTool("java") : System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Java executable: " + jvm));
        }
        int controlPort = this.allocatePort();
        try {
            classpath = this.getClasspath();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to build classpath", ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Class path elements: " + classpath));
        }
        ArrayList vmArgs = new ArrayList();
        if (this.debug) {
            AbstractStartDaemonMojo.processVMArgs(vmArgs, this.debugArgs);
        }
        if (this.jmx) {
            AbstractStartDaemonMojo.processVMArgs(vmArgs, this.jmxArgs);
        }
        if (this.argLine != null) {
            AbstractStartDaemonMojo.processVMArgs(vmArgs, this.argLine);
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Additional VM args: " + vmArgs));
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(jvm);
        cmdline.add("-cp");
        cmdline.add(StringUtils.join(classpath.iterator(), (String)File.pathSeparator));
        cmdline.addAll(vmArgs);
        cmdline.add("org.apache.axis.tools.daemon.Launcher");
        cmdline.add(daemonClass);
        cmdline.add(String.valueOf(controlPort));
        cmdline.addAll(Arrays.asList(args));
        try {
            this.getDaemonManager().startDaemon(description, cmdline.toArray(new String[cmdline.size()]), workDir, controlPort);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Failed to start server", (Throwable)ex);
        }
    }

    private static void processVMArgs(List vmArgs, String args) {
        vmArgs.addAll(Arrays.asList(args.split(" ")));
    }

    protected final void doExecute() throws MojoExecutionException, MojoFailureException {
        this.addAxisDependency("daemon-launcher");
        this.doStartDaemon();
    }

    protected abstract void doStartDaemon() throws MojoExecutionException, MojoFailureException;
}

