/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

@InterfaceAudience.Private
public class WindowsBasedProcessTree
extends ResourceCalculatorProcessTree {
    static final Log LOG = LogFactory.getLog(WindowsBasedProcessTree.class);
    private String taskProcessId = null;
    private long cpuTimeMs = -1L;
    private Map<String, ProcessInfo> processTree = new HashMap<String, ProcessInfo>();

    public static boolean isAvailable() {
        block6: {
            if (Shell.WINDOWS) {
                Shell.ShellCommandExecutor shellExecutor = new Shell.ShellCommandExecutor(new String[]{Shell.WINUTILS, "help"});
                try {
                    shellExecutor.execute();
                }
                catch (IOException e) {
                    LOG.error(StringUtils.stringifyException(e));
                }
                finally {
                    String output = shellExecutor.getOutput();
                    if (output == null || !output.contains("Prints to stdout a list of processes in the task")) break block6;
                    return true;
                }
            }
        }
        return false;
    }

    public WindowsBasedProcessTree(String pid) {
        super(pid);
        this.taskProcessId = pid;
    }

    String getAllProcessInfoFromShell() {
        Shell.ShellCommandExecutor shellExecutor = new Shell.ShellCommandExecutor(new String[]{Shell.WINUTILS, "task", "processList", this.taskProcessId});
        try {
            shellExecutor.execute();
            return shellExecutor.getOutput();
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException(e));
            return null;
        }
    }

    Map<String, ProcessInfo> createProcessInfo(String processesInfoStr) {
        String[] processesStr = processesInfoStr.split("\r\n");
        HashMap<String, ProcessInfo> allProcs = new HashMap<String, ProcessInfo>();
        int procInfoSplitCount = 4;
        for (String processStr : processesStr) {
            if (processStr == null) continue;
            String[] procInfo = processStr.split(",");
            if (procInfo.length == 4) {
                try {
                    ProcessInfo pInfo = new ProcessInfo();
                    pInfo.pid = procInfo[0];
                    pInfo.vmem = Long.parseLong(procInfo[1]);
                    pInfo.workingSet = Long.parseLong(procInfo[2]);
                    pInfo.cpuTimeMs = Long.parseLong(procInfo[3]);
                    allProcs.put(pInfo.pid, pInfo);
                }
                catch (NumberFormatException nfe) {
                    LOG.debug("Error parsing procInfo." + nfe);
                }
                continue;
            }
            LOG.debug("Expected split length of proc info to be 4. Got " + procInfo.length);
        }
        return allProcs;
    }

    @Override
    public void updateProcessTree() {
        if (this.taskProcessId != null) {
            String processesInfoStr = this.getAllProcessInfoFromShell();
            if (processesInfoStr != null && processesInfoStr.length() > 0) {
                Map<String, ProcessInfo> allProcessInfo = this.createProcessInfo(processesInfoStr);
                for (Map.Entry<String, ProcessInfo> entry : allProcessInfo.entrySet()) {
                    String pid = entry.getKey();
                    ProcessInfo pInfo = entry.getValue();
                    ProcessInfo oldInfo = this.processTree.get(pid);
                    if (oldInfo != null) {
                        pInfo.age += oldInfo.age;
                        pInfo.cpuTimeMsDelta = pInfo.cpuTimeMs - oldInfo.cpuTimeMs;
                        continue;
                    }
                    pInfo.cpuTimeMsDelta = pInfo.cpuTimeMs;
                }
                this.processTree.clear();
                this.processTree = allProcessInfo;
            } else {
                this.processTree.clear();
            }
        }
    }

    @Override
    public boolean checkPidPgrpidForMatch() {
        return true;
    }

    @Override
    public String getProcessTreeDump() {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("\t|- PID CPU_TIME(MILLIS) VMEM(BYTES) WORKING_SET(BYTES)%n", new Object[0]));
        for (ProcessInfo p : this.processTree.values()) {
            if (p == null) continue;
            ret.append(String.format("\t|- %s %d %d %d%n", p.pid, p.cpuTimeMs, p.vmem, p.workingSet));
        }
        return ret.toString();
    }

    @Override
    public long getVirtualMemorySize(int olderThanAge) {
        long total = -1L;
        for (ProcessInfo p : this.processTree.values()) {
            if (p == null) continue;
            if (total == -1L) {
                total = 0L;
            }
            if (p.age <= olderThanAge) continue;
            total += p.vmem;
        }
        return total;
    }

    @Override
    public long getCumulativeVmem(int olderThanAge) {
        return this.getVirtualMemorySize(olderThanAge);
    }

    @Override
    public long getRssMemorySize(int olderThanAge) {
        long total = -1L;
        for (ProcessInfo p : this.processTree.values()) {
            if (p == null) continue;
            if (total == -1L) {
                total = 0L;
            }
            if (p.age <= olderThanAge) continue;
            total += p.workingSet;
        }
        return total;
    }

    @Override
    public long getCumulativeRssmem(int olderThanAge) {
        return this.getRssMemorySize(olderThanAge);
    }

    @Override
    public long getCumulativeCpuTime() {
        for (ProcessInfo p : this.processTree.values()) {
            if (this.cpuTimeMs == -1L) {
                this.cpuTimeMs = 0L;
            }
            this.cpuTimeMs += p.cpuTimeMsDelta;
        }
        return this.cpuTimeMs;
    }

    @Override
    public float getCpuUsagePercent() {
        return -1.0f;
    }

    static class ProcessInfo {
        String pid;
        long vmem;
        long workingSet;
        long cpuTimeMs;
        long cpuTimeMsDelta;
        int age = 1;

        ProcessInfo() {
        }
    }
}

