/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class SingleCounterBlock
extends HtmlBlock {
    protected TreeMap<String, Long> values = new TreeMap();
    protected Job job;
    protected Task task;

    @Inject
    SingleCounterBlock(AppContext appCtx, View.ViewContext ctx) {
        super(ctx);
        this.populateMembers(appCtx);
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        if (this.job == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, no counters for nonexistent", this.$("job.id", "job")})))._();
            return;
        }
        if (!this.$("task.id").isEmpty() && this.task == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, no counters for nonexistent", this.$("task.id", "task")})))._();
            return;
        }
        String columnType = this.task == null ? "Task" : "Task Attempt";
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.DIV)html.div(".info-wrap.ui-widget-content.ui-corner-bottom")).table("#singleCounter")).thead()).tr()).th(".ui-state-default", columnType)).th(".ui-state-default", "Value")))._())._()).tbody();
        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
            HamletSpec.TR row = ((Hamlet.TBODY)tbody).tr();
            String id = entry.getKey();
            String val = entry.getValue().toString();
            if (this.task != null) {
                ((Hamlet.TR)row).td(id);
                ((HamletImpl.EImp)((Object)((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.BR)((Hamlet.TD)((Hamlet.TR)row).td()).br()).$title(val)))._())._(new Object[]{val})))._();
            } else {
                ((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)row).td()).a(this.url("singletaskcounter", entry.getKey(), this.$("counter.group"), this.$("counter.name")), id)))._();
                ((HamletImpl.EImp)((Object)((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.BR)((Hamlet.TD)((Hamlet.TR)row).td()).br()).$title(val)))._()).a(this.url("singletaskcounter", entry.getKey(), this.$("counter.group"), this.$("counter.name")), val)))._();
            }
            ((HamletImpl.EImp)((Object)row))._();
        }
        ((Hamlet.DIV)((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._())._();
    }

    private void populateMembers(AppContext ctx) {
        JobId jobID = null;
        TaskId taskID = null;
        String tid = this.$("task.id");
        if (!tid.isEmpty()) {
            taskID = MRApps.toTaskID(tid);
            jobID = taskID.getJobId();
        } else {
            String jid = this.$("job.id");
            if (!jid.isEmpty()) {
                jobID = MRApps.toJobID(jid);
            }
        }
        if (jobID == null) {
            return;
        }
        this.job = ctx.getJob(jobID);
        if (this.job == null) {
            return;
        }
        if (taskID != null) {
            this.task = this.job.getTask(taskID);
            if (this.task == null) {
                return;
            }
            for (Map.Entry entry : this.task.getAttempts().entrySet()) {
                Object c;
                CounterGroup group;
                long value = 0L;
                Counters counters = ((TaskAttempt)entry.getValue()).getCounters();
                CounterGroup counterGroup = group = counters != null ? (CounterGroup)counters.getGroup(this.$("counter.group")) : null;
                if (group != null && (c = group.findCounter(this.$("counter.name"))) != null) {
                    value = c.getValue();
                }
                this.values.put(MRApps.toString((TaskAttemptId)entry.getKey()), value);
            }
            return;
        }
        Map<TaskId, Task> tasks = this.job.getTasks();
        for (Map.Entry<TaskId, Task> entry : tasks.entrySet()) {
            Object c;
            CounterGroup group;
            long value = 0L;
            Counters counters = entry.getValue().getCounters();
            CounterGroup counterGroup = group = counters != null ? (CounterGroup)counters.getGroup(this.$("counter.group")) : null;
            if (group != null && (c = group.findCounter(this.$("counter.name"))) != null) {
                value = c.getValue();
            }
            this.values.put(MRApps.toString(entry.getKey()), value);
        }
    }
}

