/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.http.HttpRequestLogAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;

public class HttpRequestLog {
    public static final Log LOG = LogFactory.getLog(HttpRequestLog.class);
    private static final HashMap<String, String> serverToComponent = new HashMap();

    public static RequestLog getRequestLog(String name) {
        boolean isLog4JLogger;
        String lookup = serverToComponent.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        String appenderName = name + "requestlog";
        Log logger = LogFactory.getLog(loggerName);
        try {
            isLog4JLogger = logger instanceof Log4JLogger;
        }
        catch (NoClassDefFoundError err) {
            LOG.debug("Could not load Log4JLogger class", err);
            isLog4JLogger = false;
        }
        if (isLog4JLogger) {
            Log4JLogger httpLog4JLog = (Log4JLogger)logger;
            Logger httpLogger = httpLog4JLog.getLogger();
            Appender appender = null;
            try {
                appender = httpLogger.getAppender(appenderName);
            }
            catch (LogConfigurationException e) {
                LOG.warn("Http request log for " + loggerName + " could not be created");
                throw e;
            }
            if (appender == null) {
                LOG.info("Http request log for " + loggerName + " is not defined");
                return null;
            }
            if (appender instanceof HttpRequestLogAppender) {
                HttpRequestLogAppender requestLogAppender = (HttpRequestLogAppender)appender;
                NCSARequestLog requestLog = new NCSARequestLog();
                requestLog.setFilename(requestLogAppender.getFilename());
                requestLog.setRetainDays(requestLogAppender.getRetainDays());
                return requestLog;
            }
            LOG.warn("Jetty request log for " + loggerName + " was of the wrong class");
            return null;
        }
        LOG.warn("Jetty request log can only be enabled using Log4j");
        return null;
    }

    static {
        serverToComponent.put("cluster", "resourcemanager");
        serverToComponent.put("hdfs", "namenode");
        serverToComponent.put("node", "nodemanager");
    }
}

