/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RamDiskReplicaLruTracker
extends RamDiskReplicaTracker {
    Map<String, Map<Long, RamDiskReplicaLru>> replicaMaps = new HashMap<String, Map<Long, RamDiskReplicaLru>>();
    Queue<RamDiskReplicaLru> replicasNotPersisted = new LinkedList<RamDiskReplicaLru>();
    TreeMultimap<Long, RamDiskReplicaLru> replicasPersisted = TreeMultimap.create();

    RamDiskReplicaLruTracker() {
    }

    @Override
    synchronized void addReplica(String bpid, long blockId, FsVolumeImpl transientVolume) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        if (map == null) {
            map = new HashMap<Long, RamDiskReplicaLru>();
            this.replicaMaps.put(bpid, map);
        }
        RamDiskReplicaLru ramDiskReplicaLru = new RamDiskReplicaLru(bpid, blockId, transientVolume);
        map.put(blockId, ramDiskReplicaLru);
        this.replicasNotPersisted.add(ramDiskReplicaLru);
    }

    @Override
    synchronized void touch(String bpid, long blockId) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        RamDiskReplicaLru ramDiskReplicaLru = map.get(blockId);
        if (ramDiskReplicaLru == null) {
            return;
        }
        ramDiskReplicaLru.numReads.getAndIncrement();
        if (this.replicasPersisted.remove(ramDiskReplicaLru.lastUsedTime, ramDiskReplicaLru)) {
            ramDiskReplicaLru.lastUsedTime = Time.monotonicNow();
            this.replicasPersisted.put((Object)ramDiskReplicaLru.lastUsedTime, (Object)ramDiskReplicaLru);
        }
    }

    @Override
    synchronized void recordStartLazyPersist(String bpid, long blockId, FsVolumeImpl checkpointVolume) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        RamDiskReplicaLru ramDiskReplicaLru = map.get(blockId);
        ramDiskReplicaLru.setLazyPersistVolume(checkpointVolume);
    }

    @Override
    synchronized void recordEndLazyPersist(String bpid, long blockId, File[] savedFiles) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        RamDiskReplicaLru ramDiskReplicaLru = map.get(blockId);
        if (ramDiskReplicaLru == null) {
            throw new IllegalStateException("Unknown replica bpid=" + bpid + "; blockId=" + blockId);
        }
        ramDiskReplicaLru.recordSavedBlockFiles(savedFiles);
        if (this.replicasNotPersisted.peek() == ramDiskReplicaLru) {
            this.replicasNotPersisted.remove();
        } else {
            this.replicasNotPersisted.remove(ramDiskReplicaLru);
        }
        ramDiskReplicaLru.lastUsedTime = Time.monotonicNow();
        this.replicasPersisted.put((Object)ramDiskReplicaLru.lastUsedTime, (Object)ramDiskReplicaLru);
        ramDiskReplicaLru.isPersisted = true;
    }

    @Override
    synchronized RamDiskReplicaLru dequeueNextReplicaToPersist() {
        while (this.replicasNotPersisted.size() != 0) {
            RamDiskReplicaLru ramDiskReplicaLru = this.replicasNotPersisted.remove();
            Map<Long, RamDiskReplicaLru> replicaMap = this.replicaMaps.get(ramDiskReplicaLru.getBlockPoolId());
            if (replicaMap == null || replicaMap.get(ramDiskReplicaLru.getBlockId()) == null) continue;
            return ramDiskReplicaLru;
        }
        return null;
    }

    @Override
    synchronized void reenqueueReplicaNotPersisted(RamDiskReplicaTracker.RamDiskReplica ramDiskReplicaLru) {
        this.replicasNotPersisted.add((RamDiskReplicaLru)ramDiskReplicaLru);
    }

    @Override
    synchronized int numReplicasNotPersisted() {
        return this.replicasNotPersisted.size();
    }

    @Override
    synchronized RamDiskReplicaLru getNextCandidateForEviction() {
        Iterator it = this.replicasPersisted.values().iterator();
        while (it.hasNext()) {
            RamDiskReplicaLru ramDiskReplicaLru = (RamDiskReplicaLru)it.next();
            it.remove();
            Map<Long, RamDiskReplicaLru> replicaMap = this.replicaMaps.get(ramDiskReplicaLru.getBlockPoolId());
            if (replicaMap == null || replicaMap.get(ramDiskReplicaLru.getBlockId()) == null) continue;
            return ramDiskReplicaLru;
        }
        return null;
    }

    @Override
    synchronized void discardReplica(String bpid, long blockId, boolean deleteSavedCopies) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        if (map == null) {
            return;
        }
        RamDiskReplicaLru ramDiskReplicaLru = map.get(blockId);
        if (ramDiskReplicaLru == null) {
            return;
        }
        if (deleteSavedCopies) {
            ramDiskReplicaLru.deleteSavedFiles();
        }
        map.remove(blockId);
        this.replicasPersisted.remove(ramDiskReplicaLru.lastUsedTime, ramDiskReplicaLru);
    }

    @Override
    synchronized RamDiskReplicaTracker.RamDiskReplica getReplica(String bpid, long blockId) {
        Map<Long, RamDiskReplicaLru> map = this.replicaMaps.get(bpid);
        if (map == null) {
            return null;
        }
        return map.get(blockId);
    }

    private class RamDiskReplicaLru
    extends RamDiskReplicaTracker.RamDiskReplica {
        long lastUsedTime;

        private RamDiskReplicaLru(String bpid, long blockId, FsVolumeImpl ramDiskVolume) {
            super(bpid, blockId, ramDiskVolume);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }
    }
}

