/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class DoubleTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            e.writeDouble(state.testData[i + 0]);
            e.writeDouble(state.testData[i + 1]);
            e.writeDouble(state.testData[i + 2]);
            e.writeDouble(state.testData[i + 3]);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public double decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        double total = 0.0;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            total += d.readDouble();
            total += d.readDouble();
            total += d.readDouble();
            total += d.readDouble();
        }
        return total;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                encoder.writeDouble(super.getRandom().nextDouble());
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private double[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new double[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; ++i) {
                this.testData[i] = super.getRandom().nextDouble();
            }
        }
    }
}

