/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class ArrayTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        int items = state.getBatchSize() / 4;
        e.writeArrayStart();
        e.setItemCount(1L);
        e.startItem();
        e.writeArrayStart();
        e.setItemCount((long)items);
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            e.startItem();
            e.writeFloat(state.testData[i + 0]);
            e.writeFloat(state.testData[i + 1]);
            e.writeFloat(state.testData[i + 2]);
            e.writeFloat(state.testData[i + 3]);
        }
        e.writeArrayEnd();
        e.writeArrayEnd();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public float decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        float total = 0.0f;
        d.readArrayStart();
        long i = d.readArrayStart();
        while (i != 0L) {
            for (long j = 0L; j < i; ++j) {
                total += d.readFloat();
                total += d.readFloat();
                total += d.readFloat();
                total += d.readFloat();
            }
            i = d.arrayNext();
        }
        d.arrayNext();
        return total;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            int items = this.getBatchSize() / 4;
            encoder.writeArrayStart();
            encoder.setItemCount(1L);
            encoder.startItem();
            encoder.writeArrayStart();
            encoder.setItemCount((long)items);
            for (int i = 0; i < this.getBatchSize(); i += 4) {
                encoder.startItem();
                encoder.writeFloat(super.getRandom().nextFloat());
                encoder.writeFloat(super.getRandom().nextFloat());
                encoder.writeFloat(super.getRandom().nextFloat());
                encoder.writeFloat(super.getRandom().nextFloat());
            }
            encoder.writeArrayEnd();
            encoder.writeArrayEnd();
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private float[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new float[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; ++i) {
                this.testData[i] = super.getRandom().nextFloat();
            }
        }
    }
}

