/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.test.BasicArrayState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class ReflectLongArrayTest {
    private static final int ARRAY_SIZE = 10;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        long[][] lArray = state.testData;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long[] r = lArray[n2];
            state.datumWriter.write((Object)r, state.encoder);
            ++n2;
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        ReflectDatumReader datumReader = new ReflectDatumReader(state.schema);
        int i = 0;
        while (i < state.getBatchSize()) {
            blackhole.consume(datumReader.read(null, d));
            ++i;
        }
    }

    static long[] populateDoubleArray(Random r, int size) {
        long[] result = new long[size];
        int i = 0;
        while (i < result.length) {
            result[i] = r.nextLong();
            ++i;
        }
        return result;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicArrayState {
        private final Schema schema;
        private byte[] testData;
        private Decoder decoder;

        public TestStateDecode() {
            super(10);
            String jsonText = ReflectData.get().getSchema(long[].class).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            ReflectDatumWriter writer = new ReflectDatumWriter(this.schema);
            int i = 0;
            while (i < this.getBatchSize()) {
                long[] r = ReflectLongArrayTest.populateDoubleArray(this.getRandom(), this.getArraySize());
                writer.write((Object)r, encoder);
                ++i;
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.schema, super.newDecoder(this.testData));
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicArrayState {
        private final Schema schema;
        private long[][] testData;
        private Encoder encoder;
        private ReflectDatumWriter<long[]> datumWriter;

        public TestStateEncode() {
            super(10);
            String jsonText = ReflectData.get().getSchema(long[].class).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.datumWriter = new ReflectDatumWriter(this.schema);
            this.testData = new long[this.getBatchSize()][];
            int i = 0;
            while (i < this.testData.length) {
                this.testData[i] = ReflectLongArrayTest.populateDoubleArray(this.getRandom(), this.getArraySize());
                ++i;
            }
        }
    }
}

