/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class BooleanTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        int i = 0;
        while (i < state.getBatchSize()) {
            e.writeBoolean(state.testData[i + 0]);
            e.writeBoolean(state.testData[i + 1]);
            e.writeBoolean(state.testData[i + 2]);
            e.writeBoolean(state.testData[i + 3]);
            i += 4;
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public boolean decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        boolean total = true;
        int i = 0;
        while (i < state.getBatchSize()) {
            total ^= d.readBoolean();
            total ^= d.readBoolean();
            total ^= d.readBoolean();
            total ^= d.readBoolean();
            i += 4;
        }
        return total;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            int i = 0;
            while (i < this.getBatchSize()) {
                encoder.writeBoolean(super.getRandom().nextBoolean());
                ++i;
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private boolean[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new boolean[this.getBatchSize()];
            int i = 0;
            while (i < this.testData.length) {
                this.testData[i] = super.getRandom().nextBoolean();
                ++i;
            }
        }
    }
}

