/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import java.util.List;
import org.apache.atlas.notification.AtlasNotificationMessageDeserializer;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.entity.EntityMessageDeserializer;
import org.apache.atlas.notification.hook.HookMessageDeserializer;

public interface NotificationInterface {
    public static final String PROPERTY_PREFIX = "atlas.notification";

    public void init(String var1, Object var2);

    public void setCurrentUser(String var1);

    public <T> List<NotificationConsumer<T>> createConsumers(NotificationType var1, int var2);

    public <T> void send(NotificationType var1, T ... var2) throws NotificationException;

    public <T> void send(NotificationType var1, List<T> var2) throws NotificationException;

    public void close();

    public boolean isReady(NotificationType var1);

    public static enum NotificationType {
        HOOK(new HookMessageDeserializer()),
        ENTITIES(new EntityMessageDeserializer());

        private final AtlasNotificationMessageDeserializer deserializer;

        private NotificationType(AtlasNotificationMessageDeserializer deserializer) {
            this.deserializer = deserializer;
        }

        public AtlasNotificationMessageDeserializer getDeserializer() {
            return this.deserializer;
        }
    }
}

