/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import java.io.File;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.RollingFileAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LogConfigUtils.class);

    public static String getRootDir() {
        String ret = LogConfigUtils.getFileAppenderPath();
        if (StringUtils.isEmpty((String)ret)) {
            ret = LogConfigUtils.getFileAppenderPathApproach2();
        }
        ret = StringUtils.isNotEmpty((String)ret) ? StringUtils.substringBeforeLast((String)ret, (String)File.separator) : null;
        LOG.info("getRootDir(): ret={}", (Object)ret);
        return ret;
    }

    private static String getFileAppenderPath() {
        String ret = "";
        try {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext();
            Configuration configuration = loggerContext.getConfiguration();
            String rrfaFilename = null;
            String rfaFilename = null;
            String faFilename = null;
            for (Appender appender : configuration.getAppenders().values()) {
                RollingRandomAccessFileAppender fileAppender;
                if (rrfaFilename == null && appender instanceof RollingRandomAccessFileAppender) {
                    fileAppender = (RollingRandomAccessFileAppender)appender;
                    rrfaFilename = fileAppender.getFileName();
                    LOG.debug("RollingRandomAccessFileAppender(name={}, fileName={})", (Object)fileAppender.getName(), (Object)fileAppender.getFileName());
                    continue;
                }
                if (rfaFilename == null && appender instanceof org.apache.logging.log4j.core.appender.RollingFileAppender) {
                    fileAppender = (org.apache.logging.log4j.core.appender.RollingFileAppender)appender;
                    rfaFilename = fileAppender.getFileName();
                    LOG.debug("RollingFileAppender(name={}, fileName={})", (Object)fileAppender.getName(), (Object)fileAppender.getFileName());
                    continue;
                }
                if (faFilename == null && appender instanceof FileAppender) {
                    fileAppender = (FileAppender)appender;
                    faFilename = fileAppender.getFileName();
                    LOG.debug("FileAppender(name={}, fileName={})", (Object)fileAppender.getName(), (Object)fileAppender.getFileName());
                    continue;
                }
                LOG.info("Could not infer log path from this appender: {}", (Object)appender.getClass().getName());
            }
            if (rrfaFilename != null) {
                ret = rrfaFilename;
            } else if (rfaFilename != null) {
                ret = rfaFilename;
            } else if (faFilename != null) {
                ret = faFilename;
            }
            LOG.info("getFileAppenderPath(): ret={}", (Object)ret);
        }
        catch (Throwable t) {
            LOG.info("getFileAppenderPath(): failed to get log path from org.apache.logging.log4j. error: {}", (Object)t.getMessage());
        }
        return ret;
    }

    private static String getFileAppenderPathApproach2() {
        String ret = "";
        try {
            org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
            Enumeration allAppenders = rootLogger.getAllAppenders();
            if (allAppenders != null) {
                String drfaFilename = null;
                String rfaFilename = null;
                String faFilename = null;
                while (allAppenders.hasMoreElements()) {
                    DailyRollingFileAppender fileAppender;
                    Object appender = allAppenders.nextElement();
                    if (drfaFilename == null && appender instanceof DailyRollingFileAppender) {
                        fileAppender = (DailyRollingFileAppender)appender;
                        drfaFilename = fileAppender.getFile();
                        LOG.debug("DailyRollingFileAppender(name={}, file={})", (Object)fileAppender.getName(), (Object)fileAppender.getFile());
                        continue;
                    }
                    if (rfaFilename == null && appender instanceof RollingFileAppender) {
                        fileAppender = (RollingFileAppender)appender;
                        rfaFilename = fileAppender.getFile();
                        LOG.debug("RollingFileAppender(name={}, file={}, append={})", (Object)fileAppender.getName(), (Object)fileAppender.getFile());
                        continue;
                    }
                    if (faFilename != null || !(appender instanceof org.apache.log4j.FileAppender)) continue;
                    fileAppender = (org.apache.log4j.FileAppender)appender;
                    faFilename = fileAppender.getFile();
                    LOG.debug("FileAppender(name={}, file={}, append={})", (Object)fileAppender.getName(), (Object)fileAppender.getFile());
                }
                if (drfaFilename != null) {
                    ret = drfaFilename;
                } else if (rfaFilename != null) {
                    ret = rfaFilename;
                } else if (faFilename != null) {
                    ret = faFilename;
                }
            }
            LOG.info("getFileAppenderPathApproach2(): ret={}", (Object)ret);
        }
        catch (Throwable t) {
            LOG.error("getFileAppenderPathApproach2(): failed to get log path from org.apache.log4j.", t);
        }
        return ret;
    }
}

