/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryTreeIndexOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;

public class SecondaryBTreeOperationsHelper
extends SecondaryTreeIndexOperationsHelper {
    protected SecondaryBTreeOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        super(dataset, index, metadataProvider, sourceLoc);
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        boolean isOverridingKeyFieldTypes = this.index.isOverridingKeyFieldTypes();
        int[] fieldPermutation = this.createFieldPermutationForBulkLoadOp(this.index.getKeyFieldNames().size());
        IndexDataflowHelperFactory dataflowHelperFactory = new IndexDataflowHelperFactory(this.metadataProvider.getStorageComponentProvider().getStorageManager(), this.secondaryFileSplitProvider);
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            ExternalScanOperatorDescriptor primaryScanOp;
            ExternalScanOperatorDescriptor sourceOp = primaryScanOp = this.createExternalIndexingOp(spec);
            if (isOverridingKeyFieldTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
                sourceOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)primaryScanOp, 0, (IOperatorDescriptor)sourceOp, 0);
            }
            AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createExternalAssignOp(spec, this.index.getKeyFieldNames().size(), this.secondaryRecDesc);
            AlgebricksMetaOperatorDescriptor selectOp = null;
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                selectOp = this.createFilterNullsSelectOp(spec, this.index.getKeyFieldNames().size(), this.secondaryRecDesc);
            }
            ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, this.secondaryComparatorFactories, this.secondaryRecDesc);
            Object secondaryBulkLoadOp = this.externalFiles != null ? this.createExternalIndexBulkModifyOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)dataflowHelperFactory, 1.0f) : this.createExternalIndexBulkLoadOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)dataflowHelperFactory, 1.0f);
            SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
            sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
            AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[]{this.secondaryRecDesc});
            metaOp.setSourceLocation(this.sourceLoc);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)secondaryBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
            AlgebricksMetaOperatorDescriptor root = metaOp;
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sourceOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)selectOp, 0);
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)selectOp, 0, (IOperatorDescriptor)sortOp, 0);
            } else {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)sortOp, 0);
            }
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)secondaryBulkLoadOp, 0);
            spec.addRoot((IOperatorDescriptor)root);
            spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
            return spec;
        }
        IndexUtil.bindJobEventListener(spec, this.metadataProvider);
        IOperatorDescriptor sourceOp = DatasetUtil.createDummyKeyProviderOp(spec, this.dataset, this.metadataProvider);
        IOperatorDescriptor targetOp = DatasetUtil.createPrimaryIndexScanOp(spec, this.metadataProvider, this.dataset);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        if (isOverridingKeyFieldTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
            targetOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        targetOp = this.createAssignOp(spec, this.index.getKeyFieldNames().size(), this.secondaryRecDesc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
            targetOp = this.createFilterNullsSelectOp(spec, this.index.getKeyFieldNames().size(), this.secondaryRecDesc);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        if (!this.index.getKeyFieldNames().isEmpty()) {
            targetOp = this.createSortOp(spec, this.secondaryComparatorFactories, this.secondaryRecDesc);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        targetOp = this.createTreeIndexBulkLoadOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)dataflowHelperFactory, 1.0f);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
        sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
        targetOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[]{this.secondaryRecDesc});
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        spec.addRoot(targetOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    protected int getNumSecondaryKeys() {
        return this.index.getKeyFieldNames().size();
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        int i;
        int numSecondaryKeys = this.index.getKeyFieldNames().size();
        this.secondaryFieldAccessEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeys + this.numFilterFields];
        this.secondaryComparatorFactories = new IBinaryComparatorFactory[numSecondaryKeys + this.numPrimaryKeys];
        this.secondaryBloomFilterKeyFields = new int[numSecondaryKeys];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + numSecondaryKeys + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[numSecondaryKeys + this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = this.metadataProvider.getDataFormat().getSerdeProvider();
        ITypeTraitProvider typeTraitProvider = this.metadataProvider.getDataFormat().getTypeTraitProvider();
        IBinaryComparatorFactoryProvider comparatorFactoryProvider = this.metadataProvider.getDataFormat().getBinaryComparatorFactoryProvider();
        int recordColumn = this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? this.numPrimaryKeys : 0;
        boolean isOverridingKeyFieldTypes = this.index.isOverridingKeyFieldTypes();
        for (i = 0; i < numSecondaryKeys; ++i) {
            ISerializerDeserializer keySerde;
            int sourceColumn;
            ARecordType sourceType;
            List<Integer> keySourceIndicators = this.index.getKeyFieldSourceIndicators();
            if (keySourceIndicators == null || keySourceIndicators.get(i) == 0) {
                sourceType = this.itemType;
                sourceColumn = recordColumn;
            } else {
                sourceType = this.metaType;
                sourceColumn = recordColumn + 1;
            }
            this.secondaryFieldAccessEvalFactories[i] = this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(this.metadataProvider.getFunctionManager(), isOverridingKeyFieldTypes ? this.enforcedItemType : sourceType, this.index.getKeyFieldNames().get(i), sourceColumn, this.sourceLoc);
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(this.index.getKeyFieldTypes().get(i), this.index.getKeyFieldNames().get(i), sourceType);
            IAType keyType = (IAType)keyTypePair.first;
            this.anySecondaryKeyIsNullable = this.anySecondaryKeyIsNullable || (Boolean)keyTypePair.second != false;
            secondaryRecFields[i] = keySerde = serdeProvider.getSerializerDeserializer((Object)keyType);
            this.secondaryComparatorFactories[i] = comparatorFactoryProvider.getBinaryComparatorFactory((Object)keyType, true);
            this.secondaryTypeTraits[i] = typeTraitProvider.getTypeTrait((Object)keyType);
            this.secondaryBloomFilterKeyFields[i] = i;
        }
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[numSecondaryKeys + i] = this.primaryRecDesc.getFields()[i];
                enforcedRecFields[i] = this.primaryRecDesc.getFields()[i];
                this.secondaryTypeTraits[numSecondaryKeys + i] = this.primaryRecDesc.getTypeTraits()[i];
                enforcedTypeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
                this.secondaryComparatorFactories[numSecondaryKeys + i] = this.primaryComparatorFactories[i];
            }
        } else {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[numSecondaryKeys + i] = IndexingConstants.getSerializerDeserializer((int)i);
                enforcedRecFields[i] = IndexingConstants.getSerializerDeserializer((int)i);
                this.secondaryTypeTraits[numSecondaryKeys + i] = IndexingConstants.getTypeTraits((int)i);
                enforcedTypeTraits[i] = IndexingConstants.getTypeTraits((int)i);
                this.secondaryComparatorFactories[numSecondaryKeys + i] = IndexingConstants.getComparatorFactory((int)i);
            }
        }
        enforcedRecFields[this.numPrimaryKeys] = serdeProvider.getSerializerDeserializer((Object)this.itemType);
        enforcedTypeTraits[this.numPrimaryKeys] = typeTraitProvider.getTypeTrait((Object)this.itemType);
        if (this.dataset.hasMetaPart()) {
            enforcedRecFields[this.numPrimaryKeys + 1] = serdeProvider.getSerializerDeserializer((Object)this.metaType);
            enforcedTypeTraits[this.numPrimaryKeys + 1] = typeTraitProvider.getTypeTrait((Object)this.metaType);
        }
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            this.secondaryFieldAccessEvalFactories[numSecondaryKeys] = this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(this.metadataProvider.getFunctionManager(), this.itemType, this.filterFieldName, this.numPrimaryKeys, this.sourceLoc);
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableKeyFieldType(this.filterFieldName, this.itemType);
            IAType type = (IAType)keyTypePair.first;
            secondaryRecFields[this.numPrimaryKeys + numSecondaryKeys] = serde = serdeProvider.getSerializerDeserializer((Object)type);
            enforcedRecFields[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = serde;
            enforcedTypeTraits[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = typeTraitProvider.getTypeTrait((Object)type);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields, this.secondaryTypeTraits);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
    }

    private int[] createFieldPermutationForBulkLoadOp(int numSecondaryKeyFields) {
        int[] fieldPermutation = new int[numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        for (int i = 0; i < fieldPermutation.length; ++i) {
            fieldPermutation[i] = i;
        }
        return fieldPermutation;
    }
}

