/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.functions.ExternalScalarFunctionInfo;
import org.apache.asterix.metadata.functions.ExternalTypeComputer;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class ExternalFunctionCompilerUtil {
    private ExternalFunctionCompilerUtil() {
    }

    public static IFunctionInfo getExternalFunctionInfo(MetadataProvider metadataProvider, Function function) throws AlgebricksException {
        String functionKind = function.getKind();
        IFunctionInfo finfo = null;
        if (AbstractFunctionCallExpression.FunctionKind.SCALAR.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getScalarFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.AGGREGATE.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getAggregateFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.STATEFUL.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getStatefulFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.UNNEST.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getUnnestFunctionInfo(metadataProvider, function);
        }
        return finfo;
    }

    private static IFunctionInfo getScalarFunctionInfo(MetadataProvider metadataProvider, Function function) throws AlgebricksException {
        ExternalFunctionLanguage lang;
        if (function.getDeterministic() == null) {
            throw new AsterixException(1070, new Serializable[]{""});
        }
        ArrayList<IAType> paramTypes = new ArrayList<IAType>(function.getParameterTypes().size());
        for (TypeSignature ts : function.getParameterTypes()) {
            IAType paramType = ExternalFunctionCompilerUtil.resolveFunctionType(ts, metadataProvider);
            paramTypes.add(paramType);
        }
        IAType returnType = ExternalFunctionCompilerUtil.resolveFunctionType(function.getReturnType(), metadataProvider);
        ExternalTypeComputer typeComputer = new ExternalTypeComputer(returnType, paramTypes);
        try {
            lang = ExternalFunctionLanguage.valueOf((String)function.getLanguage());
        }
        catch (IllegalArgumentException e) {
            throw new AsterixException(1070, new Serializable[]{function.getLanguage()});
        }
        List<String> externalIdentifier = ExternalFunctionCompilerUtil.decodeExternalIdentifier(lang, function.getFunctionBody());
        return new ExternalScalarFunctionInfo(function.getSignature().createFunctionIdentifier(), returnType, externalIdentifier, lang, function.getLibrary(), paramTypes, function.getResources(), function.getDeterministic(), (IResultTypeComputer)typeComputer);
    }

    private static IFunctionInfo getUnnestFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static IFunctionInfo getStatefulFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static IFunctionInfo getAggregateFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static IAType resolveFunctionType(TypeSignature typeSignature, MetadataProvider metadataProvider) throws AlgebricksException {
        String typeName = typeSignature.getName();
        if (BuiltinType.ANY.getTypeName().equals(typeName)) {
            return BuiltinType.ANY;
        }
        BuiltinType type = BuiltinTypeMap.getBuiltinType(typeName);
        if (type == null) {
            type = metadataProvider.findType(typeSignature.getDataverseName(), typeName);
        }
        return type;
    }

    public static String encodeExternalIdentifier(FunctionSignature functionSignature, ExternalFunctionLanguage language, List<String> identList) throws AlgebricksException {
        switch (language) {
            case JAVA: {
                return identList.get(0);
            }
            case PYTHON: {
                String ident0 = identList.get(0);
                String ident1 = identList.size() > 1 ? identList.get(1) : functionSignature.getName();
                boolean classExists = ident0.indexOf(58) > 0;
                return ident0 + (classExists ? (char)'.' : ':') + ident1;
            }
        }
        throw new AsterixException(1079, new Serializable[]{language});
    }

    public static List<String> decodeExternalIdentifier(ExternalFunctionLanguage language, String encodedValue) throws AlgebricksException {
        switch (language) {
            case JAVA: {
                return Collections.singletonList(encodedValue);
            }
            case PYTHON: {
                int d1 = encodedValue.indexOf(58);
                if (d1 <= 0) {
                    throw new AsterixException(1079, new Serializable[]{encodedValue});
                }
                String moduleName = encodedValue.substring(0, d1);
                int d2 = encodedValue.lastIndexOf(46);
                if (d2 > d1) {
                    String className = encodedValue.substring(d1 + 1, d2);
                    String methodName = encodedValue.substring(d2 + 1);
                    return Arrays.asList(moduleName, className, methodName);
                }
                String functionName = encodedValue.substring(d1 + 1);
                return Arrays.asList(moduleName, functionName);
            }
        }
        throw new AsterixException(1079, new Serializable[]{language});
    }
}

