/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.common.api.IDatasetInfoProvider;
import org.apache.asterix.common.api.ILSMComponentIdGeneratorFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicyFactory;
import org.apache.asterix.common.context.DatasetInfoProvider;
import org.apache.asterix.common.context.DatasetLSMComponentIdGeneratorFactory;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.ioopcallbacks.LSMIndexIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMIndexPageWriteCallbackFactory;
import org.apache.asterix.common.utils.StorageConstants;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.adapter.factory.GenericAdapterFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.resource.DatasetLocalResourceFactory;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.build.IndexBuilder;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelper;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeLocalResourceFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.impls.ConcurrentMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.ConstantMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.NoMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicyFactory;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataBootstrap {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static INcApplicationContext appContext;
    private static ILocalResourceRepository localResourceRepository;
    private static IIOManager ioManager;
    private static String metadataNodeName;
    private static List<String> nodeNames;
    private static boolean isNewUniverse;
    private static final IMetadataIndex[] PRIMARY_INDEXES;

    private MetadataBootstrap() {
    }

    public static void startUniverse(INCServiceContext ncServiceContext, boolean isNewUniverse) throws RemoteException, ACIDException, AlgebricksException {
        MetadataBootstrap.setNewUniverse(isNewUniverse);
        appContext = (INcApplicationContext)ncServiceContext.getApplicationContext();
        MetadataProperties metadataProperties = appContext.getMetadataProperties();
        metadataNodeName = metadataProperties.getMetadataNodeName();
        nodeNames = metadataProperties.getNodeNames();
        localResourceRepository = appContext.getLocalResourceRepository();
        ioManager = ncServiceContext.getIoManager();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
                MetadataBootstrap.enlistMetadataDataset(ncServiceContext, PRIMARY_INDEXES[i]);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Finished enlistment of metadata B-trees in " + (isNewUniverse ? "new" : "old") + " universe");
            }
            if (isNewUniverse) {
                MetadataBootstrap.insertInitialDataverses(mdTxnCtx);
                MetadataBootstrap.insertMetadataDatasets(mdTxnCtx, PRIMARY_INDEXES);
                MetadataBootstrap.insertMetadataDatatypes(mdTxnCtx);
                MetadataBootstrap.insertNodes(mdTxnCtx);
                MetadataBootstrap.insertInitialGroups(mdTxnCtx);
                MetadataBootstrap.insertInitialAdapters(mdTxnCtx);
                BuiltinFeedPolicies.insertInitialFeedPolicies(mdTxnCtx);
                MetadataBootstrap.insertInitialCompactionPolicies(mdTxnCtx);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Finished creating metadata B-trees.");
                }
            } else {
                MetadataBootstrap.insertNewCompactionPoliciesIfNotExist(mdTxnCtx);
                MetadataBootstrap.insertSynonymEntitiesIfNotExist(mdTxnCtx);
            }
            MetadataManager.INSTANCE.initializeDatasetIdFactory(mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw new MetadataException((Throwable)e);
            }
            throw new MetadataException((Throwable)e);
        }
    }

    private static void insertInitialDataverses(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        String dataFormat = "org.apache.asterix.runtime.formats.NonTaggedDataFormat";
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(MetadataConstants.METADATA_DATAVERSE_NAME, dataFormat, 0));
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, MetadataBuiltinEntities.DEFAULT_DATAVERSE);
    }

    public static void insertMetadataDatasets(MetadataTransactionContext mdTxnCtx, IMetadataIndex[] indexes) throws AlgebricksException {
        for (int i = 0; i < indexes.length; ++i) {
            InternalDatasetDetails id = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, indexes[i].getPartitioningExpr(), indexes[i].getPartitioningExpr(), null, indexes[i].getPartitioningExprType(), false, null);
            MetadataManager.INSTANCE.addDataset(mdTxnCtx, new Dataset(indexes[i].getDataverseName(), indexes[i].getIndexedDatasetName(), indexes[i].getDataverseName(), indexes[i].getPayloadRecordType().getTypeName(), indexes[i].getNodeGroupName(), "concurrent", StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES, id, new HashMap<String, String>(), DatasetConfig.DatasetType.INTERNAL, indexes[i].getDatasetId().getId(), 0));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished inserting initial datasets.");
        }
    }

    public static void getMetadataIndexes(List<IMetadataIndex> outIndexes) {
        Collections.addAll(outIndexes, PRIMARY_INDEXES);
    }

    private static void getMetadataTypes(ArrayList<IAType> types) {
        for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
            types.add((IAType)PRIMARY_INDEXES[i].getPayloadRecordType());
        }
    }

    private static void insertMetadataDatatypes(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ArrayList<IAType> types = new ArrayList<IAType>();
        types.addAll(BuiltinTypeMap.getAllBuiltinTypes());
        MetadataBootstrap.getMetadataTypes(types);
        for (int i = 0; i < types.size(); ++i) {
            MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(MetadataConstants.METADATA_DATAVERSE_NAME, types.get(i).getTypeName(), types.get(i), false));
        }
        MetadataManager.INSTANCE.addDatatype(mdTxnCtx, MetadataBuiltinEntities.ANY_OBJECT_DATATYPE);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished inserting initial datatypes.");
        }
    }

    private static void insertNodes(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        for (String nodesName : nodeNames) {
            MetadataManager.INSTANCE.addNode(mdTxnCtx, new Node(nodesName, 0L, 0L));
        }
    }

    private static void insertInitialGroups(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ArrayList<String> metadataGroupNodeNames = new ArrayList<String>();
        metadataGroupNodeNames.add(metadataNodeName);
        NodeGroup groupRecord = new NodeGroup("MetadataGroup", metadataGroupNodeNames);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, groupRecord);
    }

    private static void insertInitialAdapters(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        String[] builtInAdapterClassNames;
        for (String adapterClassName : builtInAdapterClassNames = new String[]{GenericAdapterFactory.class.getName()}) {
            DatasourceAdapter adapter = MetadataBootstrap.getAdapter(adapterClassName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished inserting built-in adapters.");
        }
    }

    private static void insertInitialCompactionPolicies(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        String[] builtInCompactionPolicyClassNames;
        for (String policyClassName : builtInCompactionPolicyClassNames = new String[]{ConstantMergePolicyFactory.class.getName(), PrefixMergePolicyFactory.class.getName(), ConcurrentMergePolicyFactory.class.getName(), NoMergePolicyFactory.class.getName(), CorrelatedPrefixMergePolicyFactory.class.getName()}) {
            CompactionPolicy compactionPolicy = MetadataBootstrap.getCompactionPolicyEntity(policyClassName);
            MetadataManager.INSTANCE.addCompactionPolicy(mdTxnCtx, compactionPolicy);
        }
    }

    private static void insertNewCompactionPoliciesIfNotExist(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        if (MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, "concurrent") == null) {
            CompactionPolicy compactionPolicy = MetadataBootstrap.getCompactionPolicyEntity(ConcurrentMergePolicyFactory.class.getName());
            MetadataManager.INSTANCE.addCompactionPolicy(mdTxnCtx, compactionPolicy);
        }
    }

    private static void insertSynonymEntitiesIfNotExist(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ARecordType synonymDatasetRecordType = MetadataPrimaryIndexes.SYNONYM_DATASET.getPayloadRecordType();
        if (MetadataManager.INSTANCE.getDatatype(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, synonymDatasetRecordType.getTypeName()) == null) {
            MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(MetadataConstants.METADATA_DATAVERSE_NAME, synonymDatasetRecordType.getTypeName(), (IAType)synonymDatasetRecordType, false));
        }
        if (MetadataManager.INSTANCE.getDataset(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, "Synonym") == null) {
            MetadataBootstrap.insertMetadataDatasets(mdTxnCtx, new IMetadataIndex[]{MetadataPrimaryIndexes.SYNONYM_DATASET});
        }
    }

    private static DatasourceAdapter getAdapter(String adapterFactoryClassName) throws AlgebricksException {
        try {
            String adapterName = ((ITypedAdapterFactory)Class.forName(adapterFactoryClassName).newInstance()).getAlias();
            return new DatasourceAdapter(new AdapterIdentifier(MetadataConstants.METADATA_DATAVERSE_NAME, adapterName), adapterFactoryClassName, IDataSourceAdapter.AdapterType.INTERNAL);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Adapter", (Throwable)e);
        }
    }

    private static CompactionPolicy getCompactionPolicyEntity(String compactionPolicyClassName) throws AlgebricksException {
        try {
            String policyName = ((ILSMMergePolicyFactory)Class.forName(compactionPolicyClassName).newInstance()).getName();
            return new CompactionPolicy(MetadataConstants.METADATA_DATAVERSE_NAME, policyName, compactionPolicyClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Merge Policy Factory", (Throwable)e);
        }
    }

    public static void enlistMetadataDataset(INCServiceContext ncServiceCtx, IMetadataIndex index) throws HyracksDataException {
        boolean createMetadataDataset;
        LocalResource resource;
        int datasetId = index.getDatasetId().getId();
        String metadataPartitionPath = StoragePathUtil.prepareStoragePartitionPath((int)MetadataNode.INSTANCE.getMetadataStoragePartition());
        String resourceName = metadataPartitionPath + File.separator + index.getFileNameRelativePath();
        FileReference file = ioManager.resolve(resourceName);
        index.setFile(file);
        ITypeTraits[] typeTraits = index.getTypeTraits();
        IBinaryComparatorFactory[] cmpFactories = index.getKeyBinaryComparatorFactory();
        int[] bloomFilterKeyFields = index.getBloomFilterKeyFields();
        PrimaryIndexOperationTrackerFactory opTrackerFactory = index.isPrimaryIndex() ? new PrimaryIndexOperationTrackerFactory(datasetId) : new SecondaryIndexOperationTrackerFactory(datasetId);
        DatasetLSMComponentIdGeneratorFactory idGeneratorProvider = new DatasetLSMComponentIdGeneratorFactory(datasetId);
        DatasetInfoProvider datasetInfoProvider = new DatasetInfoProvider(datasetId);
        LSMIndexIOOperationCallbackFactory ioOpCallbackFactory = new LSMIndexIOOperationCallbackFactory((ILSMComponentIdGeneratorFactory)idGeneratorProvider, (IDatasetInfoProvider)datasetInfoProvider);
        LSMIndexPageWriteCallbackFactory pageWriteCallbackFactory = new LSMIndexPageWriteCallbackFactory();
        IStorageComponentProvider storageComponentProvider = appContext.getStorageComponentProvider();
        if (MetadataBootstrap.isNewUniverse()) {
            resource = null;
            createMetadataDataset = true;
        } else {
            resource = localResourceRepository.get(file.getRelativePath());
            boolean bl = createMetadataDataset = resource == null;
            if (createMetadataDataset) {
                MetadataBootstrap.ensureCatalogUpgradability(index);
            }
        }
        if (createMetadataDataset) {
            double bloomFilterFalsePositiveRate = appContext.getStorageProperties().getBloomFilterFalsePositiveRate();
            LSMBTreeLocalResourceFactory lsmBtreeFactory = new LSMBTreeLocalResourceFactory(storageComponentProvider.getStorageManager(), typeTraits, cmpFactories, null, null, null, (ILSMOperationTrackerFactory)opTrackerFactory, (ILSMIOOperationCallbackFactory)ioOpCallbackFactory, (ILSMPageWriteCallbackFactory)pageWriteCallbackFactory, storageComponentProvider.getMetadataPageManagerFactory(), (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), storageComponentProvider.getIoOperationSchedulerProvider(), appContext.getMetadataMergePolicyFactory(), StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES, true, bloomFilterKeyFields, bloomFilterFalsePositiveRate, true, null, NoOpCompressorDecompressorFactory.INSTANCE, true);
            DatasetLocalResourceFactory dsLocalResourceFactory = new DatasetLocalResourceFactory(datasetId, (IResourceFactory)lsmBtreeFactory);
            IndexBuilder indexBuilder = new IndexBuilder(ncServiceCtx, storageComponentProvider.getStorageManager(), index::getResourceId, file, (IResourceFactory)dsLocalResourceFactory, true);
            indexBuilder.build();
        } else {
            if (index.getResourceId() != resource.getId()) {
                throw new HyracksDataException("Resource Id doesn't match expected metadata index resource id");
            }
            IndexDataflowHelper indexHelper = new IndexDataflowHelper(ncServiceCtx, storageComponentProvider.getStorageManager(), file);
            indexHelper.open();
            indexHelper.close();
        }
    }

    public static void startDDLRecovery() throws AlgebricksException {
        MetadataTransactionContext mdTxnCtx = null;
        LOGGER.info("Starting DDL recovery ...");
        try {
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            List<Dataverse> dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
            for (Dataverse dataverse : dataverses) {
                MetadataBootstrap.recoverDataverse(mdTxnCtx, dataverse);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            LOGGER.info("Completed DDL recovery.");
        }
        catch (Exception e) {
            try {
                LOGGER.error("Failure during DDL recovery", (Throwable)e);
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw MetadataException.create((Throwable)e);
        }
    }

    private static void recoverDataverse(MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws AlgebricksException {
        if (dataverse.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverse.getDataverseName());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Dropped a pending dataverse: " + dataverse.getDataverseName());
            }
        } else {
            List<Dataset> datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
            for (Dataset dataset : datasets) {
                MetadataBootstrap.recoverDataset(mdTxnCtx, dataset);
            }
        }
    }

    private static void recoverDataset(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws AlgebricksException {
        List<Index> indexes;
        if (dataset.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataset(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Dropped a pending dataset: " + dataset.getDataverseName() + "." + dataset.getDatasetName());
            }
        } else {
            indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            for (Index index : indexes) {
                if (index.getPendingOp() == 0) continue;
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), index.getIndexName());
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Dropped a pending index: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + index.getIndexName());
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName())).isEmpty()) {
            List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
            for (ExternalFile file : files) {
                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Dropped an external file: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + file.getFileNumber());
            }
        }
    }

    public static boolean isNewUniverse() {
        return isNewUniverse;
    }

    public static void setNewUniverse(boolean isNewUniverse) {
        MetadataBootstrap.isNewUniverse = isNewUniverse;
    }

    private static void ensureCatalogUpgradability(IMetadataIndex index) {
        if (index != MetadataPrimaryIndexes.SYNONYM_DATASET) {
            throw new IllegalStateException("attempt to create metadata index " + index.getIndexName() + ". Index should already exist");
        }
    }

    static {
        PRIMARY_INDEXES = new IMetadataIndex[]{MetadataPrimaryIndexes.DATAVERSE_DATASET, MetadataPrimaryIndexes.DATASET_DATASET, MetadataPrimaryIndexes.DATATYPE_DATASET, MetadataPrimaryIndexes.INDEX_DATASET, MetadataPrimaryIndexes.NODE_DATASET, MetadataPrimaryIndexes.NODEGROUP_DATASET, MetadataPrimaryIndexes.FUNCTION_DATASET, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, MetadataPrimaryIndexes.FEED_DATASET, MetadataPrimaryIndexes.FEED_POLICY_DATASET, MetadataPrimaryIndexes.LIBRARY_DATASET, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, MetadataPrimaryIndexes.SYNONYM_DATASET};
    }
}

