/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatatypeTupleTranslator
extends AbstractTupleTranslator<Datatype> {
    public static final int DATATYPE_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int DATATYPE_DATATYPE_TUPLE_FIELD_INDEX = 1;
    public static final int DATATYPE_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.DATATYPE_RECORDTYPE);
    private final MetadataNode metadataNode;
    private final JobId jobId;

    protected DatatypeTupleTranslator(JobId jobId, MetadataNode metadataNode, boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.DATATYPE_DATASET.getFieldCount());
        this.jobId = jobId;
        this.metadataNode = metadataNode;
    }

    @Override
    public Datatype getMetadataEntityFromTuple(ITupleReference frameTuple) throws MetadataException, HyracksDataException {
        byte[] serRecord = frameTuple.getFieldData(2);
        int recordStartOffset = frameTuple.getFieldStart(2);
        int recordLength = frameTuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord datatypeRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createDataTypeFromARecord(datatypeRecord);
    }

    private Datatype createDataTypeFromARecord(ARecord datatypeRecord) throws MetadataException {
        String dataverseName = ((AString)datatypeRecord.getValueByPos(0)).getStringValue();
        String datatypeName = ((AString)datatypeRecord.getValueByPos(1)).getStringValue();
        IAType type = BuiltinTypeMap.getBuiltinType(datatypeName);
        if (type == null) {
            ARecord derivedTypeRecord = (ARecord)datatypeRecord.getValueByPos(2);
            DerivedTypeTag tag = DerivedTypeTag.valueOf(((AString)derivedTypeRecord.getValueByPos(0)).getStringValue());
            boolean isAnonymous = ((ABoolean)derivedTypeRecord.getValueByPos(1)).getBoolean();
            switch (tag) {
                case RECORD: {
                    ARecord recordType = (ARecord)derivedTypeRecord.getValueByPos(2);
                    boolean isOpen = ((ABoolean)recordType.getValueByPos(0)).getBoolean();
                    int numberOfFields = ((AOrderedList)recordType.getValueByPos(1)).size();
                    IACursor cursor = ((AOrderedList)recordType.getValueByPos(1)).getCursor();
                    String[] fieldNames = new String[numberOfFields];
                    IAType[] fieldTypes = new IAType[numberOfFields];
                    int fieldId = 0;
                    while (cursor.next()) {
                        ARecord field = (ARecord)cursor.get();
                        fieldNames[fieldId] = ((AString)field.getValueByPos(0)).getStringValue();
                        String fieldTypeName = ((AString)field.getValueByPos(1)).getStringValue();
                        boolean isNullable = ((ABoolean)field.getValueByPos(2)).getBoolean();
                        fieldTypes[fieldId] = BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.jobId, dataverseName, fieldTypeName, isNullable);
                        ++fieldId;
                    }
                    return new Datatype(dataverseName, datatypeName, (IAType)new ARecordType(datatypeName, fieldNames, fieldTypes, isOpen), isAnonymous);
                }
                case UNORDEREDLIST: {
                    String unorderedlistTypeName = ((AString)derivedTypeRecord.getValueByPos(3)).getStringValue();
                    return new Datatype(dataverseName, datatypeName, (IAType)new AUnorderedListType(BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.jobId, dataverseName, unorderedlistTypeName, false), datatypeName), isAnonymous);
                }
                case ORDEREDLIST: {
                    String orderedlistTypeName = ((AString)derivedTypeRecord.getValueByPos(4)).getStringValue();
                    return new Datatype(dataverseName, datatypeName, (IAType)new AOrderedListType(BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.jobId, dataverseName, orderedlistTypeName, false), datatypeName), isAnonymous);
                }
            }
            throw new UnsupportedOperationException("Unsupported derived type: " + (Object)((Object)tag));
        }
        return new Datatype(dataverseName, datatypeName, type, false);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Datatype dataType) throws HyracksDataException, MetadataException {
        this.tupleBuilder.reset();
        this.aString.setValue(dataType.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(dataType.getDatatypeName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATATYPE_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataType.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataType.getDatatypeName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        IAType fieldType = dataType.getDatatype();
        if (fieldType.getTypeTag() == ATypeTag.UNION) {
            fieldType = ((AUnionType)dataType.getDatatype()).getActualType();
        }
        if (fieldType.getTypeTag().isDerivedType()) {
            this.fieldValue.reset();
            this.writeDerivedTypeRecord(dataType, (AbstractComplexType)fieldType, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writeDerivedTypeRecord(Datatype type, AbstractComplexType derivedDatatype, DataOutput out) throws HyracksDataException {
        DerivedTypeTag tag = null;
        RecordBuilder derivedRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        switch (derivedDatatype.getTypeTag()) {
            case ARRAY: {
                tag = DerivedTypeTag.ORDEREDLIST;
                break;
            }
            case MULTISET: {
                tag = DerivedTypeTag.UNORDEREDLIST;
                break;
            }
            case OBJECT: {
                tag = DerivedTypeTag.RECORD;
                break;
            }
            default: {
                throw new UnsupportedOperationException("No metadata record Type for " + derivedDatatype.getDisplayName());
            }
        }
        derivedRecordBuilder.reset(MetadataRecordTypes.DERIVEDTYPE_RECORDTYPE);
        fieldValue.reset();
        this.aString.setValue(tag.toString());
        this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
        derivedRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        this.booleanSerde.serialize((Object)(type.getIsAnonymous() ? ABoolean.TRUE : ABoolean.FALSE), fieldValue.getDataOutput());
        derivedRecordBuilder.addField(1, (IValueReference)fieldValue);
        switch (tag) {
            case RECORD: {
                fieldValue.reset();
                this.writeRecordType(type, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(2, (IValueReference)fieldValue);
                break;
            }
            case UNORDEREDLIST: {
                fieldValue.reset();
                this.writeCollectionType(type, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(3, (IValueReference)fieldValue);
                break;
            }
            case ORDEREDLIST: {
                fieldValue.reset();
                this.writeCollectionType(type, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(4, (IValueReference)fieldValue);
            }
        }
        derivedRecordBuilder.write(out, true);
    }

    private void writeCollectionType(Datatype instance, AbstractComplexType type, DataOutput out) throws HyracksDataException {
        AbstractCollectionType listType = (AbstractCollectionType)type;
        IAType itemType = listType.getItemType();
        if (itemType.getTypeTag().isDerivedType()) {
            this.handleNestedDerivedType(itemType.getTypeName(), (AbstractComplexType)itemType, instance, instance.getDataverseName(), instance.getDatatypeName());
        }
        this.aString.setValue(listType.getItemType().getTypeName());
        this.stringSerde.serialize((Object)this.aString, out);
    }

    private void writeRecordType(Datatype instance, AbstractComplexType type, DataOutput out) throws HyracksDataException {
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        RecordBuilder recordRecordBuilder = new RecordBuilder();
        RecordBuilder fieldRecordBuilder = new RecordBuilder();
        ARecordType recType = (ARecordType)type;
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)MetadataRecordTypes.FIELD_RECORDTYPE, null));
        IAType fieldType = null;
        for (int i = 0; i < recType.getFieldNames().length; ++i) {
            fieldType = recType.getFieldTypes()[i];
            boolean fieldIsNullable = false;
            if (NonTaggedFormatUtil.isOptional((IAType)fieldType)) {
                fieldIsNullable = true;
                fieldType = ((AUnionType)fieldType).getActualType();
            }
            if (fieldType.getTypeTag().isDerivedType()) {
                this.handleNestedDerivedType(fieldType.getTypeName(), (AbstractComplexType)fieldType, instance, instance.getDataverseName(), instance.getDatatypeName());
            }
            itemValue.reset();
            fieldRecordBuilder.reset(MetadataRecordTypes.FIELD_RECORDTYPE);
            fieldValue.reset();
            this.aString.setValue(recType.getFieldNames()[i]);
            this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
            fieldRecordBuilder.addField(0, (IValueReference)fieldValue);
            fieldValue.reset();
            this.aString.setValue(fieldType.getTypeName());
            this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
            fieldRecordBuilder.addField(1, (IValueReference)fieldValue);
            fieldValue.reset();
            this.booleanSerde.serialize((Object)(fieldIsNullable ? ABoolean.TRUE : ABoolean.FALSE), fieldValue.getDataOutput());
            fieldRecordBuilder.addField(2, (IValueReference)fieldValue);
            fieldRecordBuilder.write(itemValue.getDataOutput(), true);
            listBuilder.addItem((IValueReference)itemValue);
        }
        recordRecordBuilder.reset(MetadataRecordTypes.RECORD_RECORDTYPE);
        fieldValue.reset();
        this.booleanSerde.serialize((Object)(recType.isOpen() ? ABoolean.TRUE : ABoolean.FALSE), fieldValue.getDataOutput());
        recordRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        listBuilder.write(fieldValue.getDataOutput(), true);
        recordRecordBuilder.addField(1, (IValueReference)fieldValue);
        recordRecordBuilder.write(out, true);
    }

    private String handleNestedDerivedType(String typeName, AbstractComplexType nestedType, Datatype topLevelType, String dataverseName, String datatypeName) throws HyracksDataException {
        try {
            this.metadataNode.addDatatype(this.jobId, new Datatype(dataverseName, typeName, (IAType)nestedType, true));
        }
        catch (MetadataException e) {
            if (!(e.getCause() instanceof HyracksDataException)) {
                throw HyracksDataException.create((Throwable)e);
            }
            HyracksDataException hde = (HyracksDataException)e.getCause();
            if (!hde.getComponent().equals("HYR") || hde.getErrorCode() != 33) {
                throw hde;
            }
        }
        catch (RemoteException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return typeName;
    }

    public static enum DerivedTypeTag {
        RECORD,
        UNORDEREDLIST,
        ORDEREDLIST;

    }
}

