/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.valueextractors;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.util.string.UTF8StringReader;

public class NestedDatatypeNameValueExtractor
implements IValueExtractor<String> {
    private final String datatypeName;
    private final UTF8StringReader reader = new UTF8StringReader();

    public NestedDatatypeNameValueExtractor(String datatypeName) {
        this.datatypeName = datatypeName;
    }

    @Override
    public String getValue(JobId jobId, ITupleReference tuple) throws MetadataException, IOException {
        int recordLength;
        int recordStartOffset;
        byte[] serRecord = tuple.getFieldData(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset = tuple.getFieldStart(2), recordLength = tuple.getFieldLength(2));
        DataInputStream in = new DataInputStream(stream);
        String nestedType = this.reader.readUTF((DataInput)in);
        if (nestedType.equals(this.datatypeName)) {
            recordStartOffset = tuple.getFieldStart(1);
            recordLength = tuple.getFieldLength(1);
            stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
            in = new DataInputStream(stream);
            return this.reader.readUTF((DataInput)in);
        }
        return null;
    }
}

