/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedCollectOperatorDescriptor;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.feeds.LocationConstraint;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.PartitionConstraintHelper;
import org.apache.hyracks.api.constraints.expressions.ConstantExpression;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningWithMessageConnectorDescriptor;

public class FeedMetadataUtil {
    private static final Logger LOGGER = Logger.getLogger(FeedMetadataUtil.class.getName());

    public static Dataset validateIfDatasetExists(String dataverse, String datasetName, MetadataTransactionContext ctx) throws CompilationException {
        Dataset dataset = MetadataManager.INSTANCE.getDataset(ctx, dataverse, datasetName);
        if (dataset == null) {
            throw new CompilationException("Unknown target dataset :" + datasetName);
        }
        if (!dataset.getDatasetType().equals((Object)DatasetConfig.DatasetType.INTERNAL)) {
            throw new CompilationException("Statement not applicable. Dataset " + datasetName + " is not of required type " + DatasetConfig.DatasetType.INTERNAL);
        }
        return dataset;
    }

    public static Feed validateIfFeedExists(String dataverse, String feedName, MetadataTransactionContext ctx) throws CompilationException {
        Feed feed = MetadataManager.INSTANCE.getFeed(ctx, dataverse, feedName);
        if (feed == null) {
            throw new CompilationException("Unknown source feed: " + feedName);
        }
        return feed;
    }

    public static FeedPolicyEntity validateIfPolicyExists(String dataverse, String policyName, MetadataTransactionContext ctx) throws CompilationException {
        FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, dataverse, policyName);
        if (feedPolicy == null && (feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, "Metadata", policyName)) == null) {
            throw new CompilationException("Unknown feed policy" + policyName);
        }
        return feedPolicy;
    }

    /*
     * WARNING - void declaration
     */
    public static JobSpecification alterJobSpecificationForFeed(JobSpecification spec, FeedConnectionId feedConnectionId, Map<String, String> feedPolicyProperties) {
        IOperatorDescriptor opDesc;
        IConnectorDescriptor connDesc;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Original Job Spec:" + spec);
        }
        JobSpecification altered = new JobSpecification(spec.getFrameSize());
        Map operatorMap = spec.getOperatorMap();
        boolean preProcessingRequired = FeedMetadataUtil.preProcessingRequired(feedConnectionId);
        HashMap<OperatorDescriptorId, OperatorDescriptorId> oldNewOID = new HashMap<OperatorDescriptorId, OperatorDescriptorId>();
        for (Map.Entry entry : operatorMap.entrySet()) {
            IConnectorDescriptor connectorDesc;
            IOperatorDescriptor sourceOp;
            IPushRuntimeFactory[] runtimeFactories;
            FeedMetaOperatorDescriptor metaOp;
            String operandId = null;
            IOperatorDescriptor opDesc2 = (IOperatorDescriptor)entry.getValue();
            if (opDesc2 instanceof FeedCollectOperatorDescriptor) {
                FeedCollectOperatorDescriptor feedCollectOperatorDescriptor = (FeedCollectOperatorDescriptor)opDesc2;
                FeedCollectOperatorDescriptor fiop = new FeedCollectOperatorDescriptor(altered, feedCollectOperatorDescriptor.getFeedConnectionId(), feedCollectOperatorDescriptor.getSourceFeedId(), (ARecordType)feedCollectOperatorDescriptor.getOutputType(), feedCollectOperatorDescriptor.getRecordDescriptor(), feedCollectOperatorDescriptor.getFeedPolicyProperties(), feedCollectOperatorDescriptor.getSubscriptionLocation());
                oldNewOID.put(opDesc2.getOperatorId(), fiop.getOperatorId());
                continue;
            }
            if (opDesc2 instanceof LSMTreeInsertDeleteOperatorDescriptor && ((LSMTreeInsertDeleteOperatorDescriptor)opDesc2).isPrimary()) {
                operandId = ((LSMTreeInsertDeleteOperatorDescriptor)opDesc2).getIndexName();
                metaOp = new FeedMetaOperatorDescriptor(altered, feedConnectionId, opDesc2, feedPolicyProperties, FeedUtils.FeedRuntimeType.STORE, false, operandId);
                oldNewOID.put(opDesc2.getOperatorId(), metaOp.getOperatorId());
                continue;
            }
            OperatorDescriptorId opId = null;
            if (opDesc2 instanceof AlgebricksMetaOperatorDescriptor && (runtimeFactories = ((AlgebricksMetaOperatorDescriptor)opDesc2).getPipeline().getRuntimeFactories())[0] instanceof AssignRuntimeFactory && runtimeFactories.length > 1 && (sourceOp = spec.getProducer(connectorDesc = (IConnectorDescriptor)((List)spec.getOperatorInputMap().get(opDesc2.getOperatorId())).get(0))) instanceof FeedCollectOperatorDescriptor) {
                FeedUtils.FeedRuntimeType feedRuntimeType = FeedUtils.FeedRuntimeType.COMPUTE;
                boolean enableSubscriptionMode = preProcessingRequired;
                metaOp = new FeedMetaOperatorDescriptor(altered, feedConnectionId, opDesc2, feedPolicyProperties, feedRuntimeType, enableSubscriptionMode, operandId);
                opId = metaOp.getOperatorId();
            }
            if (opId == null) {
                opId = altered.createOperatorDescriptorId(opDesc2);
            }
            oldNewOID.put(opDesc2.getOperatorId(), opId);
        }
        HashMap connectorMapping = new HashMap();
        for (Map.Entry entry : spec.getConnectorMap().entrySet()) {
            void var12_21;
            connDesc = (IConnectorDescriptor)entry.getValue();
            if (connDesc instanceof MToNPartitioningConnectorDescriptor) {
                MToNPartitioningConnectorDescriptor m2nConn = (MToNPartitioningConnectorDescriptor)connDesc;
                connDesc = new MToNPartitioningWithMessageConnectorDescriptor((IConnectorDescriptorRegistry)altered, m2nConn.getTuplePartitionComputerFactory());
                ConnectorDescriptorId connectorDescriptorId = connDesc.getConnectorId();
            } else {
                ConnectorDescriptorId connectorDescriptorId = altered.createConnectorDescriptor(connDesc);
            }
            connectorMapping.put(entry.getKey(), var12_21);
        }
        for (Map.Entry entry : spec.getConnectorOperatorMap().entrySet()) {
            connDesc = (IConnectorDescriptor)altered.getConnectorMap().get(connectorMapping.get(entry.getKey()));
            Pair pair = (Pair)((Pair)entry.getValue()).getLeft();
            Pair rightOp = (Pair)((Pair)entry.getValue()).getRight();
            IOperatorDescriptor leftOpDesc = (IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(((IOperatorDescriptor)pair.getLeft()).getOperatorId()));
            IOperatorDescriptor rightOpDesc = (IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(((IOperatorDescriptor)rightOp.getLeft()).getOperatorId()));
            altered.connect(connDesc, leftOpDesc, ((Integer)pair.getRight()).intValue(), rightOpDesc, ((Integer)rightOp.getRight()).intValue());
        }
        HashMap hashMap = new HashMap();
        HashMap<OperatorDescriptorId, Integer> operatorCounts = new HashMap<OperatorDescriptorId, Integer>();
        for (Constraint constraint : spec.getUserConstraints()) {
            LValueConstraintExpression lexpr = constraint.getLValue();
            ConstraintExpression cexpr = constraint.getRValue();
            switch (lexpr.getTag()) {
                case PARTITION_COUNT: {
                    OperatorDescriptorId opId = ((PartitionCountExpression)lexpr).getOperatorDescriptorId();
                    operatorCounts.put(opId, (Integer)((ConstantExpression)cexpr).getValue());
                    break;
                }
                case PARTITION_LOCATION: {
                    OperatorDescriptorId opId = ((PartitionLocationExpression)lexpr).getOperatorDescriptorId();
                    IOperatorDescriptor opDesc3 = (IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(opId));
                    ArrayList<LocationConstraint> locations = (ArrayList<LocationConstraint>)hashMap.get(opDesc3.getOperatorId());
                    if (locations == null) {
                        locations = new ArrayList<LocationConstraint>();
                        hashMap.put(opDesc3.getOperatorId(), locations);
                    }
                    String location = (String)((ConstantExpression)cexpr).getValue();
                    LocationConstraint lc = new LocationConstraint(location, ((PartitionLocationExpression)lexpr).getPartition());
                    locations.add(lc);
                    break;
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            opDesc = (IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(entry.getKey()));
            Collections.sort((List)entry.getValue(), (o1, o2) -> o1.partition - o2.partition);
            String[] locations = new String[((List)entry.getValue()).size()];
            for (int i = 0; i < locations.length; ++i) {
                locations[i] = ((LocationConstraint)((List)entry.getValue()).get((int)i)).location;
            }
            PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)altered, (IOperatorDescriptor)opDesc, (String[])locations);
        }
        for (Map.Entry entry : operatorCounts.entrySet()) {
            opDesc = (IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(entry.getKey()));
            if (hashMap.keySet().contains(entry.getKey())) continue;
            PartitionConstraintHelper.addPartitionCountConstraint((JobSpecification)altered, (IOperatorDescriptor)opDesc, (int)((Integer)entry.getValue()));
        }
        altered.setUseConnectorPolicyForScheduling(spec.isUseConnectorPolicyForScheduling());
        altered.setConnectorPolicyAssignmentPolicy(spec.getConnectorPolicyAssignmentPolicy());
        for (OperatorDescriptorId operatorDescriptorId : spec.getRoots()) {
            altered.addRoot((IOperatorDescriptor)altered.getOperatorMap().get(oldNewOID.get(operatorDescriptorId)));
        }
        altered.setJobletEventListenerFactory(spec.getJobletEventListenerFactory());
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("New Job Spec:" + altered);
        }
        return altered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean preProcessingRequired(FeedConnectionId connectionId) {
        boolean preProcessingRequired;
        block7: {
            MetadataTransactionContext ctx = null;
            Feed feed = null;
            preProcessingRequired = false;
            try {
                MetadataManager.INSTANCE.acquireReadLatch();
                ctx = MetadataManager.INSTANCE.beginTransaction();
                feed = MetadataManager.INSTANCE.getFeed(ctx, connectionId.getFeedId().getDataverse(), connectionId.getFeedId().getEntityName());
                preProcessingRequired = feed.getAppliedFunction() != null;
                MetadataManager.INSTANCE.commitTransaction(ctx);
            }
            catch (Exception e) {
                if (ctx == null) break block7;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (Exception abortException) {
                    e.addSuppressed(abortException);
                    throw new IllegalStateException(e);
                }
            }
            finally {
                MetadataManager.INSTANCE.releaseReadLatch();
            }
        }
        return preProcessingRequired;
    }

    public static void validateFeed(Feed feed, MetadataTransactionContext mdTxnCtx, ILibraryManager libraryManager) throws AsterixException {
        try {
            String adapterName = feed.getAdapterName();
            Map<String, String> configuration = feed.getAdapterConfiguration();
            ARecordType adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration, "type-name");
            ARecordType metaType = FeedMetadataUtil.getOutputType(feed, configuration, "meta-type-name");
            ExternalDataUtils.prepareFeed(configuration, (String)feed.getDataverseName(), (String)feed.getFeedName());
            ExternalDataUtils.prepareFeed(configuration, (String)feed.getDataverseName(), (String)feed.getFeedName());
            DatasourceAdapter adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                IAdapterFactory adapterFactory;
                IDataSourceAdapter.AdapterType adapterType = adapterEntity.getType();
                String adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        String[] anameComponents = adapterName.split("#");
                        String libraryName = anameComponents[0];
                        ClassLoader cl = libraryManager.getLibraryClassLoader(feed.getDataverseName(), libraryName);
                        adapterFactory = (IAdapterFactory)cl.loadClass(adapterFactoryClassname).newInstance();
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
                adapterFactory.setOutputType(adapterOutputType);
                adapterFactory.setMetaType(metaType);
                adapterFactory.configure(null, configuration);
            } else {
                AdapterFactoryProvider.getAdapterFactory((ILibraryManager)libraryManager, (String)adapterName, configuration, (ARecordType)adapterOutputType, (ARecordType)metaType);
            }
            if (metaType == null && configuration.containsKey("meta-type-name") && (metaType = FeedMetadataUtil.getOutputType(feed, configuration, "meta-type-name")) == null) {
                throw new AsterixException("Unknown specified feed meta output data type " + configuration.get("meta-type-name"));
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration, "type-name");
                if (adapterOutputType == null) {
                    throw new AsterixException("Unknown specified feed output data type " + configuration.get("type-name"));
                }
            }
        }
        catch (Exception e) {
            throw new AsterixException("Invalid feed parameters", (Throwable)e);
        }
    }

    public static Triple<IAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> getPrimaryFeedFactoryAndOutput(Feed feed, FeedPolicyAccessor policyAccessor, MetadataTransactionContext mdTxnCtx, ILibraryManager libraryManager) throws AlgebricksException {
        String adapterName = null;
        DatasourceAdapter adapterEntity = null;
        String adapterFactoryClassname = null;
        IAdapterFactory adapterFactory = null;
        ARecordType adapterOutputType = null;
        ARecordType metaType = null;
        Triple feedProps = null;
        IDataSourceAdapter.AdapterType adapterType = null;
        try {
            adapterName = feed.getAdapterName();
            Map<String, String> configuration = feed.getAdapterConfiguration();
            configuration.putAll(policyAccessor.getFeedPolicy());
            adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration, "type-name");
            metaType = FeedMetadataUtil.getOutputType(feed, configuration, "meta-type-name");
            ExternalDataUtils.prepareFeed(configuration, (String)feed.getDataverseName(), (String)feed.getFeedName());
            adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                adapterType = adapterEntity.getType();
                adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        String[] anameComponents = adapterName.split("#");
                        String libraryName = anameComponents[0];
                        ClassLoader cl = libraryManager.getLibraryClassLoader(feed.getDataverseName(), libraryName);
                        adapterFactory = (IAdapterFactory)cl.loadClass(adapterFactoryClassname).newInstance();
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
                adapterFactory.setOutputType(adapterOutputType);
                adapterFactory.setMetaType(metaType);
                adapterFactory.configure(null, configuration);
            } else {
                adapterFactory = AdapterFactoryProvider.getAdapterFactory((ILibraryManager)libraryManager, (String)adapterName, configuration, (ARecordType)adapterOutputType, (ARecordType)metaType);
                adapterType = IDataSourceAdapter.AdapterType.INTERNAL;
            }
            if (metaType == null) {
                metaType = FeedMetadataUtil.getOutputType(feed, configuration, "meta-type-name");
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration, "type-name");
            }
            int numOfOutputs = 1;
            if (metaType != null) {
                ++numOfOutputs;
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                numOfOutputs += ExternalDataUtils.getNumberOfKeys(configuration);
            }
            ISerializerDeserializer[] serdes = new ISerializerDeserializer[numOfOutputs];
            int i = 0;
            serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType);
            if (metaType != null) {
                serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType);
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                FeedMetadataUtil.getSerdesForPKs(serdes, configuration, metaType, adapterOutputType, i);
            }
            feedProps = new Triple((Object)adapterFactory, (Object)new RecordDescriptor(serdes), (Object)adapterType);
        }
        catch (Exception e) {
            throw new AlgebricksException("unable to create adapter", (Throwable)e);
        }
        return feedProps;
    }

    private static void getSerdesForPKs(ISerializerDeserializer[] serdes, Map<String, String> configuration, ARecordType metaType, ARecordType adapterOutputType, int index) throws AlgebricksException {
        int[] pkIndexes = ExternalDataUtils.getPKIndexes(configuration);
        if (metaType != null) {
            int[] pkIndicators = ExternalDataUtils.getPKSourceIndicators(configuration);
            for (int j = 0; j < pkIndexes.length; ++j) {
                int aInt = pkIndexes[j];
                if (pkIndicators[j] == 0) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
                    continue;
                }
                if (pkIndicators[j] == 1) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType.getFieldTypes()[aInt]);
                    continue;
                }
                throw new AlgebricksException("a key source indicator can only be 0 or 1");
            }
        } else {
            for (int aInt : pkIndexes) {
                serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ARecordType getOutputType(IFeed feed, Map<String, String> configuration, String key) throws RemoteException, ACIDException, MetadataException {
        ARecordType outputType;
        block13: {
            String dataverseName;
            String datatypeName;
            outputType = null;
            String fqOutputType = configuration.get(key);
            if (fqOutputType == null) {
                return null;
            }
            String[] dataverseAndType = fqOutputType.split("[.]");
            if (dataverseAndType.length == 1) {
                datatypeName = dataverseAndType[0];
                dataverseName = feed.getDataverseName();
            } else if (dataverseAndType.length == 2) {
                dataverseName = dataverseAndType[0];
                datatypeName = dataverseAndType[1];
            } else {
                throw new IllegalArgumentException("Invalid value for the parameter " + key);
            }
            MetadataTransactionContext ctx = null;
            MetadataManager.INSTANCE.acquireReadLatch();
            try {
                ctx = MetadataManager.INSTANCE.beginTransaction();
                Datatype t = MetadataManager.INSTANCE.getDatatype(ctx, dataverseName, datatypeName);
                IAType type = t.getDatatype();
                if (type.getTypeTag() != ATypeTag.RECORD) {
                    throw new IllegalStateException();
                }
                outputType = (ARecordType)t.getDatatype();
                MetadataManager.INSTANCE.commitTransaction(ctx);
            }
            catch (RemoteException | ACIDException | MetadataException e) {
                if (ctx == null) break block13;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (RemoteException | ACIDException e2) {
                    ((Throwable)e).addSuppressed(e2);
                }
                throw e;
            }
            finally {
                MetadataManager.INSTANCE.releaseReadLatch();
            }
        }
        return outputType;
    }

    public static String getSecondaryFeedOutput(Feed feed, FeedPolicyAccessor policyAccessor, MetadataTransactionContext mdTxnCtx) throws AlgebricksException, MetadataException, RemoteException, ACIDException {
        String outputType = null;
        String primaryFeedName = feed.getSourceFeedName();
        Feed primaryFeed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, feed.getDataverseName(), primaryFeedName);
        FunctionSignature appliedFunction = primaryFeed.getAppliedFunction();
        if (appliedFunction == null) {
            outputType = FeedMetadataUtil.getOutputType(feed, feed.getAdapterConfiguration(), "type-name").getDisplayName();
        } else {
            Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, appliedFunction);
            if (function != null) {
                if (function.getLanguage().equals("AQL")) {
                    throw new NotImplementedException("Secondary feeds derived from a source feed that has an applied AQL function are not supported yet.");
                }
                outputType = function.getReturnType();
            } else {
                throw new IllegalArgumentException("Function " + appliedFunction + " associated with source feed not found in Metadata.");
            }
        }
        return outputType;
    }
}

