/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.HashMap;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;

public class BuiltinFeedPolicies {
    public static final FeedPolicyEntity BRITTLE = BuiltinFeedPolicies.initializeBrittlePolicy();
    public static final FeedPolicyEntity BASIC = BuiltinFeedPolicies.initializeBasicPolicy();
    public static final FeedPolicyEntity BASIC_FT = BuiltinFeedPolicies.initializeBasicFTPolicy();
    public static final FeedPolicyEntity ADVANCED_FT = BuiltinFeedPolicies.initializeAdvancedFTPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_DISCARD = BuiltinFeedPolicies.initializeAdvancedFTDiscardPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_SPILL = BuiltinFeedPolicies.initializeAdvancedFTSpillPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_THROTTLE = BuiltinFeedPolicies.initializeAdvancedFTThrottlePolicy();
    public static final FeedPolicyEntity ELASTIC = BuiltinFeedPolicies.initializeAdvancedFTElasticPolicy();
    public static final FeedPolicyEntity[] policies = new FeedPolicyEntity[]{BRITTLE, BASIC, BASIC_FT, ADVANCED_FT, ADVANCED_FT_DISCARD, ADVANCED_FT_SPILL, ADVANCED_FT_THROTTLE, ELASTIC};
    public static final FeedPolicyEntity DEFAULT_POLICY = BASIC_FT;
    public static final String CONFIG_FEED_POLICY_KEY = "policy";

    public static FeedPolicyEntity getFeedPolicy(String policyName) {
        for (FeedPolicyEntity policy : policies) {
            if (!policy.getPolicyName().equalsIgnoreCase(policyName)) continue;
            return policy;
        }
        return null;
    }

    private static FeedPolicyEntity initializeBrittlePolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "false");
        policyParams.put("soft.failure.log.data", "false");
        policyParams.put("hardware.failure.continue", "false");
        policyParams.put("cluster.reboot.auto.restart", "false");
        policyParams.put("elastic", "false");
        policyParams.put("time.tracking", "false");
        policyParams.put("atleast.once.semantics", "false");
        String description = "Brittle";
        return new FeedPolicyEntity("Metadata", "Brittle", description, policyParams);
    }

    private static FeedPolicyEntity initializeBasicPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "false");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("time.tracking", "false");
        policyParams.put("atleast.once.semantics", "false");
        String description = "Basic";
        return new FeedPolicyEntity("Metadata", "Basic", description, policyParams);
    }

    private static FeedPolicyEntity initializeBasicFTPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "false");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("spill.to.disk.on.congestion", "false");
        policyParams.put("max.fraction.discard", "1");
        policyParams.put("time.tracking", "false");
        policyParams.put("atleast.once.semantics", "false");
        policyParams.put("throttling.enabled", "false");
        String description = "Basic Monitored Fault-Tolerant";
        return new FeedPolicyEntity("Metadata", "BasicFT", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("time.tracking", "true");
        policyParams.put("atleast.once.semantics", "true");
        String description = "Basic Monitored Fault-Tolerant with at least once semantics";
        return new FeedPolicyEntity("Metadata", "AdvancedFT", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTDiscardPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("max.spill.size.on.disk", "false");
        policyParams.put("max.fraction.discard", "100");
        policyParams.put("time.tracking", "false");
        policyParams.put("logging.statistics", "true");
        String description = "AdvancedFT 100% Discard during congestion";
        return new FeedPolicyEntity("Metadata", "AdvancedFT_Discard", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTSpillPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("spill.to.disk.on.congestion", "" + Boolean.TRUE);
        policyParams.put("max.spill.size.on.disk", "-1");
        policyParams.put("time.tracking", "true");
        String description = "AdvancedFT 100% Discard during congestion";
        return new FeedPolicyEntity("Metadata", "AdvancedFT_Spill", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTThrottlePolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "false");
        policyParams.put("spill.to.disk.on.congestion", "" + Boolean.FALSE);
        policyParams.put("max.fraction.discard", "0");
        policyParams.put("time.tracking", "false");
        policyParams.put("throttling.enabled", "true");
        String description = "AdvancedFT Throttle during congestion";
        return new FeedPolicyEntity("Metadata", "AdvancedFT_Throttle", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTElasticPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("soft.failure.continue", "true");
        policyParams.put("soft.failure.log.data", "true");
        policyParams.put("hardware.failure.continue", "true");
        policyParams.put("cluster.reboot.auto.restart", "true");
        policyParams.put("elastic", "true");
        policyParams.put("time.tracking", "false");
        policyParams.put("logging.statistics", "true");
        String description = "Basic Monitored Fault-Tolerant Elastic";
        return new FeedPolicyEntity("Metadata", "AdvancedFT_Elastic", description, policyParams);
    }
}

