/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedTupleTranslator
extends AbstractTupleTranslator<Feed> {
    public static final int FEED_DATAVERSE_NAME_FIELD_INDEX = 0;
    public static final int FEED_NAME_FIELD_INDEX = 1;
    public static final int FEED_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.FEED_RECORDTYPE);

    protected FeedTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FEED_DATASET.getFieldCount());
    }

    @Override
    public Feed getMetadataEntityFromTuple(ITupleReference frameTuple) throws IOException {
        byte[] serRecord = frameTuple.getFieldData(2);
        int recordStartOffset = frameTuple.getFieldStart(2);
        int recordLength = frameTuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord feedRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createFeedFromARecord(feedRecord);
    }

    private Feed createFeedFromARecord(ARecord feedRecord) {
        Feed feed = null;
        String dataverseName = ((AString)feedRecord.getValueByPos(0)).getStringValue();
        String feedName = ((AString)feedRecord.getValueByPos(1)).getStringValue();
        IAObject o = feedRecord.getValueByPos(2);
        FunctionSignature signature = null;
        if (!(o instanceof ANull) && !(o instanceof AMissing)) {
            String functionName = ((AString)o).getStringValue();
            signature = new FunctionSignature(dataverseName, functionName, 1);
        }
        String feedType = ((AString)feedRecord.getValueByPos(3)).getStringValue();
        IFeed.FeedType feedTypeEnum = IFeed.FeedType.valueOf((String)feedType.toUpperCase());
        switch (feedTypeEnum) {
            case PRIMARY: {
                ARecord feedTypeDetailsRecord = (ARecord)feedRecord.getValueByPos(4);
                String adapterName = ((AString)feedTypeDetailsRecord.getValueByPos(0)).getStringValue();
                IACursor cursor = ((AUnorderedList)feedTypeDetailsRecord.getValueByPos(1)).getCursor();
                HashMap<String, String> adaptorConfiguration = new HashMap<String, String>();
                while (cursor.next()) {
                    ARecord field = (ARecord)cursor.get();
                    String key = ((AString)field.getValueByPos(0)).getStringValue();
                    String value = ((AString)field.getValueByPos(1)).getStringValue();
                    adaptorConfiguration.put(key, value);
                }
                feed = new Feed(dataverseName, feedName, signature, IFeed.FeedType.PRIMARY, feedName, adapterName, adaptorConfiguration);
                break;
            }
            case SECONDARY: {
                ARecord feedTypeDetailsRecord = (ARecord)feedRecord.getValueByPos(5);
                String sourceFeedName = ((AString)feedTypeDetailsRecord.getValueByPos(0)).getStringValue();
                feed = new Feed(dataverseName, feedName, signature, IFeed.FeedType.SECONDARY, sourceFeedName, null, null);
            }
        }
        return feed;
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Feed feed) throws IOException, MetadataException {
        this.tupleBuilder.reset();
        this.aString.setValue(feed.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feed.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FEED_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(feed.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feed.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        if (feed.getAppliedFunction() != null) {
            this.aString.setValue(feed.getAppliedFunction().getName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(feed.getFeedType().name().toUpperCase());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeFeedTypeDetailsRecordType(this.recordBuilder, feed, this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writeFeedTypeDetailsRecordType(IARecordBuilder recordBuilder, Feed feed, ArrayBackedValueStorage fieldValue) throws HyracksDataException {
        switch (feed.getFeedType()) {
            case PRIMARY: {
                RecordBuilder primaryDetailsRecordBuilder = new RecordBuilder();
                OrderedListBuilder listBuilder = new OrderedListBuilder();
                ArrayBackedValueStorage primaryRecordfieldValue = new ArrayBackedValueStorage();
                ArrayBackedValueStorage primaryRecordItemValue = new ArrayBackedValueStorage();
                primaryDetailsRecordBuilder.reset(MetadataRecordTypes.PRIMARY_FEED_DETAILS_RECORDTYPE);
                AMutableString aString = new AMutableString("");
                ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
                fieldValue.reset();
                aString.setValue(feed.getAdapterName());
                stringSerde.serialize((Object)aString, primaryRecordfieldValue.getDataOutput());
                primaryDetailsRecordBuilder.addField(0, (IValueReference)primaryRecordfieldValue);
                listBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.PRIMARY_FEED_DETAILS_RECORDTYPE.getFieldTypes()[1]));
                for (Map.Entry<String, String> property : feed.getAdapterConfiguration().entrySet()) {
                    String name = property.getKey();
                    String value = property.getValue();
                    primaryRecordItemValue.reset();
                    this.writePropertyTypeRecord(name, value, primaryRecordItemValue.getDataOutput());
                    listBuilder.addItem((IValueReference)primaryRecordItemValue);
                }
                primaryRecordfieldValue.reset();
                listBuilder.write(primaryRecordfieldValue.getDataOutput(), true);
                primaryDetailsRecordBuilder.addField(1, (IValueReference)primaryRecordfieldValue);
                primaryDetailsRecordBuilder.write(fieldValue.getDataOutput(), true);
                recordBuilder.addField(4, (IValueReference)fieldValue);
                break;
            }
            case SECONDARY: {
                RecordBuilder secondaryDetailsRecordBuilder = new RecordBuilder();
                ArrayBackedValueStorage secondaryFieldValue = new ArrayBackedValueStorage();
                secondaryDetailsRecordBuilder.reset(MetadataRecordTypes.SECONDARY_FEED_DETAILS_RECORDTYPE);
                fieldValue.reset();
                this.aString.setValue(feed.getSourceFeedName());
                this.stringSerde.serialize((Object)this.aString, secondaryFieldValue.getDataOutput());
                secondaryDetailsRecordBuilder.addField(0, (IValueReference)secondaryFieldValue);
                secondaryDetailsRecordBuilder.write(fieldValue.getDataOutput(), true);
                recordBuilder.addField(5, (IValueReference)fieldValue);
            }
        }
    }

    public void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.FEED_ADAPTER_CONFIGURATION_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

