/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.DataOutput;
import java.util.Date;
import java.util.Map;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ExternalDatasetDetails
implements IDatasetDetails {
    private static final long serialVersionUID = 1L;
    private final String adapter;
    private final Map<String, String> properties;
    private final long addToCacheTime;
    private Date lastRefreshTime;
    private DatasetConfig.ExternalDatasetTransactionState state;

    public ExternalDatasetDetails(String adapter, Map<String, String> properties, Date lastRefreshTime, DatasetConfig.ExternalDatasetTransactionState state) {
        this.properties = properties;
        this.adapter = adapter;
        this.addToCacheTime = System.currentTimeMillis();
        this.lastRefreshTime = lastRefreshTime;
        this.state = state;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public DatasetConfig.DatasetType getDatasetType() {
        return DatasetConfig.DatasetType.EXTERNAL;
    }

    @Override
    public void writeDatasetDetailsRecordType(DataOutput out) throws HyracksDataException {
        RecordBuilder externalRecordBuilder = new RecordBuilder();
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        externalRecordBuilder.reset(MetadataRecordTypes.EXTERNAL_DETAILS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
        ISerializerDeserializer intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        fieldValue.reset();
        aString.setValue(this.getAdapter());
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        externalRecordBuilder.addField(0, (IValueReference)fieldValue);
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.EXTERNAL_DETAILS_RECORDTYPE.getFieldTypes()[1]));
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            itemValue.reset();
            DatasetUtils.writePropertyTypeRecord(name, value, itemValue.getDataOutput(), MetadataRecordTypes.DATASOURCE_ADAPTER_PROPERTIES_RECORDTYPE);
            listBuilder.addItem((IValueReference)itemValue);
        }
        fieldValue.reset();
        listBuilder.write(fieldValue.getDataOutput(), true);
        externalRecordBuilder.addField(1, (IValueReference)fieldValue);
        fieldValue.reset();
        dateTimeSerde.serialize((Object)new ADateTime(this.lastRefreshTime.getTime()), fieldValue.getDataOutput());
        externalRecordBuilder.addField(2, (IValueReference)fieldValue);
        fieldValue.reset();
        intSerde.serialize((Object)new AInt32(this.state.ordinal()), fieldValue.getDataOutput());
        externalRecordBuilder.addField(3, (IValueReference)fieldValue);
        externalRecordBuilder.write(out, true);
    }

    @Override
    public boolean isTemp() {
        return false;
    }

    @Override
    public long getLastAccessTime() {
        return this.addToCacheTime;
    }

    public Date getTimestamp() {
        return this.lastRefreshTime;
    }

    public void setRefreshTimestamp(Date timestamp) {
        this.lastRefreshTime = timestamp;
    }

    public DatasetConfig.ExternalDatasetTransactionState getState() {
        return this.state;
    }

    public void setState(DatasetConfig.ExternalDatasetTransactionState state) {
        this.state = state;
    }
}

