/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.dataflow.IApplicationContextInfo;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.dataflow.LSMInvertedIndexInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeWithBuddyIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMInvertedIndexIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMRTreeIOOperationCallbackFactory;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.dataflow.data.nontagged.valueproviders.AqlPrimitiveValueProviderFactory;
import org.apache.asterix.external.adapter.factory.LookupAdapterFactory;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalBTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalDataScanOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalLookupOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalRTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.LinearizeComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.declared.FileSplitDataSink;
import org.apache.asterix.metadata.declared.FileSplitSinkId;
import org.apache.asterix.metadata.declared.MetadataManagerUtil;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.metadata.utils.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.SplitsAndConstraintsUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.NonTaggedFormatUtil;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.operators.LSMInvertedIndexUpsertOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMTreeUpsertOperatorDescriptor;
import org.apache.asterix.runtime.util.AppContextInfo;
import org.apache.asterix.runtime.util.ClusterStateManager;
import org.apache.asterix.runtime.util.RuntimeComponentsProvider;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerProvider;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerProvider;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetPrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetSecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.UpsertOperationCallbackFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntimeFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeWithBuddyDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.PartitionedLSMInvertedIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.ExternalRTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.LSMRTreeWithAntiMatterTuplesDataflowHelperFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IStorageManagerInterface;

public class MetadataProvider
implements IMetadataProvider<DataSourceId, String> {
    private final StorageProperties storageProperties;
    private final ILibraryManager libraryManager;
    private final Dataverse defaultDataverse;
    private MetadataTransactionContext mdTxnCtx;
    private boolean isWriteTransaction;
    private Map<String, String> config;
    private IAWriterFactory writerFactory;
    private FileSplit outputFile;
    private boolean asyncResults;
    private ResultSetId resultSetId;
    private IResultSerializerFactoryProvider resultSerializerFactoryProvider;
    private JobId jobId;
    private Map<String, Integer> locks;
    private boolean isTemporaryDatasetWriteJob = true;

    public MetadataProvider(Dataverse defaultDataverse) {
        this.defaultDataverse = defaultDataverse;
        this.storageProperties = AppContextInfo.INSTANCE.getStorageProperties();
        this.libraryManager = AppContextInfo.INSTANCE.getLibraryManager();
    }

    public String getPropertyValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public Dataverse getDefaultDataverse() {
        return this.defaultDataverse;
    }

    public String getDefaultDataverseName() {
        return this.defaultDataverse == null ? null : this.defaultDataverse.getDataverseName();
    }

    public void setWriteTransaction(boolean writeTransaction) {
        this.isWriteTransaction = writeTransaction;
    }

    public void setWriterFactory(IAWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void setMetadataTxnContext(MetadataTransactionContext mdTxnCtx) {
        this.mdTxnCtx = mdTxnCtx;
    }

    public MetadataTransactionContext getMetadataTxnContext() {
        return this.mdTxnCtx;
    }

    public IAWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getResultAsyncMode() {
        return this.asyncResults;
    }

    public void setResultAsyncMode(boolean asyncResults) {
        this.asyncResults = asyncResults;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(ResultSetId resultSetId) {
        this.resultSetId = resultSetId;
    }

    public void setResultSerializerFactoryProvider(IResultSerializerFactoryProvider rafp) {
        this.resultSerializerFactoryProvider = rafp;
    }

    public IResultSerializerFactoryProvider getResultSerializerFactoryProvider() {
        return this.resultSerializerFactoryProvider;
    }

    public boolean isWriteTransaction() {
        return this.isWriteTransaction;
    }

    public boolean isTemporaryDatasetWriteJob() {
        return this.isTemporaryDatasetWriteJob;
    }

    public IDataFormat getFormat() {
        return FormatUtils.getDefaultFormat();
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public Map<String, Integer> getLocks() {
        return this.locks;
    }

    public void setLocks(Map<String, Integer> locks) {
        this.locks = locks;
    }

    public ARecordType findOutputRecordType() throws AlgebricksException {
        return MetadataManagerUtil.findOutputRecordType(this.mdTxnCtx, this.getDefaultDataverseName(), this.getPropertyValue("output-record-type"));
    }

    public Dataset findDataset(String dataverse, String dataset) throws AlgebricksException {
        String dv;
        Object object = dataverse == null ? (this.defaultDataverse == null ? null : this.defaultDataverse.getDataverseName()) : (dv = dataverse);
        if (dv == null) {
            return null;
        }
        return MetadataManagerUtil.findDataset(this.mdTxnCtx, dv, dataset);
    }

    public INodeDomain findNodeDomain(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodeDomain(this.mdTxnCtx, nodeGroupName);
    }

    public IAType findType(String dataverse, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findType(this.mdTxnCtx, dataverse, typeName);
    }

    public Feed findFeed(String dataverse, String feedName) throws AlgebricksException {
        return MetadataManagerUtil.findFeed(this.mdTxnCtx, dataverse, feedName);
    }

    public FeedPolicyEntity findFeedPolicy(String dataverse, String policyName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedPolicy(this.mdTxnCtx, dataverse, policyName);
    }

    public DataSource findDataSource(DataSourceId id) throws AlgebricksException {
        return MetadataManagerUtil.findDataSource(this.mdTxnCtx, id);
    }

    public DataSource lookupSourceInMetadata(DataSourceId aqlId) throws AlgebricksException {
        return MetadataManagerUtil.lookupSourceInMetadata(this.mdTxnCtx, aqlId);
    }

    public IDataSourceIndex<String, DataSourceId> findDataSourceIndex(String indexId, DataSourceId dataSourceId) throws AlgebricksException {
        DataSource source = this.findDataSource(dataSourceId);
        Dataset dataset = ((DatasetDataSource)source).getDataset();
        try {
            String indexName = indexId;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex != null) {
                return new DataSourceIndex(secondaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this);
            }
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            if (primaryIndex.getIndexName().equals(indexId)) {
                return new DataSourceIndex(primaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this);
            }
            return null;
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public List<Index> getDatasetIndexes(String dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.getDatasetIndexes(this.mdTxnCtx, dataverseName, datasetName);
    }

    public IFunctionInfo lookupFunction(FunctionIdentifier fid) {
        return BuiltinFunctions.lookupFunction((FunctionIdentifier)fid);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        try {
            return ((DataSource)dataSource).buildDatasourceScanRuntime(this, dataSource, scanVariables, projectVariables, projectPushed, minFilterVars, maxFilterVars, opSchema, typeEnv, context, jobSpec, implConfig);
        }
        catch (AsterixException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public static AlgebricksAbsolutePartitionConstraint determineLocationConstraint(FeedDataSource feedDataSource) {
        return new AlgebricksAbsolutePartitionConstraint(feedDataSource.getLocations());
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildLoadableDatasetScan(JobSpecification jobSpec, IAdapterFactory adapterFactory, RecordDescriptor rDesc) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        ExternalDataScanOperatorDescriptor dataScanner = new ExternalDataScanOperatorDescriptor(jobSpec, rDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    public IDataFormat getDataFormat(String dataverseName) throws CompilationException {
        IDataFormat format;
        Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, dataverseName);
        try {
            format = (IDataFormat)Class.forName(dataverse.getDataFormat()).newInstance();
        }
        catch (Exception e) {
            throw new CompilationException((Throwable)e);
        }
        return format;
    }

    public Dataverse findDataverse(String dataverseName) throws CompilationException {
        return MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, dataverseName);
    }

    public Triple<IOperatorDescriptor, AlgebricksPartitionConstraint, IAdapterFactory> buildFeedIntakeRuntime(JobSpecification jobSpec, Feed primaryFeed, FeedPolicyAccessor policyAccessor) throws Exception {
        Triple<IAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> factoryOutput = FeedMetadataUtil.getPrimaryFeedFactoryAndOutput(primaryFeed, policyAccessor, this.mdTxnCtx, this.libraryManager);
        ARecordType recordType = FeedMetadataUtil.getOutputType(primaryFeed, primaryFeed.getAdapterConfiguration(), "type-name");
        IAdapterFactory adapterFactory = (IAdapterFactory)factoryOutput.first;
        FeedIntakeOperatorDescriptor feedIngestor = null;
        switch ((IDataSourceAdapter.AdapterType)factoryOutput.third) {
            case INTERNAL: {
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)primaryFeed, adapterFactory, recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
            case EXTERNAL: {
                String libraryName = primaryFeed.getAdapterName().trim().split("#")[0];
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)primaryFeed, libraryName, adapterFactory.getClass().getName(), recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
            }
        }
        AlgebricksAbsolutePartitionConstraint partitionConstraint = adapterFactory.getPartitionConstraint();
        return new Triple(feedIngestor, (Object)partitionConstraint, (Object)adapterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildBtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, Object implConfig, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        boolean isSecondary = true;
        int numSecondaryKeys = 0;
        try {
            ExternalBTreeSearchOperatorDescriptor btreeSearchOp;
            NoOpOperationCallbackFactory searchCallbackFactory;
            ITypeTraits[] typeTraits;
            IBinaryComparatorFactory[] comparatorFactories;
            int[] bloomFilterKeyFields;
            boolean temp = dataset.getDatasetDetails().isTemp();
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            if (primaryIndex != null && dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                isSecondary = !indexName.equals(primaryIndex.getIndexName());
            }
            int numPrimaryKeys = DatasetUtils.getPartitioningKeys(dataset).size();
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            ARecordType itemType = (ARecordType)this.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
            ARecordType metaType = null;
            List<Integer> primaryKeyIndicators = null;
            if (dataset.hasMetaPart()) {
                metaType = (ARecordType)this.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
                primaryKeyIndicators = ((InternalDatasetDetails)dataset.getDatasetDetails()).getKeySourceIndicator();
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] btreeFields = null;
            if (isSecondary) {
                Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
                numSecondaryKeys = secondaryIndex.getKeyFieldNames().size();
                bloomFilterKeyFields = new int[numSecondaryKeys];
                for (int i = 0; i < numSecondaryKeys; ++i) {
                    bloomFilterKeyFields[i] = i;
                }
                Pair<IBinaryComparatorFactory[], ITypeTraits[]> comparatorFactoriesAndTypeTraits = this.getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(secondaryIndex.getKeyFieldNames(), secondaryIndex.getKeyFieldTypes(), DatasetUtils.getPartitioningKeys(dataset), itemType, dataset.getDatasetType(), dataset.hasMetaPart(), primaryKeyIndicators, secondaryIndex.getKeyFieldSourceIndicators(), metaType);
                comparatorFactories = (IBinaryComparatorFactory[])comparatorFactoriesAndTypeTraits.first;
                typeTraits = (ITypeTraits[])comparatorFactoriesAndTypeTraits.second;
                if (filterTypeTraits != null) {
                    filterFields = new int[]{numSecondaryKeys + numPrimaryKeys};
                    btreeFields = new int[numSecondaryKeys + numPrimaryKeys];
                    for (int k = 0; k < btreeFields.length; ++k) {
                        btreeFields[k] = k;
                    }
                }
            } else {
                bloomFilterKeyFields = new int[numPrimaryKeys];
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    bloomFilterKeyFields[i] = i;
                }
                ARecordType metaItemType = DatasetUtils.getMetaType(this, dataset);
                typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType, metaItemType);
                comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, metaItemType, context.getBinaryComparatorFactoryProvider());
                filterFields = DatasetUtils.createFilterFields(dataset);
                btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            }
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.splitProviderAndPartitionConstraintsForDataset(dataset.getDataverseName(), dataset.getDatasetName(), indexName, temp);
            if (isSecondary) {
                searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new SecondaryIndexSearchOperationCallbackFactory();
            } else {
                JobId jobId = ((JobEventListenerFactory)jobSpec.getJobletEventListenerFactory()).getJobId();
                int datasetId = dataset.getDatasetId();
                int[] primaryKeyFields = new int[numPrimaryKeys];
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    primaryKeyFields[i] = i;
                }
                TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
                searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new PrimaryIndexInstantSearchOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
            }
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            RuntimeComponentsProvider rtcProvider = RuntimeComponentsProvider.RUNTIME_PROVIDER;
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                btreeSearchOp = new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, bloomFilterKeyFields, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)(isSecondary ? new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()) : new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId())), (ILSMIOOperationSchedulerProvider)rtcProvider, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), !isSecondary, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp), retainInput, retainMissing, context.getMissingWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                int[] buddyBreeFields = new int[]{numSecondaryKeys};
                ExternalBTreeWithBuddyDataflowHelperFactory indexDataflowHelperFactory = new ExternalBTreeWithBuddyDataflowHelperFactory((ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeWithBuddyIOOperationCallbackFactory.INSTANCE, this.getStorageProperties().getBloomFilterFalsePositiveRate(), buddyBreeFields, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this), !temp);
                btreeSearchOp = new ExternalBTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, (IStorageManagerInterface)rtcProvider, (IIndexLifecycleManagerProvider)rtcProvider, (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, bloomFilterKeyFields, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair((Object)btreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildRtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] keyFields, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        try {
            ExternalRTreeSearchOperatorDescriptor rtreeSearchOp;
            NoOpOperationCallbackFactory searchCallbackFactory;
            ARecordType recType = (ARecordType)this.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
            int numPrimaryKeys = DatasetUtils.getPartitioningKeys(dataset).size();
            boolean temp = dataset.getDatasetDetails().isTemp();
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex == null) {
                throw new AlgebricksException("Code generation error: no index " + indexName + " for dataset " + dataset.getDatasetName());
            }
            List<List<String>> secondaryKeyFields = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            int numSecondaryKeys = secondaryKeyFields.size();
            if (numSecondaryKeys != 1) {
                throw new AlgebricksException("Cannot use " + numSecondaryKeys + " fields as a key for the R-tree index. " + "There can be only one field as a key for the R-tree index.");
            }
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyFields.get(0), recType);
            IAType keyType = (IAType)keyTypePair.first;
            if (keyType == null) {
                throw new AlgebricksException("Could not find field " + secondaryKeyFields.get(0) + " in the schema.");
            }
            int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag());
            boolean isPointMBR = keyType.getTypeTag() == ATypeTag.POINT || keyType.getTypeTag() == ATypeTag.POINT3D;
            int numNestedSecondaryKeyFields = numDimensions * 2;
            IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numNestedSecondaryKeyFields];
            for (int i = 0; i < numNestedSecondaryKeyFields; ++i) {
                valueProviderFactories[i] = AqlPrimitiveValueProviderFactory.INSTANCE;
            }
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            int keysStartIndex = outputRecDesc.getFieldCount() - numNestedSecondaryKeyFields - numPrimaryKeys;
            if (retainInput) {
                keysStartIndex -= numNestedSecondaryKeyFields;
            }
            IBinaryComparatorFactory[] comparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(outputVars, (int)keysStartIndex, (int)numNestedSecondaryKeyFields, (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            ITypeTraits[] typeTraits = JobGenHelper.variablesToTypeTraits(outputVars, (int)keysStartIndex, (int)(numNestedSecondaryKeyFields + numPrimaryKeys), (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.splitProviderAndPartitionConstraintsForDataset(dataset.getDataverseName(), dataset.getDatasetName(), indexName, temp);
            ARecordType metaType = null;
            if (dataset.hasMetaPart()) {
                metaType = (ARecordType)this.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
            }
            IBinaryComparatorFactory[] primaryComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, metaType, context.getBinaryComparatorFactoryProvider());
            int[] btreeFields = new int[primaryComparatorFactories.length];
            for (int i = 0; i < btreeFields.length; ++i) {
                btreeFields[i] = i + numNestedSecondaryKeyFields;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] rtreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numNestedSecondaryKeyFields + numPrimaryKeys};
                rtreeFields = new int[numNestedSecondaryKeyFields + numPrimaryKeys];
                for (int i = 0; i < rtreeFields.length; ++i) {
                    rtreeFields[i] = i;
                }
            }
            IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)keyType.getTypeTag());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            Object object = searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new SecondaryIndexSearchOperationCallbackFactory();
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                IBinaryComparatorFactory[] deletedKeyBTreeCompFactories = this.getMergedComparatorFactories(comparatorFactories, primaryComparatorFactories);
                LSMRTreeWithAntiMatterTuplesDataflowHelperFactory idff = new LSMRTreeWithAntiMatterTuplesDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, deletedKeyBTreeCompFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, MetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), rtreeFields, filterTypeTraits, filterCmpFactories, filterFields, !temp, isPointMBR);
                rtreeSearchOp = new RTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, keyFields, (IIndexDataflowHelperFactory)idff, retainInput, retainMissing, context.getMissingWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                ExternalRTreeDataflowHelperFactory indexDataflowHelperFactory = new ExternalRTreeDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, IndexingConstants.getBuddyBtreeComparatorFactories(), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, MetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), this.getStorageProperties().getBloomFilterFalsePositiveRate(), new int[]{numNestedSecondaryKeyFields}, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this), !temp, isPointMBR);
                rtreeSearchOp = new ExternalRTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, keyFields, indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair((Object)rtreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc) {
        FileSplitDataSink fsds = (FileSplitDataSink)sink;
        FileSplitSinkId fssi = fsds.getId();
        FileSplit fs = fssi.getFileSplit();
        File outFile = new File(fs.getPath());
        String nodeId = fs.getNodeName();
        SinkWriterRuntimeFactory runtime = new SinkWriterRuntimeFactory(printColumns, printerFactories, outFile, this.getWriterFactory(), inputDesc);
        AlgebricksAbsolutePartitionConstraint apc = new AlgebricksAbsolutePartitionConstraint(new String[]{nodeId});
        return new Pair((Object)runtime, (Object)apc);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc, boolean ordered, JobSpecification spec) throws AlgebricksException {
        ResultSetDataSink rsds = (ResultSetDataSink)sink;
        ResultSetSinkId rssId = rsds.getId();
        ResultSetId rsId = rssId.getResultSetId();
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = this.resultSerializerFactoryProvider.getAqlResultSerializerFactoryProvider(printColumns, printerFactories, this.getWriterFactory());
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rsId, ordered, this.getResultAsyncMode(), resultSerializedAppenderFactory);
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getWriteResultRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        String dataverseName = ((DataSourceId)dataSource.getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numKeys = keys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[numKeys] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numKeys + 1] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            String indexName = primaryIndex.getIndexName();
            ARecordType metaType = null;
            if (dataset.hasMetaPart()) {
                metaType = (ARecordType)this.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
            }
            String itemTypeName = dataset.getItemTypeName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            ITypeTraits[] typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType, null);
            IBinaryComparatorFactory[] comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, metaType, context.getBinaryComparatorFactoryProvider());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName, indexName, temp);
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = DatasetUtils.createFilterFields(dataset);
            int[] btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            TreeIndexBulkLoadOperatorDescriptor btreeBulkLoad = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, null, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, false, numElementsHint, true, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), true, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp), (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            return new Pair((Object)btreeBulkLoad, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.INSERT, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, recordDesc, context, spec, bulkload, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.DELETE, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, recordDesc, context, spec, false, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.INSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, bulkload, null, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.DELETE, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, false, null, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexUpsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalFilteringKeys, ILogicalExpression filterExpr, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.UPSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalFilteringKeys, filterExpr, recordDesc, context, spec, false, prevSecondaryKeys, prevAdditionalFilteringKey);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getTokenizerRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        Index secondaryIndex;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        if (inputSchemas.length <= 0) {
            throw new AlgebricksException("TokenizeOperator can not operate without any input variable.");
        }
        IOperatorSchema inputSchema = inputSchemas[0];
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        switch (secondaryIndex.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getBinaryTokenizerRuntime(dataverseName, datasetName, indexName, inputSchema, propagatedSchema, primaryKeys, secondaryKeys, recordDesc, spec, secondaryIndex.getIndexType());
            }
        }
        throw new AlgebricksException("Currently, we do not support TokenizeOperator for the index type: " + secondaryIndex.getIndexType());
    }

    public long getCardinalityPerPartitionHint(Dataset dataset) throws MetadataException, AlgebricksException {
        String numElementsHintString = dataset.getHints().get("CARDINALITY");
        long numElementsHint = numElementsHintString == null ? 1000000L : Long.parseLong(numElementsHintString);
        int numPartitions = 0;
        List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(this.mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
        for (String nd : nodeGroup) {
            numPartitions += ClusterStateManager.INSTANCE.getNodePartitionsCount(nd);
        }
        return numElementsHint /= (long)numPartitions;
    }

    protected IAdapterFactory getConfiguredAdapterFactory(Dataset dataset, String adapterName, Map<String, String> configuration, ARecordType itemType, boolean isPKAutoGenerated, List<List<String>> primaryKeys, ARecordType metaType) throws AlgebricksException {
        try {
            configuration.put("dataverse", dataset.getDataverseName());
            IAdapterFactory adapterFactory = AdapterFactoryProvider.getAdapterFactory((ILibraryManager)this.libraryManager, (String)adapterName, configuration, (ARecordType)itemType, (ARecordType)metaType);
            Index filesIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName().concat("FilesIndex"));
            if (filesIndex != null && filesIndex.getPendingOp() == 0) {
                List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(this.mdTxnCtx, dataset);
                Iterator<ExternalFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getPendingOp() == DatasetConfig.ExternalFilePendingOp.PENDING_NO_OP) continue;
                    iterator.remove();
                }
            }
            return adapterFactory;
        }
        catch (Exception e) {
            throw new AlgebricksException("Unable to create adapter", (Throwable)e);
        }
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public static ILinearizeComparatorFactory proposeLinearizer(ATypeTag keyType, int numKeyFields) throws AlgebricksException {
        return LinearizeComparatorFactoryProvider.INSTANCE.getLinearizeComparatorFactory((Object)keyType, true, numKeyFields / 2);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForDataset(String dataverseName, String datasetName, String targetIdxName, boolean temp) throws AlgebricksException {
        FileSplit[] splits = this.splitsForDataset(this.mdTxnCtx, dataverseName, datasetName, targetIdxName, temp);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForDataverse(String dataverse) {
        return SplitsAndConstraintsUtil.splitProviderAndPartitionConstraintsForDataverse(dataverse);
    }

    public FileSplit[] splitsForDataset(MetadataTransactionContext mdTxnCtx, String dataverseName, String datasetName, String targetIdxName, boolean temp) throws AlgebricksException {
        return SplitsAndConstraintsUtil.splitsForDataset(mdTxnCtx, dataverseName, datasetName, targetIdxName, temp);
    }

    public DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, String dataverseName, String adapterName) throws MetadataException {
        DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
        }
        return adapter;
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        return ClusterStateManager.INSTANCE.getClusterLocations();
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForFilesIndex(String dataverseName, String datasetName, String targetIdxName, boolean create) throws AlgebricksException {
        return SplitsAndConstraintsUtil.splitProviderAndPartitionConstraintsForFilesIndex(this.mdTxnCtx, dataverseName, datasetName, targetIdxName, create);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDataLookupRuntime(JobSpecification jobSpec, Dataset dataset, Index secondaryIndex, int[] ridIndexes, boolean retainInput, IVariableTypeEnvironment typeEnv, List<LogicalVariable> outputVars, IOperatorSchema opSchema, JobGenContext context, MetadataProvider metadataProvider, boolean retainMissing) throws AlgebricksException {
        try {
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo;
            IAType itemType = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getItemTypeName()).getDatatype();
            ExternalDatasetDetails datasetDetails = (ExternalDatasetDetails)dataset.getDatasetDetails();
            LookupAdapterFactory adapterFactory = AdapterFactoryProvider.getLookupAdapterFactory((ILibraryManager)this.libraryManager, datasetDetails.getProperties(), (ARecordType)((ARecordType)itemType), (int[])ridIndexes, (boolean)retainInput, (boolean)retainMissing, (IMissingWriterFactory)context.getMissingWriterFactory());
            try {
                compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
            }
            catch (MetadataException e) {
                throw new AlgebricksException(" Unabel to create merge policy factory for external dataset", (Throwable)((Object)e));
            }
            boolean temp = datasetDetails.isTemp();
            ExternalBTreeDataflowHelperFactory indexDataflowHelperFactory = new ExternalBTreeDataflowHelperFactory((ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, metadataProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, metadataProvider), !temp);
            RecordDescriptor outRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = metadataProvider.splitProviderAndPartitionConstraintsForFilesIndex(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName().concat("FilesIndex"), false);
            NoOpOperationCallbackFactory searchOpCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new SecondaryIndexSearchOperationCallbackFactory();
            ExternalLookupOperatorDescriptor op = new ExternalLookupOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, adapterFactory, outRecDesc, indexDataflowHelperFactory, retainInput, appContext.getIndexLifecycleManagerProvider(), appContext.getStorageManagerInterface(), (IFileSplitProvider)spPc.first, dataset.getDatasetId(), metadataProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), (ISearchOperationCallbackFactory)searchOpCallbackFactory, retainMissing, context.getMissingWriterFactory(), LSMIndexUtil.getMetadataPageManagerFactory());
            return new Pair((Object)op, spPc.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getUpsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema inputSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, LogicalVariable payload, List<LogicalVariable> filterKeys, List<LogicalVariable> additionalNonFilterFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = this.findDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + ((DataSourceId)dataSource.getId()).getDataverseName());
        }
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int numOfAdditionalFields = additionalNonFilterFields == null ? 0 : additionalNonFilterFields.size();
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + numOfAdditionalFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = inputSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = inputSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx2 = inputSchema.findVariable(filterKeys.get(0));
            fieldPermutation[i++] = idx2;
        }
        if (additionalNonFilterFields != null) {
            for (LogicalVariable var : additionalNonFilterFields) {
                idx = inputSchema.findVariable(var);
                fieldPermutation[i++] = idx;
            }
        }
        try {
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            String indexName = primaryIndex.getIndexName();
            String itemTypeName = dataset.getItemTypeName();
            String itemTypeDataverseName = dataset.getItemTypeDataverseName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, itemTypeDataverseName, itemTypeName).getDatatype();
            ARecordType metaItemType = DatasetUtils.getMetaType(this, dataset);
            ITypeTraits[] typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType, metaItemType);
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            IBinaryComparatorFactory[] comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, metaItemType, context.getBinaryComparatorFactoryProvider());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            int[] primaryKeyFields = new int[numKeys];
            for (i = 0; i < numKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = DatasetUtils.createFilterFields(dataset);
            int[] btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            TempDatasetPrimaryIndexModificationOperationCallbackFactory modificationCallbackFactory = temp ? new TempDatasetPrimaryIndexModificationOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, IndexOperation.UPSERT, 0) : new UpsertOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, IndexOperation.UPSERT, 0, dataset.hasMetaPart());
            LockThenSearchOperationCallbackFactory searchCallbackFactory = new LockThenSearchOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMBTreeDataflowHelperFactory idfh = new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), true, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp);
            ITypeTraits[] outputTypeTraits = new ITypeTraits[recordDesc.getFieldCount() + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
            ISerializerDeserializer[] outputSerDes = new ISerializerDeserializer[recordDesc.getFieldCount() + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
            int f = 0;
            outputSerDes[f] = FormatUtils.getDefaultFormat().getSerdeProvider().getSerializerDeserializer((Object)itemType);
            ++f;
            if (dataset.hasMetaPart()) {
                outputSerDes[f] = FormatUtils.getDefaultFormat().getSerdeProvider().getSerializerDeserializer((Object)metaItemType);
                outputTypeTraits[f] = FormatUtils.getDefaultFormat().getTypeTraitProvider().getTypeTrait((Object)metaItemType);
                ++f;
            }
            int fieldIdx = -1;
            if (numFilterFields > 0) {
                String filterField = DatasetUtils.getFilterField(dataset).get(0);
                for (i = 0; i < itemType.getFieldNames().length && !itemType.getFieldNames()[i].equals(filterField); ++i) {
                }
                fieldIdx = i;
                outputTypeTraits[f] = FormatUtils.getDefaultFormat().getTypeTraitProvider().getTypeTrait((Object)itemType.getFieldTypes()[fieldIdx]);
                outputSerDes[f] = FormatUtils.getDefaultFormat().getSerdeProvider().getSerializerDeserializer((Object)itemType.getFieldTypes()[fieldIdx]);
                ++f;
            }
            for (int j = 0; j < recordDesc.getFieldCount(); ++j) {
                outputTypeTraits[j + f] = recordDesc.getTypeTraits()[j];
                outputSerDes[j + f] = recordDesc.getFields()[j];
            }
            RecordDescriptor outputRecordDesc = new RecordDescriptor(outputSerDes, outputTypeTraits);
            LSMTreeUpsertOperatorDescriptor op = new LSMTreeUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, outputRecordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, (IIndexDataflowHelperFactory)idfh, null, true, indexName, context.getMissingWriterFactory(), (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)searchCallbackFactory, null, LSMIndexUtil.getMetadataPageManagerFactory());
            op.setType(itemType);
            op.setFilterIndex(fieldIdx);
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDatasetDataScannerRuntime(JobSpecification jobSpec, IAType itemType, IAdapterFactory adapterFactory, IDataFormat format) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        if (itemType.getTypeTag() != ATypeTag.RECORD) {
            throw new AlgebricksException("Can only scan datasets of records.");
        }
        ISerializerDeserializer payloadSerde = format.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        ExternalDataScanOperatorDescriptor dataScanner = new ExternalDataScanOperatorDescriptor(jobSpec, scannerDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    private Pair<IBinaryComparatorFactory[], ITypeTraits[]> getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(List<List<String>> sidxKeyFieldNames, List<IAType> sidxKeyFieldTypes, List<List<String>> pidxKeyFieldNames, ARecordType recType, DatasetConfig.DatasetType dsType, boolean hasMeta, List<Integer> primaryIndexKeyIndicators, List<Integer> secondaryIndexIndicators, ARecordType metaType) throws AlgebricksException {
        IAType keyType;
        int i;
        int sidxKeyFieldCount = sidxKeyFieldNames.size();
        int pidxKeyFieldCount = pidxKeyFieldNames.size();
        ITypeTraits[] typeTraits = new ITypeTraits[sidxKeyFieldCount + pidxKeyFieldCount];
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[sidxKeyFieldCount + pidxKeyFieldCount];
        for (i = 0; i < sidxKeyFieldCount; ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(sidxKeyFieldTypes.get(i), sidxKeyFieldNames.get(i), hasMeta && secondaryIndexIndicators.get(i) == 1 ? metaType : recType);
            keyType = (IAType)keyPairType.first;
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
        }
        int j = 0;
        while (j < pidxKeyFieldCount) {
            keyType = null;
            try {
                switch (dsType) {
                    case INTERNAL: {
                        keyType = hasMeta && primaryIndexKeyIndicators.get(j) == 1 ? metaType.getSubFieldType(pidxKeyFieldNames.get(j)) : recType.getSubFieldType(pidxKeyFieldNames.get(j));
                        break;
                    }
                    case EXTERNAL: {
                        keyType = IndexingConstants.getFieldType((int)j);
                        break;
                    }
                    default: {
                        throw new AlgebricksException("Unknown Dataset Type");
                    }
                }
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            ++j;
            ++i;
        }
        return new Pair((Object)comparatorFactories, (Object)typeTraits);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertOrDeleteRuntime(IndexOperation indexOp, IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> additionalNonFilteringFields) throws AlgebricksException {
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, ((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = keys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + (additionalNonFilteringFields == null ? 0 : additionalNonFilteringFields.size())];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            fieldPermutation[i++] = idx2;
        }
        if (additionalNonFilteringFields != null) {
            for (LogicalVariable variable : additionalNonFilteringFields) {
                idx = propagatedSchema.findVariable(variable);
                fieldPermutation[i++] = idx;
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            String indexName = primaryIndex.getIndexName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), dataset.getItemTypeName()).getDatatype();
            ARecordType metaItemType = DatasetUtils.getMetaType(this, dataset);
            ITypeTraits[] typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType, metaItemType);
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            IBinaryComparatorFactory[] comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, metaItemType, context.getBinaryComparatorFactoryProvider());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            int[] primaryKeyFields = new int[numKeys];
            for (i = 0; i < numKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = DatasetUtils.createFilterFields(dataset);
            int[] btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            TempDatasetPrimaryIndexModificationOperationCallbackFactory modificationCallbackFactory = temp ? new TempDatasetPrimaryIndexModificationOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0) : new PrimaryIndexModificationOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0, dataset.hasMetaPart());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMBTreeDataflowHelperFactory idfh = new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), true, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, true, numElementsHint, true, (IIndexDataflowHelperFactory)idfh, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, null, true, indexName, null, (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation indexOp, IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey) throws AlgebricksException {
        Index secondaryIndex;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        ArrayList<LogicalVariable> prevAdditionalFilteringKeys = null;
        if (indexOp == IndexOperation.UPSERT && prevAdditionalFilteringKey != null) {
            prevAdditionalFilteringKeys = new ArrayList<LogicalVariable>();
            prevAdditionalFilteringKeys.add(prevAdditionalFilteringKey);
        }
        AsterixTupleFilterFactory filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
        switch (secondaryIndex.getIndexType()) {
            case BTREE: {
                return this.getBTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case RTREE: {
                return this.getRTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getInvertedIndexRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, secondaryIndex.getIndexType(), bulkload, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
        }
        throw new AlgebricksException(indexOp.name() + "Insert, upsert, and delete not implemented for index type: " + secondaryIndex.getIndexType());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBTreeRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] bloomFilterKeyFields = new int[secondaryKeys.size()];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            int idx3;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            int k = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            for (LogicalVariable varKey : primaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            if (numFilterFields > 0) {
                int idx4;
                prevFieldPermutation[numKeys] = idx4 = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        String itemTypeName = dataset.getItemTypeName();
        try {
            Object op;
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            this.validateRecordType(itemType);
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] btreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numKeys};
                btreeFields = new int[numKeys];
                for (int k = 0; k < btreeFields.length; ++k) {
                    btreeFields[k] = k;
                }
            }
            List<List<String>> secondaryKeyNames = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            ITypeTraits[] typeTraits = new ITypeTraits[numKeys];
            IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[numKeys];
            for (i = 0; i < secondaryKeys.size(); ++i) {
                Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(i), secondaryKeyNames.get(i), recType);
                IAType keyType = (IAType)keyPairType.first;
                comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
                typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            }
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
                typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            TempDatasetSecondaryIndexModificationOperationCallbackFactory modificationCallbackFactory = temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0, dataset.hasMetaPart());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMBTreeDataflowHelperFactory idfh = new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), false, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMTreeUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, false, indexName, null, (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, prevFieldPermutation, LSMIndexUtil.getMetadataPageManagerFactory()) : new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), false, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp), (ITupleFilterFactory)filterFactory, false, indexName, null, (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair(op, splitsAndConstraint.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRTreeRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        try {
            Object op;
            int idx;
            Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            String itemTypeName = dataset.getItemTypeName();
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            this.validateRecordType(itemType);
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
            IAType spatialType = (IAType)keyPairType.first;
            boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
            int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
            int numSecondaryKeys = dimension * 2;
            int numPrimaryKeys = primaryKeys.size();
            int numKeys = numSecondaryKeys + numPrimaryKeys;
            ITypeTraits[] typeTraits = new ITypeTraits[numKeys];
            IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[numSecondaryKeys];
            int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
            int[] fieldPermutation = new int[numKeys + numFilterFields];
            int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
            int i = 0;
            int j = 0;
            for (LogicalVariable logicalVariable : secondaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
                ++i;
            }
            for (LogicalVariable logicalVariable : primaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
                modificationCallbackPrimaryKeyFields[j] = i++;
                ++j;
            }
            if (numFilterFields > 0) {
                int idx2;
                fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            }
            int[] prevFieldPermutation = null;
            if (indexOp == IndexOperation.UPSERT) {
                void var39_47;
                prevFieldPermutation = new int[numKeys + numFilterFields];
                i = 0;
                for (LogicalVariable varKey : prevSecondaryKeys) {
                    int idx3;
                    prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                    ++i;
                }
                boolean bl = false;
                while (var39_47 < numPrimaryKeys) {
                    prevFieldPermutation[var39_47 + i] = fieldPermutation[var39_47 + i];
                    ++i;
                    ++var39_47;
                }
                if (numFilterFields > 0) {
                    int n;
                    prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
                }
            }
            IAType iAType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
            IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numSecondaryKeys];
            for (i = 0; i < numSecondaryKeys; ++i) {
                comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)iAType, true);
                typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)iAType);
                valueProviderFactories[i] = AqlPrimitiveValueProviderFactory.INSTANCE;
            }
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            ARecordType metaItemType = DatasetUtils.getMetaType(this, dataset);
            IBinaryComparatorFactory[] primaryComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, metaItemType, context.getBinaryComparatorFactoryProvider());
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            int[] btreeFields = new int[primaryComparatorFactories.length];
            for (int k = 0; k < btreeFields.length; ++k) {
                btreeFields[k] = k + numSecondaryKeys;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] rtreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numSecondaryKeys + numPrimaryKeys};
                rtreeFields = new int[numSecondaryKeys + numPrimaryKeys];
                for (int k = 0; k < rtreeFields.length; ++k) {
                    rtreeFields[k] = k;
                }
            }
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            TempDatasetSecondaryIndexModificationOperationCallbackFactory modificationCallbackFactory = temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 1) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 1, dataset.hasMetaPart());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            IBinaryComparatorFactory[] deletedKeyBTreeCompFactories = this.getMergedComparatorFactories(comparatorFactories, primaryComparatorFactories);
            LSMRTreeWithAntiMatterTuplesDataflowHelperFactory idff = new LSMRTreeWithAntiMatterTuplesDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, deletedKeyBTreeCompFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, MetadataProvider.proposeLinearizer(iAType.getTypeTag(), comparatorFactories.length), rtreeFields, filterTypeTraits, filterCmpFactories, filterFields, !temp, isPointMBR);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, primaryComparatorFactories, btreeFields, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idff, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMTreeUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, null, fieldPermutation, (IIndexDataflowHelperFactory)idff, (ITupleFilterFactory)filterFactory, false, indexName, null, (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, prevFieldPermutation, LSMIndexUtil.getMetadataPageManagerFactory()) : new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, null, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idff, (ITupleFilterFactory)filterFactory, false, indexName, null, (IModificationOperationCallbackFactory)modificationCallbackFactory, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair(op, splitsAndConstraint.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInvertedIndexRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot create inverted index on dataset with composite primary key.");
        }
        if (secondaryKeys.size() > 1 && !isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        if (secondaryKeys.size() > 2 && isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var27_34;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl = false;
            while (var27_34 < primaryKeys.size()) {
                prevFieldPermutation[var27_34 + i] = fieldPermutation[var27_34 + i];
                ++i;
                ++var27_34;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        String string = dataset.getItemTypeName();
        try {
            Object op;
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), string).getDatatype();
            this.validateRecordType(itemType);
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            int numTokenFields = 0;
            if (!isPartitioned || secondaryKeys.size() > 1) {
                numTokenFields = secondaryKeys.size();
            } else if (isPartitioned && secondaryKeys.size() == 1) {
                numTokenFields = secondaryKeys.size() + 1;
            }
            ARecordType metaItemType = DatasetUtils.getMetaType(this, dataset);
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            IBinaryComparatorFactory[] tokenComparatorFactories = new IBinaryComparatorFactory[numTokenFields];
            IBinaryComparatorFactory[] invListComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, metaItemType, context.getBinaryComparatorFactoryProvider());
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenComparatorFactories[0] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)secondaryKeyType);
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenComparatorFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)ShortPointable.FACTORY);
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndex.getGramLength());
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] invertedIndexFields = null;
            int[] filterFieldsForNonBulkLoadOps = null;
            int[] invertedIndexFieldsForNonBulkLoadOps = null;
            if (filterTypeTraits != null) {
                int k;
                filterFields = new int[]{numTokenFields + primaryKeys.size()};
                invertedIndexFields = new int[numTokenFields + primaryKeys.size()];
                for (k = 0; k < invertedIndexFields.length; ++k) {
                    invertedIndexFields[k] = k;
                }
                filterFieldsForNonBulkLoadOps = new int[numFilterFields];
                filterFieldsForNonBulkLoadOps[0] = numKeys;
                invertedIndexFieldsForNonBulkLoadOps = new int[numKeys];
                for (k = 0; k < invertedIndexFieldsForNonBulkLoadOps.length; ++k) {
                    invertedIndexFieldsForNonBulkLoadOps[k] = k;
                }
            }
            IApplicationContextInfo appContext = (IApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            TempDatasetSecondaryIndexModificationOperationCallbackFactory modificationCallbackFactory = temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 2) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 2, dataset.hasMetaPart());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            Object indexDataFlowFactory = !isPartitioned ? new LSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMInvertedIndexIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, filterFields, filterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !temp) : new PartitionedLSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMInvertedIndexIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, filterFields, filterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMInvertedIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, false, numElementsHint, false, appContext.getStorageManagerInterface(), (IFileSplitProvider)splitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListComparatorFactories, tokenizerFactory, (IIndexDataflowHelperFactory)indexDataFlowFactory, (IPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            } else {
                op = indexOp == IndexOperation.UPSERT ? new LSMInvertedIndexUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), (IFileSplitProvider)splitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListComparatorFactories, tokenizerFactory, fieldPermutation, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, (IModificationOperationCallbackFactory)modificationCallbackFactory, indexName, prevFieldPermutation, LSMIndexUtil.getMetadataPageManagerFactory()) : new LSMInvertedIndexInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), (IFileSplitProvider)splitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListComparatorFactories, tokenizerFactory, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, (IModificationOperationCallbackFactory)modificationCallbackFactory, indexName, LSMIndexUtil.getMetadataPageManagerFactory());
            }
            return new Pair(op, splitsAndConstraint.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBinaryTokenizerRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema inputSchema, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, RecordDescriptor recordDesc, JobSpecification spec, DatasetConfig.IndexType indexType) throws AlgebricksException {
        int idx;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite primary key.");
        }
        if (secondaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite secondary key fields.");
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numKeys = inputSchema.getSize();
        ArrayList<LogicalVariable> otherKeys = new ArrayList<LogicalVariable>();
        if (inputSchema.getSize() > 0) {
            for (int k = 0; k < inputSchema.getSize(); ++k) {
                boolean found = false;
                for (LogicalVariable varKey : primaryKeys) {
                    if (varKey.equals((Object)inputSchema.getVariable(k))) {
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    for (LogicalVariable varKey : secondaryKeys) {
                        if (varKey.equals((Object)inputSchema.getVariable(k))) {
                            found = true;
                            break;
                        }
                        found = false;
                    }
                }
                if (found) continue;
                otherKeys.add(inputSchema.getVariable(k));
            }
        }
        int numTokenKeyPairFields = !isPartitioned ? 1 + numKeys : 2 + numKeys;
        int[] fieldPermutation = new int[numKeys];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        for (LogicalVariable varKey : otherKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        try {
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be tokenized.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypeEntries = secondaryIndex.getKeyFieldTypes();
            int numTokenFields = !isPartitioned ? secondaryKeys.size() : secondaryKeys.size() + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypeEntries.get(0), secondaryKeyExprs.get(0), recType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndex.getGramLength());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, dataset.getDatasetDetails().isTemp());
            ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[numTokenKeyPairFields];
            ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[numTokenKeyPairFields];
            ISerializerDeserializerProvider serdeProvider = FormatUtils.getDefaultFormat().getSerdeProvider();
            for (int k = 0; k < recordDesc.getFieldCount(); ++k) {
                tokenKeyPairFields[k] = recordDesc.getFields()[k];
                tokenKeyPairTypeTraits[k] = recordDesc.getTypeTraits()[k];
            }
            int tokenOffset = recordDesc.getFieldCount();
            tokenKeyPairFields[tokenOffset] = serdeProvider.getSerializerDeserializer((Object)secondaryKeyType);
            tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[0];
            ++tokenOffset;
            if (isPartitioned) {
                tokenKeyPairFields[tokenOffset] = ShortSerializerDeserializer.INSTANCE;
                tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[1];
            }
            RecordDescriptor tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
            int docField = fieldPermutation[fieldPermutation.length - 1];
            int[] keyFields = new int[numKeys];
            for (int k = 0; k < keyFields.length; ++k) {
                keyFields[k] = k;
            }
            BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, tokenKeyPairRecDesc, tokenizerFactory, docField, keyFields, isPartitioned, true);
            return new Pair((Object)tokenizerOp, splitsAndConstraint.second);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private IBinaryComparatorFactory[] getMergedComparatorFactories(IBinaryComparatorFactory[] comparatorFactories, IBinaryComparatorFactory[] primaryComparatorFactories) {
        int i;
        int btreeCompFactoriesCount = comparatorFactories.length + primaryComparatorFactories.length;
        IBinaryComparatorFactory[] btreeCompFactories = new IBinaryComparatorFactory[btreeCompFactoriesCount];
        for (i = 0; i < comparatorFactories.length; ++i) {
            btreeCompFactories[i] = comparatorFactories[i];
        }
        int j = 0;
        while (i < btreeCompFactoriesCount) {
            btreeCompFactories[i] = primaryComparatorFactories[j];
            ++i;
            ++j;
        }
        return btreeCompFactories;
    }

    private AsterixTupleFilterFactory createTupleFilterFactory(IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, ILogicalExpression filterExpr, JobGenContext context) throws AlgebricksException {
        if (filterExpr == null) {
            return null;
        }
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory filterEvalFactory = expressionRuntimeProvider.createEvaluatorFactory(filterExpr, typeEnv, inputSchemas, context);
        return new AsterixTupleFilterFactory(filterEvalFactory, context.getBinaryBooleanInspectorFactory());
    }

    private void validateRecordType(IAType itemType) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.RECORD) {
            throw new AlgebricksException("Only record types can be indexed.");
        }
    }
}

