/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.dataset.hints;

import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.metadata.dataset.hints.IHint;
import org.apache.asterix.runtime.util.AppContextInfo;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class DatasetHints {
    private static Set<IHint> hints = DatasetHints.initHints();

    public static Pair<Boolean, String> validate(String hintName, String value) {
        for (IHint h : hints) {
            if (!h.getName().equalsIgnoreCase(hintName.trim())) continue;
            return h.validateValue(value);
        }
        return new Pair((Object)false, (Object)("Unknown hint :" + hintName));
    }

    private static Set<IHint> initHints() {
        HashSet<IHint> hints = new HashSet<IHint>();
        hints.add(new DatasetCardinalityHint());
        hints.add(new DatasetNodegroupCardinalityHint());
        return hints;
    }

    public static class DatasetNodegroupCardinalityHint
    implements IHint {
        public static final String NAME = "NODEGROUP_CARDINALITY";
        public static final int DEFAULT = 1;

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Pair<Boolean, String> validateValue(String value) {
            boolean valid = true;
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    return new Pair((Object)false, (Object)"Value must be >= 0");
                }
                int numNodesInCluster = AppContextInfo.INSTANCE.getMetadataProperties().getNodeNames().size();
                if (numNodesInCluster < intValue) {
                    return new Pair((Object)false, (Object)("Value must be greater or equal to the existing number of nodes in cluster (" + numNodesInCluster + ")"));
                }
            }
            catch (NumberFormatException nfe) {
                valid = false;
                return new Pair((Object)valid, (Object)"Inappropriate value");
            }
            return new Pair((Object)true, null);
        }
    }

    public static class DatasetCardinalityHint
    implements IHint {
        public static final String NAME = "CARDINALITY";
        public static final long DEFAULT = 1000000L;

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Pair<Boolean, String> validateValue(String value) {
            boolean valid = true;
            try {
                long longValue = Long.parseLong(value);
                if (longValue < 0L) {
                    return new Pair((Object)false, (Object)"Value must be >= 0");
                }
            }
            catch (NumberFormatException nfe) {
                valid = false;
                return new Pair((Object)valid, (Object)"Inappropriate value");
            }
            return new Pair((Object)true, null);
        }
    }
}

