/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicyFactory;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.common.transactions.Resource;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.adapter.factory.GenericAdapterFactory;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.resource.LSMBTreeLocalResourceMetadata;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceFactoryProvider;
import org.apache.hyracks.api.application.INCApplicationContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.util.LSMBTreeUtils;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.ConstantMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.NoMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicyFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ILocalResourceFactory;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class MetadataBootstrap {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(MetadataBootstrap.class.getName());
    private static IAppRuntimeContext runtimeContext;
    private static IBufferCache bufferCache;
    private static IFileMapProvider fileMapProvider;
    private static IDatasetLifecycleManager dataLifecycleManager;
    private static ILocalResourceRepository localResourceRepository;
    private static IIOManager ioManager;
    private static String metadataNodeName;
    private static List<String> nodeNames;
    private static String outputDir;
    private static boolean isNewUniverse;
    private static final IMetadataIndex[] PRIMARY_INDEXES;
    private static IPropertiesProvider propertiesProvider;

    private MetadataBootstrap() {
    }

    public static void startUniverse(IPropertiesProvider asterixPropertiesProvider, INCApplicationContext ncApplicationContext, boolean isNewUniverse) throws RemoteException, ACIDException, MetadataException {
        MetadataBootstrap.setNewUniverse(isNewUniverse);
        runtimeContext = (IAppRuntimeContext)ncApplicationContext.getApplicationObject();
        propertiesProvider = asterixPropertiesProvider;
        MetadataProperties metadataProperties = propertiesProvider.getMetadataProperties();
        metadataNodeName = metadataProperties.getMetadataNodeName();
        nodeNames = metadataProperties.getNodeNames();
        dataLifecycleManager = runtimeContext.getDatasetLifecycleManager();
        localResourceRepository = runtimeContext.getLocalResourceRepository();
        bufferCache = runtimeContext.getBufferCache();
        fileMapProvider = runtimeContext.getFileMapManager();
        ioManager = ncApplicationContext.getIoManager();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            MetadataManager.INSTANCE.lock(mdTxnCtx, (byte)4);
            for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
                MetadataBootstrap.enlistMetadataDataset(PRIMARY_INDEXES[i]);
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Finished enlistment of metadata B-trees in " + (isNewUniverse ? "new" : "old") + " universe");
            }
            if (isNewUniverse) {
                MetadataBootstrap.insertInitialDataverses(mdTxnCtx);
                MetadataBootstrap.insertMetadataDatasets(mdTxnCtx, PRIMARY_INDEXES);
                MetadataBootstrap.insertMetadataDatatypes(mdTxnCtx);
                MetadataBootstrap.insertNodes(mdTxnCtx);
                MetadataBootstrap.insertInitialGroups(mdTxnCtx);
                MetadataBootstrap.insertInitialAdapters(mdTxnCtx);
                MetadataBootstrap.insertInitialFeedPolicies(mdTxnCtx);
                MetadataBootstrap.insertInitialCompactionPolicies(mdTxnCtx);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Finished creating metadata B-trees.");
                }
            }
            MetadataManager.INSTANCE.initializeDatasetIdFactory(mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw new MetadataException(e);
            }
            throw new MetadataException(e);
        }
    }

    private static void insertInitialDataverses(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String dataFormat = "org.apache.asterix.runtime.formats.NonTaggedDataFormat";
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse("Metadata", dataFormat, 0));
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, MetadataBuiltinEntities.DEFAULT_DATAVERSE);
    }

    public static void insertMetadataDatasets(MetadataTransactionContext mdTxnCtx, IMetadataIndex[] indexes) throws MetadataException {
        for (int i = 0; i < indexes.length; ++i) {
            InternalDatasetDetails id = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, indexes[i].getPartitioningExpr(), indexes[i].getPartitioningExpr(), null, indexes[i].getPartitioningExprType(), false, null, false);
            MetadataManager.INSTANCE.addDataset(mdTxnCtx, new Dataset(indexes[i].getDataverseName(), indexes[i].getIndexedDatasetName(), indexes[i].getDataverseName(), indexes[i].getPayloadRecordType().getTypeName(), indexes[i].getNodeGroupName(), "prefix", GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, id, new HashMap<String, String>(), DatasetConfig.DatasetType.INTERNAL, indexes[i].getDatasetId().getId(), 0));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datasets.");
        }
    }

    private static void getMetadataTypes(ArrayList<IAType> types) {
        for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
            types.add((IAType)PRIMARY_INDEXES[i].getPayloadRecordType());
        }
    }

    private static void insertMetadataDatatypes(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        ArrayList<IAType> types = new ArrayList<IAType>();
        types.addAll(BuiltinTypeMap.getAllBuiltinTypes());
        MetadataBootstrap.getMetadataTypes(types);
        for (int i = 0; i < types.size(); ++i) {
            MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype("Metadata", types.get(i).getTypeName(), types.get(i), false));
        }
        MetadataManager.INSTANCE.addDatatype(mdTxnCtx, MetadataBuiltinEntities.ANY_OBJECT_DATATYPE);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datatypes.");
        }
    }

    private static void insertNodes(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        for (String nodesName : nodeNames) {
            MetadataManager.INSTANCE.addNode(mdTxnCtx, new Node(nodesName, 0L, 0L));
        }
    }

    private static void insertInitialGroups(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        ArrayList<String> metadataGroupNodeNames = new ArrayList<String>();
        metadataGroupNodeNames.add(metadataNodeName);
        NodeGroup groupRecord = new NodeGroup("MetadataGroup", metadataGroupNodeNames);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, groupRecord);
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.addAll(nodeNames);
        NodeGroup defaultGroup = new NodeGroup("DEFAULT_NG_ALL_NODES", nodes);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, defaultGroup);
    }

    private static void insertInitialAdapters(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String[] builtInAdapterClassNames;
        for (String adapterClassName : builtInAdapterClassNames = new String[]{GenericAdapterFactory.class.getName()}) {
            DatasourceAdapter adapter = MetadataBootstrap.getAdapter(adapterClassName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting built-in adapters.");
        }
    }

    private static void insertInitialFeedPolicies(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        for (FeedPolicyEntity feedPolicy : BuiltinFeedPolicies.policies) {
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, feedPolicy);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished adding built-in feed policies.");
        }
    }

    private static void insertInitialCompactionPolicies(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String[] builtInCompactionPolicyClassNames;
        for (String policyClassName : builtInCompactionPolicyClassNames = new String[]{ConstantMergePolicyFactory.class.getName(), PrefixMergePolicyFactory.class.getName(), NoMergePolicyFactory.class.getName(), CorrelatedPrefixMergePolicyFactory.class.getName()}) {
            CompactionPolicy compactionPolicy = MetadataBootstrap.getCompactionPolicyEntity(policyClassName);
            MetadataManager.INSTANCE.addCompactionPolicy(mdTxnCtx, compactionPolicy);
        }
    }

    private static DatasourceAdapter getAdapter(String adapterFactoryClassName) throws MetadataException {
        try {
            String adapterName = ((IAdapterFactory)Class.forName(adapterFactoryClassName).newInstance()).getAlias();
            return new DatasourceAdapter(new AdapterIdentifier("Metadata", adapterName), adapterFactoryClassName, IDataSourceAdapter.AdapterType.INTERNAL);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Adapter", e);
        }
    }

    private static CompactionPolicy getCompactionPolicyEntity(String compactionPolicyClassName) throws MetadataException {
        try {
            String policyName = ((ILSMMergePolicyFactory)Class.forName(compactionPolicyClassName).newInstance()).getName();
            return new CompactionPolicy("Metadata", policyName, compactionPolicyClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Merge Policy Factory", e);
        }
    }

    public static void enlistMetadataDataset(IMetadataIndex index) throws HyracksDataException {
        long resourceID;
        BaseOperationTracker opTracker;
        ClusterPartition metadataPartition = propertiesProvider.getMetadataProperties().getMetadataPartition();
        int metadataDeviceId = metadataPartition.getIODeviceNum();
        String metadataPartitionPath = StoragePathUtil.prepareStoragePartitionPath((String)ClusterProperties.INSTANCE.getStorageDirectoryName(), (int)metadataPartition.getPartitionId());
        String resourceName = metadataPartitionPath + File.separator + index.getFileNameRelativePath();
        FileReference file = ioManager.getFileReference(metadataDeviceId, resourceName);
        List virtualBufferCaches = runtimeContext.getDatasetLifecycleManager().getVirtualBufferCaches(index.getDatasetId().getId(), metadataPartition.getIODeviceNum());
        ITypeTraits[] typeTraits = index.getTypeTraits();
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        int[] bloomFilterKeyFields = index.getBloomFilterKeyFields();
        Object object = opTracker = index.isPrimaryIndex() ? runtimeContext.getLSMBTreeOperationTracker(index.getDatasetId().getId()) : new BaseOperationTracker(index.getDatasetId().getId(), dataLifecycleManager.getDatasetInfo(index.getDatasetId().getId()));
        if (MetadataBootstrap.isNewUniverse()) {
            LSMBTree lsmBtree = LSMBTreeUtils.createLSMTree((IIOManager)ioManager, (List)virtualBufferCaches, (FileReference)file, (IBufferCache)bufferCache, (IFileMapProvider)fileMapProvider, (ITypeTraits[])typeTraits, (IBinaryComparatorFactory[])comparatorFactories, (int[])bloomFilterKeyFields, (double)runtimeContext.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)runtimeContext.getMetadataMergePolicyFactory().createMergePolicy(GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, (IResourceLifecycleManager)dataLifecycleManager), (ILSMOperationTracker)opTracker, (ILSMIOOperationScheduler)runtimeContext.getLSMIOScheduler(), (ILSMIOOperationCallback)LSMBTreeIOOperationCallbackFactory.INSTANCE.createIOOperationCallback(), (boolean)index.isPrimaryIndex(), null, null, null, null, (boolean)true, (IMetadataPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
            lsmBtree.create();
            resourceID = index.getResourceID();
            LSMBTreeLocalResourceMetadata localResourceMetadata = new LSMBTreeLocalResourceMetadata(typeTraits, comparatorFactories, bloomFilterKeyFields, index.isPrimaryIndex(), index.getDatasetId().getId(), metadataPartition.getPartitionId(), runtimeContext.getMetadataMergePolicyFactory(), GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, null, null, null, null);
            PersistentLocalResourceFactoryProvider localResourceFactoryProvider = new PersistentLocalResourceFactoryProvider(arg_0 -> MetadataBootstrap.lambda$enlistMetadataDataset$eac95714$1((Resource)localResourceMetadata, arg_0), 1);
            ILocalResourceFactory localResourceFactory = localResourceFactoryProvider.getLocalResourceFactory();
            localResourceRepository.insert(localResourceFactory.createLocalResource(resourceID, resourceName, 5, metadataPartition.getPartitionId()));
            dataLifecycleManager.register(file.getRelativePath(), (Object)lsmBtree);
        } else {
            LocalResource resource = localResourceRepository.get(file.getRelativePath());
            if (resource == null) {
                throw new HyracksDataException("Could not find required metadata indexes. Please delete " + (String)propertiesProvider.getMetadataProperties().getTransactionLogDirs().get(runtimeContext.getTransactionSubsystem().getId()) + " to intialize as a new instance. (WARNING: all data will be lost.)");
            }
            resourceID = resource.getId();
            if (index.getResourceID() != resource.getId()) {
                throw new HyracksDataException("Resource Id doesn't match expected metadata index resource id");
            }
            LSMBTree lsmBtree = (LSMBTree)dataLifecycleManager.get(file.getRelativePath());
            if (lsmBtree == null) {
                lsmBtree = LSMBTreeUtils.createLSMTree((IIOManager)ioManager, (List)virtualBufferCaches, (FileReference)file, (IBufferCache)bufferCache, (IFileMapProvider)fileMapProvider, (ITypeTraits[])typeTraits, (IBinaryComparatorFactory[])comparatorFactories, (int[])bloomFilterKeyFields, (double)runtimeContext.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)runtimeContext.getMetadataMergePolicyFactory().createMergePolicy(GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, (IResourceLifecycleManager)dataLifecycleManager), (ILSMOperationTracker)opTracker, (ILSMIOOperationScheduler)runtimeContext.getLSMIOScheduler(), (ILSMIOOperationCallback)LSMBTreeIOOperationCallbackFactory.INSTANCE.createIOOperationCallback(), (boolean)index.isPrimaryIndex(), null, null, null, null, (boolean)true, (IMetadataPageManagerFactory)LSMIndexUtil.getMetadataPageManagerFactory());
                dataLifecycleManager.register(file.getRelativePath(), (Object)lsmBtree);
            }
        }
        index.setResourceID(resourceID);
        index.setFile(file);
    }

    public static String getOutputDir() {
        return outputDir;
    }

    public static String getMetadataNodeName() {
        return metadataNodeName;
    }

    public static void startDDLRecovery() throws MetadataException {
        MetadataTransactionContext mdTxnCtx = null;
        MetadataManager.INSTANCE.acquireWriteLatch();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting DDL recovery ...");
        }
        try {
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            List<Dataverse> dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
            for (Dataverse dataverse : dataverses) {
                MetadataBootstrap.recoverDataverse(mdTxnCtx, dataverse);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Completed DDL recovery.");
            }
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw new MetadataException(e);
        }
        finally {
            MetadataManager.INSTANCE.releaseWriteLatch();
        }
    }

    private static void recoverDataverse(MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws MetadataException {
        if (dataverse.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverse.getDataverseName());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Dropped a pending dataverse: " + dataverse.getDataverseName());
            }
        } else {
            List<Dataset> datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
            for (Dataset dataset : datasets) {
                MetadataBootstrap.recoverDataset(mdTxnCtx, dataset);
            }
        }
    }

    private static void recoverDataset(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws MetadataException {
        List<Index> indexes;
        if (dataset.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataset(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Dropped a pending dataset: " + dataset.getDataverseName() + "." + dataset.getDatasetName());
            }
        } else {
            indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            for (Index index : indexes) {
                if (index.getPendingOp() == 0) continue;
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), index.getIndexName());
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Dropped a pending index: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + index.getIndexName());
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName())).isEmpty()) {
            List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
            for (ExternalFile file : files) {
                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Dropped an external file: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + file.getFileNumber());
            }
        }
    }

    public static boolean isNewUniverse() {
        return isNewUniverse;
    }

    public static void setNewUniverse(boolean isNewUniverse) {
        MetadataBootstrap.isNewUniverse = isNewUniverse;
    }

    private static /* synthetic */ Resource lambda$enlistMetadataDataset$eac95714$1(Resource localResourceMetadata, int partition) {
        return localResourceMetadata;
    }

    static {
        PRIMARY_INDEXES = new IMetadataIndex[]{MetadataPrimaryIndexes.DATAVERSE_DATASET, MetadataPrimaryIndexes.DATASET_DATASET, MetadataPrimaryIndexes.DATATYPE_DATASET, MetadataPrimaryIndexes.INDEX_DATASET, MetadataPrimaryIndexes.NODE_DATASET, MetadataPrimaryIndexes.NODEGROUP_DATASET, MetadataPrimaryIndexes.FUNCTION_DATASET, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, MetadataPrimaryIndexes.FEED_DATASET, MetadataPrimaryIndexes.FEED_POLICY_DATASET, MetadataPrimaryIndexes.LIBRARY_DATASET, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET};
    }
}

